%define _unpackaged_files_terminate_build 1

Name: aircrack-ng
Version: 1.6
Release: alt2

Summary: 802.11 WEP and WPA-PSK key recovery program
License: GPLv2+
Group: Networking/Other

Url: http://aircrack-ng.org

# https://github.com/aircrack-ng/aircrack-ng.git
Source: %name-%version.tar
Patch0: %name-%version-alt-build.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: gcc-c++
BuildRequires: libssl-devel libsqlite3-devel
BuildRequires: libnl-devel
BuildRequires: libpcre-devel
BuildRequires: libpcap-devel
BuildRequires: zlib-devel
BuildRequires: ethtool

Requires: iw rfkill ethtool

%description
Aircrack is an 802.11 WEP and WPA-PSK keys cracking program that can
recover keys once enough data packets have been captured.
It implements the standard FMS attack along with some optimizations
like KoreK attacks, thus making the attack much faster compared to
other WEP cracking tools. In fact aircrack is a set of tools for
auditing wireless networks.

%package devel
Group: Development/C++
Summary: Development files for %name

%description devel
Development files for %name

%prep
%setup
%patch0 -p1

# change python shebangs to python3
find . -name '*.py' | xargs sed -i \
	-e '1s|^#!/usr/bin/env python$|#!/usr/bin/env python3|' \
	-e '1s|^#!/usr/bin/python$|#!/usr/bin/python3|' \
	%nil

find scripts -type f | xargs sed -i \
	-e '1s|^#!/usr/bin/env python$|#!/usr/bin/env python3|' \
	-e '1s|^#!/usr/bin/python$|#!/usr/bin/python3|' \
	%nil

%build
export PYTHON=%__python3

%autoreconf
%configure --with-sqlite3 --with-experimental --with-ext-scripts
%make_build

%install
%makeinstall_std

%if "%python3_sitelibdir_noarch" != "%python3_sitelibdir"
mkdir -pv %buildroot%python3_sitelibdir
mv %buildroot%python3_sitelibdir_noarch/* %buildroot%python3_sitelibdir/
%endif

%files
%_bindir/*
%_sbindir/*
%_libdir/*.so*
%_man1dir/*
%_man8dir/*
%python3_sitelibdir/*
%_defaultdocdir/%name

%files devel
%_includedir/*

%changelog
