Epoch: 1
Group: System/Base
BuildRequires: /proc rpm-build-java
BuildRequires: jpackage-11-compat
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global base_name   daemon
%global short_name  commons-%{base_name}

Name:           apache-commons-daemon
Summary:        Defines API to support an alternative invocation mechanism
Version:        1.2.4
Release:        alt1_1jpp11
License:        ASL 2.0

URL:            https://commons.apache.org/%{base_name}
Source0:        https://archive.apache.org/dist/commons/%{base_name}/source/%{short_name}-%{version}-src.tar.gz

Patch0:         00-configure-java-os.patch

BuildRequires:  autoconf
BuildRequires:  dos2unix
BuildRequires:  gcc
BuildRequires:  xmlto

BuildRequires:  maven-local
BuildRequires:  mvn(junit:junit)
BuildRequires:  mvn(org.apache.commons:commons-parent:pom:)
Source44: import.info
Patch33: apache-commons-daemon-1.2.0-e2k.patch

%description
The scope of this package is to define an API in line with the current
Java Platform APIs to support an alternative invocation mechanism
which could be used instead of the public static void main(String[])
method.  This specification covers the behavior and life cycle of what
we define as Java daemons, or, in other words, non interactive
Java applications.


%package        jsvc
Group: System/Base
Summary:        Java daemon launcher
Provides:       jsvc = 1:%{version}-%{release}

%description    jsvc
Java daemon launcher.


%package        javadoc
Group: Development/Java
Summary:        API documentation for %{name}
Requires:       jpackage-utils
BuildArch:      noarch

%description    javadoc
API documentation for apache-commons-daemon.


%prep
%setup -q -n %{short_name}-%{version}-src
%patch0 -p1

# mark example files as non-executable
chmod 644 src/samples/*

# convert to correct end-of-line format
dos2unix -k -n src/samples/ProcrunServiceInstall.cmd src/samples/ProcrunServiceInstall.cmd.new
rm src/samples/ProcrunServiceInstall.cmd
mv src/samples/ProcrunServiceInstall.cmd.new src/samples/ProcrunServiceInstall.cmd

# build manpage for jsvc
%patch33 -p1
cd src/native/unix
xmlto man man/jsvc.1.xml


%build
# build native jsvc
pushd src/native/unix
sh support/buildconf.sh

%configure --with-java=%{java_home}
%make_build
popd

# build jars
%mvn_file  : %{short_name} %{name}
%mvn_alias : org.apache.commons:%{short_name}
%mvn_build -- -Dmaven.compiler.source=1.8 -Dmaven.compiler.target=1.8 -Dmaven.javadoc.source=1.8 -Dmaven.compiler.release=8


%install
# install native jsvc
install -Dpm 755 src/native/unix/jsvc $RPM_BUILD_ROOT%{_bindir}/jsvc
install -Dpm 644 src/native/unix/jsvc.1 $RPM_BUILD_ROOT%{_mandir}/man1/jsvc.1

%mvn_install


%files -f .mfiles
%doc LICENSE.txt PROPOSAL.html NOTICE.txt RELEASE-NOTES.txt src/samples
%doc src/docs/*

%files jsvc
%doc LICENSE.txt NOTICE.txt
%{_bindir}/jsvc
%{_mandir}/man1/jsvc.1*

%files javadoc -f .mfiles-javadoc
%doc LICENSE.txt NOTICE.txt


%changelog
