# atlas is not built yet :(
ExclusiveArch: %ix86 x86_64
Group: Sciences/Mathematics
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-cmake rpm-macros-fedora-compat rpm-macros-generic-compat
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
%define fedora 32
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           armadillo
Version:        10.2.0
Release:        alt1_2
Summary:        Fast C++ matrix library with syntax similar to MATLAB and Octave

License:        ASL 2.0
URL:            http://arma.sourceforge.net/
Source:         http://sourceforge.net/projects/arma/files/%{name}-%{version}.tar.xz

%if (0%{?rhel} || (0%{?fedora} && 0%{?fedora} < 33))
%undefine __cmake_in_source_build
%endif

%if 0%{?fedora} > 32
%global extra_options -DALLOW_FLEXIBLAS_LINUX=ON
BuildRequires:  flexiblas-devel
%else
%global extra_options %{nil}
%endif

BuildRequires:  gcc-c++
BuildRequires:  ctest cmake
BuildRequires:  liblapack-devel, libarpack-ng-devel
BuildRequires:  libhdf5-devel
%{!?openblas_arches:%global openblas_arches x86_64 %{ix86} armv7hl %{power64} aarch64}
%ifarch %{openblas_arches}
BuildRequires:  libopenblas-devel
%endif
BuildRequires:  libsuperlu-devel libatlas-devel
Source44: import.info


%description
Armadillo is a C++ linear algebra library (matrix maths)
aiming towards a good balance between speed and ease of use.
Integer, floating point and complex numbers are supported,
as well as a subset of trigonometric and statistics functions.
Various matrix decompositions are provided through optional
integration with LAPACK and ATLAS libraries.
A delayed evaluation approach is employed (during compile time)
to combine several operations into one and reduce (or eliminate)
the need for temporaries. This is accomplished through recursive
templates and template meta-programming.
This library is useful if C++ has been decided as the language
of choice (due to speed and/or integration capabilities), rather
than another language like Matlab or Octave.

%package -n libarmadillo10
Summary:        Shared library for the %name library
Group:          System/Libraries

%description -n libarmadillo10
Armadillo is a C++ linear algebra library (matrix maths)
aiming towards a good balance between speed and ease of use.
Integer, floating point and complex numbers are supported,
as well as a subset of trigonometric and statistics functions.
Various matrix decompositions are provided through optional
integration with LAPACK and ATLAS libraries.
A delayed evaluation approach is employed (during compile time)
to combine several operations into one and reduce (or eliminate)
the need for temporaries. This is accomplished through recursive
templates and template meta-programming.
This library is useful if C++ has been decided as the language
of choice (due to speed and/or integration capabilities), rather
than another language like Matlab or Octave.

This package contains the shared library.


%package -n libarmadillo-devel
Group: Sciences/Mathematics
Summary:        Development headers and documentation for the Armadillo C++ library
Requires:       libarmadillo10 = %EVR
%ifarch %{openblas_arches}
%endif
Provides: %name-devel = %EVR


%description -n libarmadillo-devel
This package contains files necessary for development using the
Armadillo C++ library. It contains header files, example programs,
and user documentation (API reference guide).


%prep
%setup -q

sed -i 's/\r//' README.md
rm -rf examples/*win64*


%build
%{fedora_v2_cmake} %{extra_options}
%fedora_v2_cmake_build


%install
%fedora_v2_cmake_install


%check
%{fedora_v2_cmake} %{extra_options} -DBUILD_SMOKE_TEST=ON
make -C "%{_vpath_builddir}"
%fedora_v2_ctest


%files -n libarmadillo10
%doc --no-dereference LICENSE.txt NOTICE.txt
%_libdir/libarmadillo.so.10
%_libdir/libarmadillo.so.10.*

%files -n libarmadillo-devel
%{_libdir}/libarmadillo.so
%{_libdir}/pkgconfig/%{name}.pc
%{_includedir}/armadillo
%{_includedir}/armadillo_bits/
%{_datadir}/Armadillo/
%doc README.md
%doc index.html
%doc docs.html
%doc examples
%doc armadillo_icon.png
%doc mex_interface
%doc armadillo_nicta_2010.pdf
%doc rcpp_armadillo_csda_2014.pdf
%doc armadillo_joss_2016.pdf
%doc armadillo_spcs_2017.pdf
%doc armadillo_lncs_2018.pdf
%doc armadillo_solver_2020.pdf


%changelog
