%define _unpackaged_files_terminate_build 1
%define docdir %_docdir/%name-%version

Name: asciidoc
Version: 9.1.0
Release: alt2

Summary: asciidoc converts an AsciiDoc text file to DocBook, HTML or LinuxDoc

Group: Text tools
License: GPLv2+
Url: http://www.methods.co.nz/asciidoc/

Packager: Artem Zolochevskiy <azol@altlinux.ru>

BuildArch: noarch

# Source-url: https://github.com/asciidoc-py/asciidoc-py/archive/refs/tags/%version.tar.gz
Source: %name-%version.tar

BuildRequires(pre): rpm-build-vim rpm-build-tex
BuildRequires: python3-devel
BuildRequires: xsltproc docbook-style-xsl
#BuildRequires: source-highlight
#BuildRequires: graphviz


%description
The asciidoc(1) command translates the AsciiDoc text file to the backend
formatted file.

AsciiDoc is a text document format for writing short documents, articles,
books and UNIX man pages.


%package a2x
Summary: a2x converts AsciiDoc text file to PDF, XHTML, HTML Help, manpage or plain text
Group: Text tools
Requires: %name = %version-%release
Requires: xsltproc docbook-style-xsl
Requires: w3m
# Requires: lynx
# Requires: source-highlight

%description a2x
A DocBook toolchain wrapper script that translates an AsciiDoc text
file to PDF, XHTML (single page or chunked), man page, HTML Help
or plain text formats. PDF, XHTML, man page and HTML Help formats are
generated using the asciidoc(1)/xsltproc(1)/DocBook XSL Stylesheets
toolchain. Plain text is produced by passing asciidoc(1) generated HTML
through lynx(1). The htmlhelp format option generates .hhp, .hhc and
.html files suitable for compilation to an HTML Help .chm file.

Install asciidoc-latex if you need generate PDF files.

%package latex
Summary: Support for asciidoc LaTeX output
Group: Text tools
Requires: %name = %EVR
Requires: dblatex

%description latex
Support for asciidoc LaTeX output.


%package doc
Summary: AsciiDoc documentation and examples
Group: Development/Documentation

%description doc
The asciidoc(1) command translates the AsciiDoc text file to the backend
formatted file.

AsciiDoc is a text document format for writing short documents, articles,
books and UNIX man pages.

This package contains AsciiDoc documentation and examples.


%package -n vim-plugin-asciidoc-syntax
Summary: Vim syntax highlighting for AsciiDoc files
Group: Editors
Requires: vim-common

%description -n vim-plugin-asciidoc-syntax
The asciidoc(1) command translates the AsciiDoc text file to the backend
formatted file.

AsciiDoc is a text document format for writing short documents, articles,
books and UNIX man pages.

This package contains AsciiDoc syntax highlighting support for Vim.


%prep
%setup

%build
%autoreconf
%configure docdir=%docdir

%install
%make_install DESTDIR=%buildroot install docs
mv -f %buildroot%_bindir/%name.py %buildroot%_bindir/%name
mv -f %buildroot%_bindir/a2x.py %buildroot%_bindir/a2x
install -pD %buildroot%_sysconfdir/%name/dblatex/asciidoc-dblatex.sty \
  %buildroot%_texmfmain/tex/latex/%name/asciidoc-dblatex.sty

# install vim plugin
#install -d %buildroot{%vim_ftdetect_dir,%vim_syntax_dir}
#install -p -m644 vim/ftdetect/asciidoc_filetype.vim %buildroot%vim_ftdetect_dir/
#install -p -m644 vim/syntax/asciidoc.vim %buildroot%vim_syntax_dir/

# install extra docs for asciidoc package
install -d %buildroot%docdir/
install -pD -m644 COPYRIGHT  %buildroot%docdir/

rm -rfv %buildroot%{_sysconfdir}/asciidoc/filters/music

%files
%_bindir/%name

%dir %_sysconfdir/%name
%config(noreplace) %_sysconfdir/%name/*.conf
%dir %_sysconfdir/%name/filters/
%config(noreplace) %_sysconfdir/%name/filters/code/
%config(noreplace) %_sysconfdir/%name/filters/graphviz/
%config(noreplace) %_sysconfdir/%name/filters/source/
%_sysconfdir/%name/images
%_sysconfdir/%name/themes
%config(noreplace) %_sysconfdir/%name/javascripts/
%config(noreplace) %_sysconfdir/%name/stylesheets/

%_man1dir/%name.*
%_man1dir/test%name.*
%dir %docdir
%doc %docdir/BUGS.txt
%doc %docdir/CHANGELOG.txt
%doc %docdir/COPYRIGHT
%doc %docdir/README.asciidoc

%files a2x
%_bindir/a2x
%config(noreplace) %_sysconfdir/%name/docbook-xsl/
%_man1dir/a2x.*

%files latex
%config(noreplace) %_sysconfdir/%name/filters/latex/
%config(noreplace) %_sysconfdir/%name/filters/unwraplatex.py
%config(noreplace) %_sysconfdir/%name/dblatex/
%_texmfmain/tex/latex/%name/

%files doc
%doc %docdir
%exclude %docdir/BUGS.txt
%exclude %docdir/CHANGELOG.txt
%exclude %docdir/COPYRIGHT
%exclude %docdir/README.asciidoc

%if 0
%files -n vim-plugin-asciidoc-syntax
#vim_ftdetect_dir/*.vim
%vim_syntax_dir/*.vim
%endif

%changelog
