Name: ash
Version: 0.5.8
Release: alt1.2e5842258.p10.1

%define real_name dash

Summary: A smaller version of the Bourne shell
License: BSD
Group: Shells

Packager: Alexey Gladkov <legion@altlinux.ru>

Url:	http://gondor.apana.org.au/~herbert/dash/

Source: %name-%version.tar
Patch0: dash-0.5.4-alt-losetup.patch
Patch2: dash-0.5.6-alt-cleanup-warnings.patch
Patch6: dash-0.5.3-makefile-cflags.patch
Patch7: dash-0.5.6-string_literal.patch
Patch8: dash-0.5.8-logical-not-parentheses.patch

PreReq: coreutils, grep
Conflicts: mkinitrd <= 1:1.7
Provides: dash

# Automatically added by buildreq on Mon Jun 19 2006
BuildRequires: glibc-devel-static

%description
The %name shell is a clone of Berkeley's Bourne shell.  Ash
supports all of the standard sh shell commands, but is considerably
smaller than bash.  The %name shell lacks some features (for example,
command-line histories), but needs a lot less memory.

You should install %name if you need a lightweight shell with many of the
same capabilities as the bash shell.

%package static
Summary: A smaller version of the Bourne shell statically linked
License: BSD
Group: Shells

%description static
The %name shell is a clone of Berkeley's Bourne shell.  Ash
supports all of the standard sh shell commands, but is considerably
smaller than bash.  The %name shell lacks some features (for example,
command-line histories), but needs a lot less memory.

You should install %name if you need a lightweight shell with many of the
same capabilities as the bash shell.

This version is statically compiled.

%prep
%setup -q
%patch0 -p1
%patch2 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1

sed -i -e 's,\$(tempfile),`mktemp -t ash.XXXXXX`,' src/mkbuiltins

%build
BUILD_FLAGS="%optflags_warnings -Wunused-function -Wunused-label -Wunused-variable -Wunused-value"

%autoreconf
%define _configure_script ../configure
rm -rf build-dynamic build-static
mkdir -p build-dynamic build-static

cd build-dynamic
	export CFLAGS="$BUILD_FLAGS -Werror"
	%configure --disable-dependency-tracking
	%make_build
	mv src/%real_name sh.dynamic
cd -

cd build-static
	export CFLAGS="$BUILD_FLAGS -Werror"
	%configure --disable-dependency-tracking --enable-static
	%make_build 
	mv src/%real_name sh.static
cd -

%install
mkdir -p %buildroot/lib/mkinitrd/initramfs/bin

install -m755 -pD build-dynamic/sh.dynamic %buildroot/bin/%name
install -m755 -pD build-static/sh.static %buildroot/bin/%name.static
ln -s %name %buildroot/bin/dash

install -m644 -pD src/%real_name.1 %buildroot/%_man1dir/%name.1
ln -s %name.1 %buildroot/%_man1dir/dash.1

%files
/bin/%name
/bin/dash
%_man1dir/*

%files static
/bin/%name.static

%changelog
