%def_disable snapshot

%define ver_major 2.38
%define api_ver 2.0
%define _libexecdir %_prefix/libexec
%def_enable introspection
%def_disable gtk_doc
%def_disable check

Name: at-spi2-atk
Version: %ver_major.0
Release: alt1

Summary: A GTK+ module that bridges ATK to D-Bus at-spi
Group: Accessibility
License: LGPLv2+
Url: http://www.linuxfoundation.org/en/AT-SPI_on_D-Bus

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

%define glib_ver 2.32
%define core_ver 2.38.0
%define atk_ver 2.34.0

Requires: at-spi2-core >= %core_ver

BuildRequires(pre): meson
BuildRequires: libdbus-devel libgio-devel >= %glib_ver libatk-devel >= %atk_ver
BuildRequires: libat-spi2-core-devel >= %core_ver libxml2-devel libX11-devel libICE-devel libSM-devel
BuildRequires: gtk-doc

%description
at-spi allows assistive technologies to access GTK-based applications.
Essentially it exposes the internals of applications for automation, so
tools such as screen readers, magnifiers, or even scripting interfaces
can query and interact with GUI controls.

This version of at-spi is a major break from previous versions. It has
been completely rewritten to use D-Bus rather than ORBIT/CORBA for its
transport protocol.

This package includes a gtk-modules that bridges ATK to the new D-Bus
based at-spi.

%package devel
Summary: Development files for atk-bridge
Group: Development/C
Requires: %name = %version-%release

%description devel
This package provides development files for atk-bridge library.

%prep
%setup

%build
%meson %{?_enable_gtk_doc:-Ddocs=true}
%meson_build

%install
%meson_install
%find_lang %name

%check
export LD_LIBRARY_PATH=%buildroot%_libdir
%meson_test

%files -f %name.lang
%_libdir/libatk-bridge-%api_ver.so.*
%_libdir/gtk-2.0/modules/libatk-bridge.so
%_libdir/gnome-settings-daemon-3.0/gtk-modules/at-spi2-atk.desktop
%doc AUTHORS README NEWS


%files devel
%dir %_includedir/%name
%dir %_includedir/%name/%api_ver
%_includedir/%name/%api_ver/atk-bridge.h
%_libdir/libatk-bridge-%api_ver.so
%_pkgconfigdir/atk-bridge-%api_ver.pc

%changelog
