# Ensure no unpackaged files
%global _unpackaged_files_terminate_build 1

# wc-config --cflags to add -I/usr/include/wx-3.1
# wx-config --libs: https://github.com/audacity/audacity/issues/552
# libmp3lame: https://github.com/audacity/audacity/issues/2166
%add_optflags %(wx-config --cflags || :) -DDISABLE_DYNAMIC_LOADING_LAME=1
%define add_libs %(wx-config --libs || :) -lmp3lame

Name: audacity
Version: 3.1.3
Release: alt1

Summary: Cross-platform audio editor
Summary(ru_RU.UTF-8): Кроссплатформенный звуковой редактор
License: GPL
Group: Sound

Url: http://audacity.sourceforge.net/
# https://www.fosshub.com/Audacity.html/audacity-manual-%{version}.zip
# https://github.com/audacity/audacity/releases
# https://github.com/audacity/audacity-manual
# https://github.com/audacity/audacity/archive/%{commit}.tar.gz
Source0: %name-minsrc-%version.tar
Source1: %name-%version-help-en.tar
# XXX
Source2: loffice-libcxx-wrapper.sh

Patch0001: 0001-Add-keywords-to-desktop-file-fix-exec-command.patch
Patch0002: 0002-Use-home-directory-for-temp-dir-instead-of-var-tmp-t.patch
Patch0003: 0003-Fix-building-with-system-sbsms.patch
Patch0004: 0004-Force-GTK-3.0.patch
# https://github.com/audacity/audacity/issues/2163
Patch0005: 0005-Do-not-create-file-in-strange-place.patch

# Patches needed to compile against wxWidgets 3.1.6.
# Sent upstream in https://github.com/audacity/audacity/pull/2776
Patch0006: wx316_bitmaps.patch
Patch0007: wx316_customLanguages.patch

BuildRequires: gcc-c++
BuildRequires: cmake
# -Daudacity_conan_enabled=Off is a temporary workaround according to
# https://github.com/audacity/audacity/pull/1030
#BuildRequires: conan
%ifarch %e2k
BuildRequires: chrpath
%endif
BuildRequires: patchelf
BuildRequires: gettext-devel
BuildRequires: ImageMagick
BuildRequires: ladspa_sdk
BuildRequires: liblame-devel
BuildRequires: libportmidi-devel
# Requires wxWidgets built without STL
BuildRequires: libwxGTK3.2-devel
BuildRequires: zip
BuildRequires: pkgconfig(alsa)
BuildRequires: pkgconfig(expat)
BuildRequires: pkgconfig(fftw3)
BuildRequires: pkgconfig(flac++)
BuildRequires: pkgconfig(id3tag)
BuildRequires: pkgconfig(flac)
BuildRequires: pkgconfig(fftw3)
BuildRequires: pkgconfig(gtk+-3.0)
BuildRequires: pkgconfig(glib-2.0)
BuildRequires: pkgconfig(jack)
BuildRequires: pkgconfig(libavformat)
BuildRequires: pkgconfig(lilv-0)
BuildRequires: pkgconfig(libjpeg)
BuildRequires: pkgconfig(lv2)
BuildRequires: pkgconfig(mad)
BuildRequires: pkgconfig(ogg)
BuildRequires: pkgconfig(opus)
BuildRequires: pkgconfig(portaudio-2.0)
BuildRequires: pkgconfig(samplerate)
BuildRequires: pkgconfig(sbsms)
BuildRequires: pkgconfig(sndfile)
BuildRequires: pkgconfig(soundtouch)
BuildRequires: pkgconfig(soxr)
BuildRequires: pkgconfig(speex)
BuildRequires: pkgconfig(sqlite3)
BuildRequires: pkgconfig(suil-0)
BuildRequires: pkgconfig(twolame)
BuildRequires: pkgconfig(uuid)
BuildRequires: pkgconfig(udev)
BuildRequires: pkgconfig(vamp-hostsdk)
BuildRequires: pkgconfig(vorbis)
BuildRequires: pkgconfig(vorbisenc)
BuildRequires: pkgconfig(vorbisfile)
BuildRequires: pkgconfig(zlib)
# %%autopatch macro appeared in 4.0.4-alt133
BuildRequires: rpm-build >= 4.0.4-alt133

# Dummy dependency from dlopen()'ed library, without ABI tracking, track at least soname
# https://github.com/audacity/audacity/issues/2161
# If soname becomes >58, the build will not fail, but needed functionality will stop working!
# XXX ALT would better have %%_isa macro
%if "%_lib" == "lib64"
Requires: libavcodec.so.58()(64bit)
%else
Requires: libavcodec.so.58
%endif

%description
Audacity is a program that lets you manipulate digital audio waveforms.
It imports many sound file formats, including WAV, AIFF, AU, IRCAM,
MP3, and Ogg Vorbis. It supports all common editing operations such
as Cut, Copy, and Paste, plus it will mix tracks and let you apply
plug-in effects to any part of a sound.

%description -l ru_RU.UTF-8
Audacity - программа, которая дает возможность обрабатывать звукозаписи
в цифровом виде. Она может импортировать множество аудиоформатов, в т.ч.
WAV, AIFF, AU, IRCAM, MP3, Ogg Vorbis, и поддерживает все основные
операции редактирования, такие как Вырезать, Скопировать, Вставить,
а также возможность микширования дорожек и применения эффектов,
предоставляемых подключаемыми модулями, к любой части звука.

%package manual
Summary: Audacity manual (offline install)
Group: Documentation
BuildArch: noarch

%description manual
Audacity Manual can be installed locally if preferred, or accessed
on-line if internet connection is available.

For the most up to date manual content, use the on-line manual.

%prep
%setup -n %name-src-%version
%autopatch -p1

%ifarch %e2k
# EDG frontend bug workaround
sed -i "/struct alignas/{N;N;s/alignas(.*)//;s/{/{alignas(64)/}" src/AudioIO.h
sed -i "/std::initializer_list/s/static//" src/prefs/GUIPrefs.cpp
%endif

%build
# src/RevisionIdent.h is in src/.gitignore and may be missing,
# what leads to build errors, but it's empty in release tarballs
# https://github.com/audacity/audacity/issues/2163
echo > src/RevisionIdent.h

export ADD_LIBS="%add_libs"
install -m0755 %SOURCE2 ./g++
export CXX="$PWD/g++"
export CC="$(command -v gcc)"

%cmake \
%ifarch %e2k
  -DCMAKE_SKIP_INSTALL_RPATH:BOOL=OFF \
  -DCMAKE_INSTALL_RPATH:PATH='$ORIGIN' \
%endif
  -Daudacity_lib_preference:STRING=system \
  -Daudacity_has_networking=no \
  -Daudacity_conan_enabled=Off \
  -Daudacity_obey_system_dependencies=On \
  -Daudacity_use_ffmpeg:STRING=loaded \
  -Daudacity_use_libavcodec:STRING=system \
  -Daudacity_use_libavformat:STRING=system \
  -Daudacity_use_libavutil:STRING=system \
  -Daudacity_use_libmp3lame:STRING=system \
  -Daudacity_use_libflac:STRING=system \
  -Daudacity_use_libid3tag:STRING=system \
  -Daudacity_use_libsndfile:STRING=system \
  -Daudacity_use_libsoxr:STRING=system \
  -Daudacity_use_libtwolame:STRING=system \
  -Daudacity_use_libuuid:STRING=system \
  -Daudacity_use_libvamp:STRING=system \
  -Daudacity_use_libvorbis:STRING=system \
  -Daudacity_use_lv2:STRING=system \
  -Daudacity_use_sbsms:STRING=system \
  -Daudacity_use_soundtouch:STRING=system \
  -Daudacity_use_portaudio:STRING=system \
  -Daudacity_use_portsmf:STRING=local \
  -Daudacity_use_midi:STRING=system \
  -DAUDACITY_BUILD_LEVEL=2 \
  -DAUDACITY_SUFFIX:STRING=""

%cmake_build

%install
%cmakeinstall_std
tar -xf %SOURCE1 -C %buildroot%_datadir/%name
rm -rf %buildroot%_defaultdocdir/%name
rm -rf %buildroot%_datadir/%name/include
# Remove a helper script that runs audacity in GitHub CI builds
rm -rf %buildroot%_prefix/%name

# Remove absolute RPATHs
# https://github.com/audacity/audacity/pull/1030#issuecomment-873630620
# https://github.com/audacity/audacity/issues/2165
%ifarch %e2k
# patchelf damages e2k binaries
setrpath="chrpath -r"
%else
setrpath="patchelf --set-rpath"
%endif
$setrpath '$ORIGIN/../%_lib/audacity' %buildroot%_bindir/audacity
find %buildroot%_libdir/audacity -name '*.so' -print | while read -r line
do
	$setrpath '$ORIGIN' "$line"
done

%find_lang %name

%check
p="$(patchelf --print-needed %buildroot/%_bindir/audacity)"
# upstream seems to assume statically linking bundled libsbsms,
# verify that system one is used
echo "$p" | grep -q sbsms
# mp3lame can be either dlopen'ed or linked explicitly,
# ensure that a system library is linked explicitly
echo "$p" | grep -q libmp3lame
# https://github.com/audacity/audacity/issues/2161
#echo "$p" | grep -q libavcodec

%files -f %name.lang
%doc CHANGELOG.txt CODE_OF_CONDUCT.md CONTRIBUTING.md LICENSE.txt README.txt README.md
%_bindir/audacity
%_libdir/audacity
%_mandir/man?/*
%_iconsdir/*/*/apps/%name.svg
%_iconsdir/hicolor/*/%name.png
%dir %_datadir/%name
%exclude %_datadir/%name/help
%_datadir/%name/*
%_datadir/applications/%name.desktop
%_datadir/mime/packages/%name.xml
%_datadir/metainfo/%name.appdata.xml
%_datadir/icons/hicolor/*/apps/%name.*
%_pixmapsdir/*.xpm

%files manual
%dir %_datadir/%name
%_datadir/%name/help

%changelog
