%define _unpackaged_files_terminate_build 1
%def_disable static
%def_without bootstrap
%def_with ldap
%def_without prelude

Name: audit
Version: 3.1.2
Release: alt1
Summary: User space tools for Linux kernel 2.6+ auditing
License: GPL
Group: Monitoring
URL: https://people.redhat.com/sgrubb/audit/
Source: %name-%version.tar
Patch0: %name-%version-alt.patch

Requires: lib%{name}1 = %EVR
Requires: service >= 0.5.26-alt1

%if_without bootstrap
# Automatically added by buildreq on Wed Mar 04 2009
BuildRequires(pre): rpm-build-python3
BuildRequires: libkrb5-devel perl-XML-Parser python-devel swig intltool
BuildRequires: python3-devel
BuildRequires: libcap-ng-devel
%endif

%{?_enable_static:BuildRequires: glibc-devel-static}
%{?_with_prelude:BuildRequires: libprelude-devel}
%{?_with_ldap:BuildRequires: libldap-devel}

%description
The audit package contains the user space utilities for
storing and searching the audit records generate by
the audit subsystem in the Linux 2.6+ kernel.

%package -n lib%{name}1
Summary: Dynamic library for audit framework
License: LGPL
Group: System/Libraries
Provides: lib%name = %EVR
Obsoletes: libaudit = 2.0.4-alt1

%description -n lib%{name}1
This package contains the dynamic libraries needed for
applications to use the audit framework.

%package -n libauparse0
Summary: Dynamic library for audit framework
License: LGPL
Group: System/Libraries
Conflicts: lib%name = 2.0.4-alt1
Conflicts: lib%name < 1.7.16-alt2

%description -n libauparse0
This package contains the dynamic libraries needed for
applications to use the audit framework.

%package -n lib%name-devel
Summary: Header files and static library for libaudit
License: LGPL
Group: Development/C
Requires: lib%{name}1 = %EVR
Requires: libauparse0 = %EVR

%description -n lib%name-devel
This package contains the static libraries and header
files needed for developing applications that need to use the audit
framework libraries.

%package -n python-module-%name
Summary: Python bindings for libaudit
License: LGPL
Group: Development/Python
Requires: lib%{name}1 = %EVR

%description -n python-module-%name
The python-module-%name package contains the bindings so that libaudit
and libauparse can be used by python.

%package -n python3-module-%name
Summary: Python3 bindings for libaudit
License: LGPL
Group: Development/Python3
Requires: lib%{name}1 = %EVR

%description -n python3-module-%name
The python3-module-%name package contains the bindings so that libaudit
and libauparse can be used by python.

%prep
%setup
%patch0 -p1

%build
%autoreconf

%configure \
	--sbindir=/sbin \
	--libdir=%_libdir \
	--with-aarch64 \
	--with-arm \
	--with-libcap-ng=auto \
	--without-golang \
	--enable-experimental \
	--with-io_uring \
%if_with bootstrap
	--without-python \
	--without-python3 \
%else
	--enable-gssapi-krb5 \
%endif
	%{?!_with_ldap:--disable-zos-remote} \
	%{subst_enable static} \
	%{subst_with prelude}

%make_build

%install
%makeinstall_std

install -d %buildroot%_logdir/%name
install -d %buildroot/%_libdir/%name

#move shared library to %_lib
install -d %buildroot/%_lib
mv %buildroot/%_libdir/*.so.* %buildroot/%_lib/
for i in libaudit libauparse;do
LIBNAME=$(readlink %buildroot/%_libdir/$i.so)
ln -sf  ../../%_lib/${LIBNAME##*/}  %buildroot/%_libdir/$i.so
done

#replace init script
install -Dpm755 %name.init %buildroot/%_initdir/%{name}d

#install rotate script
install -Dpm755 %name.cron %buildroot/%_sysconfdir/cron.weekly/%{name}d

install -pD -m644 init.d/%{name}d.service %buildroot%_unitdir/%{name}d.service
install -pD -m755 init.d/%{name}d.condrestart %buildroot/usr/libexec/service/legacy-actions/%{name}d/condrestart
install -pD -m755 init.d/%{name}d.rotate %buildroot/usr/libexec/service/legacy-actions/%{name}d/rotate
install -pD -m755 init.d/%{name}d.stop %buildroot/usr/libexec/service/legacy-actions/%{name}d/stop
install -pD -m755 init.d/%{name}d.restart %buildroot/usr/libexec/service/legacy-actions/%{name}d/restart
install -pD -m644 rules/10-base-config.rules %buildroot%_sysconfdir/%name/rules.d/10-base-config.rules
install -pD -m755 init.d/%{name}-functions %buildroot/usr/libexec/audit-functions

%post
%post_service %{name}d
if [ $1 -gt 1 ]; then
       service %{name}d condrestart ||:
fi

%preun
%preun_service %{name}d
if [ $1 -eq 0 ]; then
	service %{name}d stop ||:
fi

%files
%doc README ChangeLog contrib
%config(noreplace) %_sysconfdir/cron.weekly/%{name}d
%config(noreplace) %_sysconfdir/sysconfig/auditd
%_initdir/%{name}d
%attr(700,root,root) %_logdir/%name
%config %_unitdir/%{name}d.service

/sbin/ausearch
/sbin/aureport
%_bindir/auvirt
%attr(750,root,root) /sbin/auditctl
%attr(750,root,root) /sbin/augenrules
%attr(750,root,root) /sbin/auditd
%attr(750,root,root) /sbin/autrace
%attr(750,root,root) /sbin/audisp-remote
%attr(750,root,root) /sbin/audisp-syslog
%attr(750,root,root) /sbin/audisp-af_unix
%attr(750,root,root) /sbin/audisp-ids
%attr(750,root,root) /sbin/audisp-statsd
%if_with prelude
%attr(750,root,root) /sbin/audisp-prelude
%endif
%if_with ldap
%attr(750,root,root) /sbin/audispd-zos-remote
%endif
%attr(750,root,root) %_bindir/aulastlog
%attr(750,root,root) %_bindir/aulast
%attr(750,root,root) %_bindir/ausyscall


%_man5dir/*
%_man8dir/*
%_man7dir/*

%_datadir/%name/

%attr(700,root,root) %dir %_sysconfdir/%name
%config(noreplace) %attr(600,root,root) %_sysconfdir/%name/auditd.conf
%config(noreplace) %attr(600,root,root) %_sysconfdir/%name/audit-stop.rules
%attr(700,root,root) %dir %_sysconfdir/%name/rules.d
%config(noreplace) %attr(600,root,root) %_sysconfdir/%name/rules.d/*.rules

%attr(700,root,root) %dir %_sysconfdir/audit/plugins.d
%config(noreplace) %attr(640,root,root) /etc/audit/plugins.d/*.conf

%config(noreplace) %attr(640,root,root) /etc/audit/audisp-remote.conf
%config(noreplace) %attr(640,root,root) /etc/audit/zos-remote.conf
%config(noreplace) %attr(640,root,root) /etc/audit/ids.conf
%config(noreplace) %attr(640,root,root) /etc/audit/audisp-statsd.conf

%attr(700,root,root) %dir %_libdir/audit
/usr/libexec/service/legacy-actions/%{name}d

/usr/libexec/audit-functions

%files -n lib%{name}1
/%_lib/libaudit.so.*
%config(noreplace) %attr(600,root,root) /etc/libaudit.conf

%files -n libauparse0
/%_lib/libauparse.so.*

%files -n lib%name-devel
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*
%_man3dir/*
%_aclocaldir/%name.m4

%if_without bootstrap
%files -n python-module-%name
%python_sitelibdir/*

%files -n python3-module-%name
%python3_sitelibdir/*
%endif

%changelog
