Group: Development/Tools
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/bison /usr/bin/expect /usr/bin/flex /usr/bin/m4 /usr/bin/runtest gcc-c++ texinfo zlib-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define target avr

Name:           %{target}-binutils
Version:        2.35
Release:        alt1_1
Epoch:          2
Summary:        Cross Compiling GNU binutils targeted at %{target}
License:        GPLv2+
URL:            http://www.gnu.org/software/binutils/
Source0:        ftp://ftp.gnu.org/pub/gnu/binutils/binutils-%{version}.tar.xz
Source1:        README.fedora
#add widespread options to avr-size: --format=avr -mcu=XX
Patch1: http://distribute.atmel.no/tools/opensource/avr-gcc/binutils-2.20.1/30-binutils-2.20.1-avr-size.patch
Patch2: avr-binutils-config.patch

BuildRequires:  gawk makeinfo gcc
#for autoreconf:
BuildRequires:  gettext-tools libasprintf-devel autoconf automake
Provides: bundled(libiberty)
Source44: import.info

%description
This is a Cross Compiling version of GNU binutils, which can be used to
assemble and link binaries for the %{target} platform, instead of for the
native %{_arch} platform.


%prep
%setup -q -c
pushd binutils-%{version}
%patch1 -p2 -b .avr-size
%patch2 -p1 -b .config

# We call configure directly rather than via macros, thus if
# we are using LTO, we have to manually fix the broken configure
# scripts
pushd libiberty
autoconf -f
popd
pushd intl
autoconf -f
popd

popd 
cp %{SOURCE1} .

# known to fail on (arm?)
rm binutils-*/ld/testsuite/ld-elf/pr22450.*

# first build with old cc?
[ %version = 2.35 ] && rm binutils-*/ld/testsuite/ld-elf/notes.exp

%build

mkdir -p build
pushd build
CFLAGS="$RPM_OPT_FLAGS" ../binutils-%{version}/configure --prefix=%{_prefix} \
  --libdir=%{_libdir} --mandir=%{_mandir} --infodir=%{_infodir} \
  --target=%{target} --disable-werror --disable-nls
%make_build
popd

%check
cd build
%ifnarch %ix86 %arm
# on x86 can't find proper config, export does not ot help for gas
# export DEJAGNU=`pwd`/binutils/site.exp
make check
%endif

%install
pushd build
make install DESTDIR=$RPM_BUILD_ROOT
popd
# these are for win targets only
rm -f $RPM_BUILD_ROOT%{_mandir}/man1/%{target}-{dlltool,windres}.1
# we don't want these as we are a cross version
rm -r $RPM_BUILD_ROOT%{_infodir}
rm    $RPM_BUILD_ROOT%{_libdir}/libiberty.a ||:

%pre
# upgrade from binutils 2.26
if [ -L /usr/avr ]; then
  echo link /usr/avr detected. removing...
  rm /usr/avr
fi




%files
%doc --no-dereference binutils-%{version}/COPYING binutils-%{version}/COPYING.LIB
%doc binutils-%{version}/README README.fedora
%{_prefix}/%{target}
%{_bindir}/%{target}-*
%{_mandir}/man1/%{target}-*.1*


%changelog
