%define oldname bean-validation-api
Group: Development/Java
# BEGIN SourceDeps(oneline):
BuildRequires: rpm-build-java
# END SourceDeps(oneline)
BuildRequires: /proc
BuildRequires: jpackage-1.8-compat
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%version is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define version 1.1.0
%global namedreltag .Final
%global namedversion %{version}%{?namedreltag}

Name:             bean-validation-api1
Version:          1.1.0
Release:          alt2_11jpp8
Summary:          Bean Validation API (JSR 349)
License:          ASL 2.0
URL:              http://beanvalidation.org/
Source0:          https://github.com/beanvalidation/beanvalidation-api/archive/%{namedversion}.tar.gz

BuildRequires:    maven-local
BuildRequires:    mvn(org.apache.felix:maven-bundle-plugin)
BuildRequires:    mvn(org.apache.maven.surefire:surefire-testng)
BuildRequires:    mvn(org.testng:testng)

BuildArch:        noarch
Source44: import.info

%description
This package contains Bean Validation (JSR-349) API.

%package javadoc
Group: Development/Java
Summary:          Javadoc for %{oldname}
BuildArch: noarch

%description javadoc
This package contains the API documentation for %{oldname}.

%prep
%setup -q -n beanvalidation-api-%{namedversion}

# Disable javadoc jar
%pom_xpath_remove "pom:build/pom:plugins/pom:plugin[pom:artifactId='maven-javadoc-plugin']/pom:executions"
# Disable source jar
%pom_remove_plugin :maven-source-plugin

# The byte array allocation should have triggered a OutOfMemoryError
find src/test/java -name "ValidationTest.java" -print -delete

%mvn_file : %{oldname}
%mvn_compat_version : 1 %{version} %{version}.Final

%build

%mvn_build

%install
%mvn_install

%files -f .mfiles
%doc license.txt

%files javadoc -f .mfiles-javadoc
%doc license.txt

%changelog
