%define oldname beust-jcommander
Group: Development/Java
# BEGIN SourceDeps(oneline):
BuildRequires: rpm-build-java
# END SourceDeps(oneline)
BuildRequires: /proc
BuildRequires: jpackage-generic-compat
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           beust-jcommander1.71
Version:        1.71
Release:        alt2_6jpp8
Summary:        Java framework for parsing command line parameters
License:        ASL 2.0
URL:            http://jcommander.org/
BuildArch:      noarch

# ./generate-tarball.sh
Source0:        %{oldname}-%{version}.tar.gz
# Adapted from earlier version that still shipped poms. It uses kobalt for building now
Source1:        %{oldname}.pom
# Cleaned up bundled jars hose licensing cannot be easily verified
Source2:        generate-tarball.sh

Patch0: 0001-ParseValues-NullPointerException-patch.patch 

BuildRequires:  maven-local
BuildRequires:  mvn(org.apache.felix:maven-bundle-plugin)
BuildRequires:  mvn(org.sonatype.oss:oss-parent:pom:)
BuildRequires:  mvn(org.testng:testng)
Source44: import.info

%description
JCommander is a very small Java framework that makes it trivial to
parse command line parameters (with annotations).

%package javadoc
Group: Development/Java
Summary:        API documentation for %{oldname}
BuildArch: noarch

%description javadoc
This package contains the %{summary}.

%prep
%setup -q -n jcommander-%{version}
%patch0 -p1

chmod -x license.txt
cp -p %SOURCE1 pom.xml
sed -i 's/@VERSION@/%{version}/g' pom.xml

%mvn_compat_version : 1 1.48 %{version}

%build
%mvn_file : %{oldname}
%mvn_build

%install
%mvn_install

%files -f .mfiles
%doc license.txt notice.md README.markdown

%files javadoc -f .mfiles-javadoc
%doc license.txt notice.md

%changelog
