Name: blackbox
Version: 0.76
Release: alt2

Summary: A Window Manager for the X Window System
License: BSD-style
Group:   Graphical desktop/Other
URL:     https://github.com/bbidulock/blackboxwm
Source0: https://github.com/bbidulock/blackboxwm/releases/download/%version/%name-%version.tar
Source1: %name.menu-method
Source2: %name.menu
Source3: %name-16.png
Source4: %name-32.png
Source5: %name-48.png
Source6: %name-64.png
Source8: %name.alternatives
Source9: %name-gencat-wrapper
Source10: blackbox.desktop
Source11: ru.po.fixed

Patch0: blackbox-0.74-alt-link.patch
Patch10: blackbox-0.70.1-alt-style.patch

%define iconname blackbox-session
%if "%iconname" == "%name"
# due to apps/blackbox.png in tatham-puzzles
Conflicts: tatham-puzzles
%endif

# Automatically added by buildreq on Tue Mar 12 2013
# optimized out: alternatives fontconfig fontconfig-devel gnu-config libX11-devel libXrender-devel libfreetype-devel libstdc++-devel pkg-config xorg-renderproto-devel xorg-xextproto-devel xorg-xproto-devel
BuildRequires: gcc-c++ imake libXext-devel libXft-devel xorg-cf-files

%description
This is a window manager for X.  It is similar in many respects to
such popular packages as Window Maker, Enlightenment, and FVWM2.  You
might be interested in this package if you are tired of window managers
that are a heavy drain on your system resources, but you still want
an attractive and modern-looking interface.

The best part of all is that this program is coded in C++, so it
is even more attractive "under the hood" than it is in service -- no
small feat.

If none of this sounds familiar to you, or you want your computer to
look like Windows 98, you probably don't want this package.

%package devel
Summary: Blackbox Toolbox library for writing small applications
Group: Development/C++
Requires: %name = %version-%release

%description devel
This package contains the Blackbox Toolbox files, headers and static library
of the utility class library for writing small applications.

%prep
%setup -q
%patch0 -p1
#patch10 -p0

# %%{__global_ldflags} wrongly passed to pkgconfig file
sed -i 's|@LDFLAGS@||g' lib/libbt.pc.in

#iconv -f utf-8 -t koi8-r ./po/ru.po | iconv -t iso-8859-5 -f koi8-r | iconv -f koi8-r -t utf-8 > ./po/ru.po.fixed && edit manually
install -p %SOURCE11 ./po/ru.po
rm -f ./po/ru.gmo

install -p %SOURCE9 ./gencat-wrapper

%build
export gencat_cmd="`pwd`/gencat-wrapper"
autoreconf -fisv
%configure \
    --enable-shared \
    --disable-static \
    --sysconfdir=%_sysconfdir/X11/%name \
    --enable-nls

%make_build DEFAULT_MENU=%_sysconfdir/X11/%name/%name-menu

%install
%make_install DESTDIR=%buildroot install

mv %buildroot%_bindir/bsetbg   %buildroot%_bindir/bsetbg-%name
mv %buildroot%_bindir/bsetroot %buildroot%_bindir/bsetroot-%name
mv %buildroot%_man1dir/bsetbg.1 %buildroot%_man1dir/bsetbg-%name.1
mv %buildroot%_man1dir/bsetroot.1 %buildroot%_man1dir/bsetroot-%name.1

install -pD -m755 %SOURCE1 %buildroot%_sysconfdir/menu-methods/%name
install -pD -m644 %SOURCE2 %buildroot%_menudir/%name
install -pD -m644 %SOURCE3 %buildroot%_miconsdir/%iconname.png
install -pD -m644 %SOURCE4 %buildroot%_niconsdir/%iconname.png
install -pD -m644 %SOURCE5 %buildroot%_liconsdir/%iconname.png
install -pD -m644 %SOURCE6 %buildroot%_iconsdir/hicolor/64x64/apps/%iconname.png
install -pD -m644 %SOURCE8 %buildroot%_altdir/%name

install -pD -m644 /dev/null %buildroot%_sysconfdir/X11/%name/%name-menu

# Install the desktop entry
install -pD -m644 %SOURCE10 %buildroot%_datadir/xsessions/blackbox.desktop
sed -i 's,^Icon=blackbox,%{iconname},' %buildroot%_datadir/xsessions/blackbox.desktop

mkdir -p %buildroot%_sysconfdir/X11/wmsession.d/
cat > %buildroot%_sysconfdir/X11/wmsession.d/17%name <<'EOF'
NAME=BlackBox
ICON=/usr/share/icons/hicolor/64x64/apps/%{iconname}.png
EXEC=/usr/bin/blackbox
DESC=A Light but nice looking window manager
SCRIPT:
exec /usr/bin/blackbox
EOF


%find_lang %{name}

%files -f %{name}.lang
%doc AUTHORS COMPLIANCE ChangeLog* COPYING README* TODO
%_bindir/blackbox
%_bindir/bsetbg*
%_bindir/bsetroot*
%_bindir/bstyleconvert
%_man1dir/*
%dir %_datadir/%name
%_datadir/%name/
%_libdir/libbt.so.*
%_datadir/xsessions/blackbox.desktop
%lang(fr) %_mandir/fr/man?/*
%lang(ja) %_mandir/ja/man?/*
%lang(nl) %_mandir/nl/man?/*
%lang(sl) %_mandir/sl/man?/*
# alt specific
%_menudir/*
%config(noreplace) %_sysconfdir/menu-methods/*
%config %_sysconfdir/X11/wmsession.d/*
%dir %_sysconfdir/X11/%name
%ghost %_sysconfdir/X11/%name/%name-menu
%_altdir/%name
%_iconsdir/hicolor/??x??/apps/*.png

%files devel
%_libdir/libbt.so
%dir %_includedir/bt
%_includedir/bt/*.hh
%_pkgconfigdir/libbt.pc

%changelog
