# SPDX-License-Identifier: GPL-2.0-only
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

Name: blktrace
Version: 1.3.0
Release: alt1
Summary: Block queue IO tracer
License: GPL-2.0-only
Group: Development/Debuggers
Url: https://git.kernel.dk/cgit/blktrace/
Vcs: git://git.kernel.dk/blktrace.git

Source: %name-%version.tar
BuildRequires: libaio-devel
%{?!_without_check:%{?!_disable_check:BuildRequires: rpm-build-vm fio}}

# Avoid: "forbidden requires: python-base
# sisyphus_check: check-deps ERROR: package dependencies violation"
AutoReqProv: nopython noshebang

%description
blktrace is a block layer IO tracing mechanism which provides detailed
information about request queue operations up to user space.

  blkiomon - Monitor block device I/O based o blktrace data
  blkparse - Produce formatted output of event streams of block devices
  blkrawverify - Verifies an output file produced by blkparse
  blktrace - Generate traces of the I/O traffic on block devices
  bno_plot.py - Generate interactive 3D plot of IO blocks and sizes
  btrace - Perform live tracing for block devices
  btrecord & btreplay - Recreate IO loads recorded by blktrace
  btt - Analyse block I/O traces produces by blktrace
  iowatcher - Create visualizations from blktrace results
  verify_blkparse - Verifies an output file produced by blkparse

%prep
%setup

%build
%make_build CFLAGS="%optflags"
# No building docs to avoid bringing texlive monster.

%install
%makeinstall_std \
	prefix=%prefix \
	mandir=%_mandir

%check
%buildroot%_bindir/blkparse -V
%buildroot%_bindir/btreplay -V
%buildroot%_bindir/btrecord -V
%buildroot%_bindir/btt -V
%buildroot%_bindir/blkiomon -V
# blktrace itself will just segfault, becasue no access to `/sys/devices/system/cpu/online`.
# Other proggies do not support `-V`.

truncate -s 11M disk.img
PATH=%buildroot%_bindir:$PATH
vm-run --kvm=cond --udevd --drive=disk.img,format=raw .gear/tests.sh

%files
%doc README doc/blktrace.tex
%_bindir/*
%_man1dir/*
%_man8dir/*

%changelog
