%define _unpackaged_files_terminate_build 1
%define oname canto_next

Name: canto-next
Version: 0.9.8
Release: alt1

Summary: The next generation Canto RSS daemon
License: GPLv2
Group: Networking/News
Url: https://pypi.org/project/Canto/
VCS: https://github.com/themoken/canto-next.git

Source: %name-%version.tar

BuildArch: noarch

BuildRequires(pre): rpm-build-python3

Requires: python3-module-%name

%description
This is the RSS backend for Canto clients.

Canto is an Atom/RSS feed reader for the console that is meant to be
quick, concise, and colorful. It's meant to allow you to crank through
feeds like you've never cranked before by providing a minimal, yet
information packed interface. No navigating menus. No dense blocks of
unreadable white text. An interface with almost infinite customization
and extensibility using the excellent Python programming language.

%package -n python3-module-%name
Summary: Python module for %name
Group: Development/Python3

%description -n python3-module-%name
This is the RSS backend for Canto clients.

Canto is an Atom/RSS feed reader for the console that is meant to be
quick, concise, and colorful. It's meant to allow you to crank through
feeds like you've never cranked before by providing a minimal, yet
information packed interface. No navigating menus. No dense blocks of
unreadable white text. An interface with almost infinite customization
and extensibility using the excellent Python programming language.

This package contains python3 module for %name.

%package -n python3-module-%name-tests
Summary: Tests for %name
Group: Development/Python3

%add_python3_self_prov_path %buildroot%python3_sitelibdir/%oname/tests/

%description -n python3-module-%name-tests
This is the RSS backend for Canto clients.

Canto is an Atom/RSS feed reader for the console that is meant to be
quick, concise, and colorful. It's meant to allow you to crank through
feeds like you've never cranked before by providing a minimal, yet
information packed interface. No navigating menus. No dense blocks of
unreadable white text. An interface with almost infinite customization
and extensibility using the excellent Python programming language.

This package contains tests for %name.

%package -n python3-module-%name-plugins
Summary: Python module for %name
Group: Development/Python3
Requires: %name

%description -n python3-module-%name-plugins
This is the RSS backend for Canto clients.

Canto is an Atom/RSS feed reader for the console that is meant to be
quick, concise, and colorful. It's meant to allow you to crank through
feeds like you've never cranked before by providing a minimal, yet
information packed interface. No navigating menus. No dense blocks of
unreadable white text. An interface with almost infinite customization
and extensibility using the excellent Python programming language.

This package contains plugins for %name.

%prep
%setup

for i in `ls plugins`; do
sed -i '1s|^|#!/usr/bin/python3|' plugins/$i
done

%build
%python3_build_debug

%install
%python3_install

mv tests/ %buildroot%python3_sitelibdir/%oname/

%files
%doc COPYING README.md
%_bindir/canto-daemon
%_bindir/canto-remote
%_man1dir/canto-*
%dir %_libexecdir/systemd
%dir %_libexecdir/systemd/user
%_libexecdir/systemd/user/canto-daemon.service

%files -n python3-module-%name
%dir %python3_sitelibdir/%oname
%python3_sitelibdir/%oname
%python3_sitelibdir/*.egg-info
%exclude %python3_sitelibdir/%oname/tests/

%files -n python3-module-%name-tests
%dir %python3_sitelibdir/%oname
%python3_sitelibdir/%oname/tests/

%files -n python3-module-%name-plugins
%dir %_libexecdir/canto
%_libexecdir/canto/plugins/


%changelog
