Group: Games/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
BuildRequires: /usr/bin/desktop-file-validate gcc-c++ libGLU-devel libSDL2-devel libglvnd-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
#global extra_version -2

Name:           cdogs-sdl
Version:        0.7.3
Release:        alt1_1
Summary:        C-Dogs is an arcade shoot-em-up
# The game-engine is GPLv2+
# The game art is CC
License:        GPLv2+ and CC-BY and CC-BY-SA and CC0
URL:            http://cxong.github.io/cdogs-sdl/
Source0:        https://github.com/cxong/cdogs-sdl/archive/%{version}%{?extra_version}.tar.gz#/%{name}-%{version}%{?extra_version}.tar.gz
Patch0:         cdogs-sdl-0.5.8-cmake.patch
Patch1:         cdogs-sdl-0.7.3-fcommon-fix.patch
BuildRequires:  gcc
BuildRequires:  ctest cmake libSDL2_mixer-devel libSDL2_image-devel libGL-devel
BuildRequires:  libncurses++-devel libncurses-devel libncursesw-devel libtic-devel libtinfo-devel libphysfs-devel libenet-devel
BuildRequires:  desktop-file-utils libappstream-glib
Requires:       icon-theme-hicolor
Obsoletes:      cdogs-data < 0.5
Provides:       cdogs-data = %EVR

# don't depend on blender just for helper scripts
%add_findreq_skiplist %_datadir/%{name}/graphics/chars/*/render.py*
%add_findreq_skiplist %_datadir/%{name}/graphics/chars/*/make_spritesheet.sh
%add_findprov_skiplist %_datadir/%{name}/graphics/chars/*/render.py*
%add_findprov_skiplist %_datadir/%{name}/graphics/chars/*/make_spritesheet.sh
Source44: import.info

%description
C-Dogs SDL is a port of the old DOS arcade game C-Dogs to modern operating
systems utilizing the SDL Media Libraries. C-Dogs is an arcade shoot-em-up
which lets players work alone and cooperatively during missions or fight
against each other in the a.'dogfighta.' death-match mode. The DOS version of
C-Dogs came with several built in missions and dogfight maps. This version
does too. The author of the DOS version of C-Dogs was Ronny Wester. We would
like to thank Ronny for releasing the C-Dogs sources to the public.


%prep
%setup -q -n %{name}-%{version}%{?extra_version}
%patch0 -p1
%patch1 -p1

# We use the system enet
rm -r src/cdogs/enet
# Misc. cleanups
sed -i 's/\r//' doc/original_readme.txt
find graphics sounds -name "*.sh" -delete


%build
%{fedora_cmake} -DCDOGS_DATA_DIR=/usr/share/cdogs-sdl/ -DUSE_SHARED_ENET=1
%make_build


%install
%makeinstall_std
desktop-file-validate \
  $RPM_BUILD_ROOT%{_datadir}/applications/io.github.cxong.%{name}.desktop
appstream-util validate-relax --nonet \
  $RPM_BUILD_ROOT%{_datadir}/appdata/io.github.cxong.%{name}.appdata.xml


%files
%doc doc/AUTHORS doc/CREDITS doc/original_readme.txt doc/README_DATA.md
%doc --no-dereference doc/COPYING.BSD doc/COPYING.GPL doc/COPYING.MJSON.txt doc/COPYING.xgetopt.txt doc/COPYING.yajl.txt doc/LICENSE.nanopb.txt doc/license.rlutil.txt
%{_bindir}/%{name}*
%{_datadir}/%{name}
%{_datadir}/appdata/io.github.cxong.%{name}.appdata.xml
%{_datadir}/applications/io.github.cxong.%{name}.desktop
%{_datadir}/icons/hicolor/*/apps/io.github.cxong.%{name}.png


%changelog
