%def_enable  ffmpeg
%def_enable  google_api_keys

%ifndef build_parallel_jobs
%global build_parallel_jobs %__nprocs
%endif

%global llvm_version 17.0
%global llvm_ver 17

%set_verify_elf_method rpath=relaxed textrel=relaxed lfs=relaxed lint=relaxed
%add_debuginfo_skiplist %_libdir/* %_bindir/*

%define _unpackaged_files_terminate_build 1

# Leave this alone, please.
%global target out/Release

# Set up Google API keys, see http://www.chromium.org/developers/how-tos/api-keys .
# Note: these are for ALT Linux use ONLY. For your own distribution,
# please get your own set of keys.
%define api_key               AIzaSyAIIWz7zaCwYcUSe3ZaRPviXjMjkBP4-xY
%define default_client_id     1018394967181.apps.googleusercontent.com
%define default_client_secret h_PrTP1ymJu83YTLyz-E25nP

Name:           chromium
Version:        126.0.6478.182
Release:        alt0.p10.1

Summary:        An open source web browser developed by Google
License:        BSD-3-Clause and LGPL-2.1+
Group:          Networking/WWW
Url:            https://www.chromium.org

# Get sources from https://chromium.woolyss.com/
Source0:        chromium.tar.zst

Source30:       master_preferences
Source31:       default_bookmarks.html
Source100:      chromium.sh
Source101:      chromium.desktop
Source102:      chromium.xml
Source200:      chromium.default

Provides:       chromium-browser = %version
Obsoletes:      chromium-browser < %version
Obsoletes:      chromium-stable <= %version

Provides:       webclient

Obsoletes:      chromium-password
Obsoletes:      chromium-kde
Obsoletes:      chromium-gnome
Obsoletes:      chromium-desktop-kde
Obsoletes:      chromium-desktop-gnome

ExclusiveArch: x86_64 aarch64

### Start Patches
Patch001: 0001-OPENSUSE-enables-reading-of-the-master-preference.patch
Patch002: 0002-ALT-Set-appropriate-desktop-file-name-for-default-br.patch
Patch003: 0003-DEBIAN-manpage-fixes.patch
Patch004: 0004-DEBIAN-add-ps-printing-capability-gtk2.patch
Patch005: 0005-ALT-Use-rpath-link-and-absolute-rpath.patch
Patch006: 0006-ALT-allow-to-override-clang-through-env-variables.patch
Patch007: 0007-ALT-Hack-to-avoid-build-error-with-clang7.patch
Patch008: 0008-FEDORA-bootstrap-with-python3.patch
Patch009: 0009-ALT-use-system-zlib.patch
Patch010: 0010-ALT-use-system-libdrm-library.patch
Patch011: 0011-DEBIAN-allow-building-against-system-libraries-even-.patch
Patch012: 0012-DEBIAN-use-system-zlib-library-instead-of-embedded-l.patch
Patch013: 0013-DEBIAN-use-system-opus-library-instead-of-embedded.patch
Patch014: 0014-DEBIAN-build-using-system-openjpeg.patch
Patch015: 0015-DEBIAN-use-system-jpeg-library.patch
Patch016: 0016-DEBIAN-use-system-libevent-library.patch
#Patch017: 0017-DEBIAN-work-around-a-clang-bug-with-libstdc.patch
Patch018: 0018-Use-yandex-search-as-default.patch
Patch019: 0019-DEBIAN-gpu-header.patch
Patch020: 0020-ALT-Do-not-hardcode-flatbuffer-version.patch
Patch021: 0021-FEDORA-System-brotli.patch
Patch022: 0022-Revert-Use-aggregate-init-designed-initializers-more.patch
Patch023: 0023-Add-missing-headers.patch
Patch024: 0024-Disable-unsupported-compiler-flags.patch
Patch025: 0025-Fix-rust-clang-path.patch
Patch026: 0026-DEBIAN-remove-dependencies-on-third_party-catapult.patch
Patch027: 0027-Use-system-sysroot-for-rust.patch
Patch028: 0028-DEBIAN-work-around-incorrect-template-selection.patch
Patch029: 0029-nullptr_t-without-namespace-std.patch
Patch030: 0030-Fix-undefined-symbol-partition_alloc-internal-Intern.patch
Patch031: 0031-FEDORA-disable-screen-ai-service.patch
Patch032: 0032-FEDORA-libavif-deps.patch
Patch033: 0033-ALT-rename-std::powf.patch
Patch034: 0034-DEBIAN-span-optional.patch
Patch035: 0035-DEBIAN-quiche-deque.patch
Patch040: 0040-DEBIAN-realtime-reporting.patch
Patch041: 0041-DEBIAN-blink-header.patch
Patch042: 0042-DEBIAN-urlvisit-header.patch
Patch043: 0043-DEBIAN-accessibility-format.patch
Patch044: 0044-DEBIAN-mojo.patch
Patch047: 0047-DEBIAN-ruy-include.patch
Patch048: 0048-DEBIAN-tabstrip-include.patch
Patch050: 0050-DEBIAN-bad-font-gc0000.patch
Patch051: 0051-DEBIAN-bad-font-gc000.patch
Patch052: 0052-DEBIAN-bad-font-gc00.patch
Patch053: 0053-DEBIAN-bad-font-gc0.patch
Patch054: 0054-DEBIAN-bad-font-gc1.patch
Patch055: 0055-DEBIAN-bad-font-gc11.patch
Patch056: 0056-DEBIAN-bad-font-gc2.patch
Patch057: 0057-DEBIAN-bad-font-gc3.patch
Patch058: 0058-SUSE-RenderFrameHostImpl-use-after-free.patch
Patch060: 0060-UPSTREAM-xcb:-workaround-stdc++-bug-with-clang.patch
Patch070: chromium-alt-Disable-customize-startup-page.patch
Patch071: chromium-alt-MemoryAllocInfoMapKey.patch
Patch072: chromium-alt-backport-p10.patch
### End Patches

BuildRequires: /proc
BuildRequires: /dev/shm

BuildRequires:  bison
BuildRequires:  brotli
BuildRequires:  bzlib-devel
BuildRequires:  chrpath
BuildRequires:  elfutils
BuildRequires:  flex
BuildRequires:  glibc-kernheaders
BuildRequires:  gperf
BuildRequires:  libcups-devel
BuildRequires:  libdouble-conversion-devel
BuildRequires:  custom-libstdc++13-devel
BuildRequires:  custom-libstdc++13-devel-static
BuildRequires:  ninja-build
BuildRequires:  node
BuildRequires:  nvidia-settings-devel
BuildRequires:  perl-Switch
BuildRequires:  pkg-config
BuildRequires:  usbids
BuildRequires:  xdg-utils
BuildRequires:  clang%{llvm_version}
BuildRequires:  clang%{llvm_version}-devel
BuildRequires:  llvm%{llvm_version}-devel
BuildRequires:  lld%{llvm_version}-devel
BuildRequires:  pkgconfig(absl_utility)
BuildRequires:  pkgconfig(alsa)
BuildRequires:  pkgconfig(atk)
BuildRequires:  pkgconfig(atk-bridge-2.0)
BuildRequires:  pkgconfig(atspi-2)
BuildRequires:  pkgconfig(cairo) >= 1.6
BuildRequires:  pkgconfig(dbus-1)
BuildRequires:  pkgconfig(dbus-glib-1)
BuildRequires:  pkgconfig(dri)
BuildRequires:  pkgconfig(epoxy)
BuildRequires:  pkgconfig(expat)
BuildRequires:  pkgconfig(flac)
BuildRequires:  pkgconfig(flatbuffers)
BuildRequires:  pkgconfig(fontconfig)
BuildRequires:  pkgconfig(freetype2)
BuildRequires:  pkgconfig(gbm)
BuildRequires:  pkgconfig(gconf-2.0)
BuildRequires:  pkgconfig(glib-2.0)
BuildRequires:  pkgconfig(gnome-keyring-1)
BuildRequires:  pkgconfig(gtk4)
BuildRequires:  pkgconfig(harfbuzz)
BuildRequires:  pkgconfig(jsoncpp)
BuildRequires:  pkgconfig(krb5-gssapi)
BuildRequires:  pkgconfig(lcms2)
BuildRequires:  pkgconfig(libbrotlidec)
BuildRequires:  pkgconfig(libcurl)
BuildRequires:  pkgconfig(libdrm)
BuildRequires:  pkgconfig(libevdev)
BuildRequires:  pkgconfig(libevent)
BuildRequires:  pkgconfig(libffi)
BuildRequires:  pkgconfig(libhwy)
BuildRequires:  pkgconfig(libjpeg)
BuildRequires:  pkgconfig(libopenjp2)
BuildRequires:  pkgconfig(libpci)
BuildRequires:  pkgconfig(libpipewire-0.3)
BuildRequires:  pkgconfig(libpng)
BuildRequires:  pkgconfig(libpulse)
BuildRequires:  pkgconfig(libsecret-1)
BuildRequires:  pkgconfig(libusb-1.0)
BuildRequires:  pkgconfig(libva)
BuildRequires:  pkgconfig(libwebp)
BuildRequires:  pkgconfig(libwoff2dec)
BuildRequires:  pkgconfig(libxslt)
BuildRequires:  pkgconfig(minizip)
BuildRequires:  pkgconfig(nspr)
BuildRequires:  pkgconfig(nss)
BuildRequires:  pkgconfig(openh264)
BuildRequires:  pkgconfig(re2)
BuildRequires:  pkgconfig(snappy)
BuildRequires:  pkgconfig(uuid)
BuildRequires:  pkgconfig(x11)
BuildRequires:  pkgconfig(xcb-proto)
BuildRequires:  pkgconfig(xcomposite)
BuildRequires:  pkgconfig(xcursor)
BuildRequires:  pkgconfig(xdamage)
BuildRequires:  pkgconfig(xext)
BuildRequires:  pkgconfig(xfixes)
BuildRequires:  pkgconfig(xi)
BuildRequires:  pkgconfig(xkbcommon)
BuildRequires:  pkgconfig(xrandr)
BuildRequires:  pkgconfig(xrender)
BuildRequires:  pkgconfig(xscrnsaver)
BuildRequires:  pkgconfig(xshmfence)
BuildRequires:  pkgconfig(xt)
BuildRequires:  pkgconfig(xtst)
BuildRequires:  pkgconfig(zlib)
%if_enabled ffmpeg
BuildRequires:  pkgconfig(libavcodec)
BuildRequires:  pkgconfig(libavfilter)
BuildRequires:  pkgconfig(libavformat)
BuildRequires:  pkgconfig(libavutil)
BuildRequires:  pkgconfig(opus)
%endif

BuildRequires:  python3
BuildRequires:  python3(bs4)
BuildRequires:  python3(html5lib)
BuildRequires:  python3(markupsafe)
BuildRequires:  python3(ply)
BuildRequires:  python3(simplejson)

BuildRequires:  rust       >= 1.75.0-alt1
BuildRequires:  rust-cargo >= 1.75.0-alt1

# We do not build an internal version of libvulkan but we want to have it on the
# system.
#Requires: libvulkan1

Requires: libva
Requires: xdg-utils

%description
Chromium is an open-source browser project that aims to build a safer,
faster, and more stable way for all Internet users to experience the web.

%prep
%setup -q -n chromium
%autopatch -p1

# 126.0
subst 's/static const alignas(16)/alignas(16) static const/' \
  third_party/boringssl/src/crypto/poly1305/poly1305_vec.c
#subst 's/document_associated_data_;/document_associated_data_={};/' \
#   content/browser/renderer_host/render_frame_host_impl.h

sed -i \
        -e 's/"-ffile-compilation-dir=."//g' \
        -e 's/"-no-canonical-prefixes"//g' \
        -e 's/"-no-opaque-pointers",//g' \
        -e 's/"-Wno-thread-safety-reference-return",//g' \
        build/config/compiler/BUILD.gn

mkdir -p third_party/node/linux/node-linux-x64/bin
ln -s %_bindir/node third_party/node/linux/node-linux-x64/bin/node

mkdir -p buildtools/third_party/eu-strip/bin
ln -sf %_bindir/eu-strip buildtools/third_party/eu-strip/bin/eu-strip

rm -f -- third_party/depot_tools/ninja
ln -s %_bindir/ninja third_party/depot_tools/ninja
ln -s %_bindir/python3 third_party/depot_tools/python

subst 's|-Wno-c++11-narrowing-const-reference|-I%_includedir/c++/13","-I%_includedir/c++/13/%_arch-alt-linux|' build/config/compiler/BUILD.gn

%build
export ALTWRAP_LLVM_VERSION="%llvm_version"
export CC="clang-%llvm_ver"
export CXX="clang++-%llvm_ver"
export AR="llvm-ar-%llvm_ver"
export NM="llvm-nm-%llvm_ver"
export READELF="llvm-readelf-%llvm_ver"
export RANLIB="llvm-ranlib-%llvm_ver"
export LLVM_PREFIX=`llvm-config-%llvm_ver --prefix`
export LLVM_LIBDIR=`llvm-config-%llvm_ver --libdir`
export CLANG_MAJVER=`echo %llvm_version | cut -d. -f1`
export CLANG_LIBDIR="$LLVM_LIBDIR/clang/$CLANG_MAJVER/lib"

# Include flags for custom-gcc13
export CFLAGS="$CFLAGS -I%_includedir/c++/13 -I%_includedir/c++/13/%_arch-alt-linux -D__STDCPP_WANT_MATH_SPEC_FUNCS__"
export LDFLAGS="$LDFLAGS -L%_libdir/gcc/%_arch-alt-linux/13 -Wl,-rpath,%_libdir/custom-gcc"

bits=$(getconf LONG_BIT)

export PATH="$PWD/third_party/depot_tools:$PATH"
export CHROMIUM_RPATH="%_libdir/%name"
export LIBSTDCPP_RPATH="%_libdir/custom-gcc"

FLAGS=
FLAGS+=' -Wno-unknown-warning-option -Wno-deprecated-declarations'
FLAGS+=' -Wno-unused-command-line-argument -Wno-unused-but-set-variable'
FLAGS+=' -Wno-unused-result -Wno-unused-function -Wno-unused-variable'
FLAGS+=' -Wno-unused-const-variable -Wno-unneeded-internal-declaration'
FLAGS+=' -Wno-unknown-attributes'
FLAGS+=' -DUSE_SYSTEM_MINIZIP'
FLAGS+=' -DHAVE_STDBOOL_H'

gn_arg=()
gn_arg+=( custom_toolchain=\"//build/toolchain/linux/unbundle:default\" )
gn_arg+=( host_toolchain=\"//build/toolchain/linux/unbundle:default\" )
gn_arg+=( is_official_build=true )
gn_arg+=( use_custom_libcxx=false )
gn_arg+=( use_sysroot=false )
gn_arg+=( use_gio=true )
gn_arg+=( use_glib=true )
gn_arg+=( use_libpci=true )
gn_arg+=( use_pulseaudio=true )
gn_arg+=( use_cups=true )
gn_arg+=( use_kerberos=true )
gn_arg+=( use_gold=false )
gn_arg+=( use_vaapi=true )
gn_arg+=( use_system_freetype=true )
gn_arg+=( use_system_harfbuzz=true )
gn_arg+=( use_system_lcms2=true )
gn_arg+=( use_system_libffi=true )
gn_arg+=( use_system_libdrm=true )
gn_arg+=( use_system_libjpeg=true )
gn_arg+=( use_system_libopenjpeg2=true )
gn_arg+=( use_system_libpng=true )
gn_arg+=( use_system_minigbm=true )
gn_arg+=( use_system_zlib=true )
gn_arg+=( use_bundled_weston=false )
gn_arg+=( use_xkbcommon=true )
gn_arg+=( use_icf=false )
gn_arg+=( enable_linux_installer=false )
gn_arg+=( optimize_webui=false )
gn_arg+=( link_pulseaudio=true )
gn_arg+=( enable_hangout_services_extension=true )
gn_arg+=( treat_warnings_as_errors=false )
gn_arg+=( fatal_linker_warnings=false )
gn_arg+=( system_libdir=\"%_lib\" )
gn_arg+=( enable_nocompile_tests=false )

# toolkit
gn_arg+=( use_qt=false )
gn_arg+=( use_gtk=true )
gn_arg+=( gtk_version=4 )

# ozone
gn_arg+=( use_ozone=true )
gn_arg+=( ozone_platform=\"x11\" )
gn_arg+=( ozone_platform_x11=true )
gn_arg+=( ozone_platform_wayland=true )
#gn_arg+=( angle_enable_gl=true )
#gn_arg+=( angle_enable_vulkan=true )

# ffmpeg
gn_arg+=( ffmpeg_branding=\"Chrome\" )
gn_arg+=( proprietary_codecs=true )

# Remove debug
gn_arg+=( is_debug=false )
gn_arg+=( dcheck_always_on=false )
gn_arg+=( dcheck_is_configurable=false )
gn_arg+=( symbol_level=0 )
gn_arg+=( blink_symbol_level=0 )
gn_arg+=( v8_symbol_level=0 )

gn_arg+=( enable_nacl=false )
gn_arg+=( is_component_ffmpeg=false )
gn_arg+=( is_component_build=false )
gn_arg+=( enable_widevine=true )

gn_arg+=( rtc_use_pipewire=true )
gn_arg+=( rtc_link_pipewire=true )

gn_arg+=( clang_base_path=\"$LLVM_PREFIX\" )
gn_arg+=( is_clang=true )
gn_arg+=( clang_use_chrome_plugins=false )
gn_arg+=( use_lld=true )
if [ "$bits" = 64 ]; then
    gn_arg+=( use_thin_lto=true )
    gn_arg+=( thin_lto_enable_optimizations=true )
else
    gn_arg+=( use_thin_lto=false )
    gn_arg+=( thin_lto_enable_optimizations=false )
fi
gn_arg+=( is_cfi=false )
gn_arg+=( use_cfi_icall=false )
gn_arg+=( chrome_pgo_phase=0 )

# use system rust
export RUSTC_BOOTSTRAP=1
gn_arg+=( rust_sysroot_absolute=\"$(rustc --print sysroot)\" )
gn_arg+=( rustc_version=\"$(rustc --version)\" )

%ifnarch x86_64
gn_arg+=( icu_use_data_file=false )
%endif

%ifnarch x86_64 aarch64
gn_arg+=( enable_vulkan=false )
%else
gn_arg+=( enable_vulkan=true )
%endif

%if_enabled google_api_keys
### From 2013 until early 2021, Google permitted distribution builds of
### Chromium to access Google APIs that added significant features to
### Chromium including, but not limited to, Sync and geolocation.
### As of March 15, 2021, any Chromium builds which pass client_id and/or
### client_secret during build will prevent end-users from signing into their
### Google account.
###
### I have removed the calls to "google_default_client_id"
### and "google_default_client_secret" to comply with their changes.
###
### We can still use the api key though. For now.
gn_arg+=( google_api_key=\"%api_key\" )

#gn_arg+=( google_default_client_id=\"%default_client_id\" )
#gn_arg+=( google_default_client_secret=\"%default_client_secret\" )
%endif

# Remove bundled libraries for which we will use the system copies.
.rpm/scripts/unbundle

tools/gn/bootstrap/bootstrap.py --gn-gen-args="${gn_arg[*]}" --build-path=%target
%target/gn --script-executable=%__python3 gen --args="${gn_arg[*]}" %target

n=%build_parallel_jobs
[ "$n" -lt 20 ] || n=20

# Fix LLVM 15.x path
#subst 's|lib/llvm-15.0/lib64/clang/15/lib/|lib/llvm-17.0/lib64/clang/17/lib/|' `grep -Rl lib/llvm-15.0/lib64/clang/15/lib/ out/Release/*`

for name in chrome chrome_sandbox chromedriver policy_templates; do
	export NINJA_STATUS="[$name %%f/%%t] "
	ninja -j "$n" -C %target $name
done


%install
mkdir -p -- \
	%buildroot/%_bindir \
	%buildroot/%_man1dir \
	%buildroot/%_libdir/%name \
	%buildroot/%_sysconfdir/%name \
#
install -m 755 %SOURCE100 %buildroot%_bindir/%name
install -m 644 %SOURCE200 %buildroot%_sysconfdir/%name/default

# add directories for policy management
mkdir -p %buildroot%_sysconfdir/%name/policies/managed
mkdir -p %buildroot%_sysconfdir/%name/policies/recommended

# compatibility symlink
ln -s %name %buildroot/%_bindir/chromium-browser

# manpage
.rpm/scripts/make-manpage.sh > %buildroot/%_man1dir/%name.1
ln -s %name.1  %buildroot/%_man1dir/chrome.1

pushd %target
cp -a chrome           %buildroot%_libdir/%name/%name
cp -a chrome_sandbox   %buildroot%_libdir/%name/chrome-sandbox
cp -a chrome_crashpad_handler %buildroot%_libdir/%name/chrome_crashpad_handler

for chromedriver in chromedriver chromedriver.unstripped; do
	[ ! -x $chromedriver ] || break
done

cp -a $chromedriver %buildroot%_libdir/%name/chromedriver
strip %buildroot%_libdir/%name/chromedriver

ln -s -- %_libdir/%name/chromedriver %buildroot/%_bindir/chromedriver

for f in *.bin *.so* *.pak swiftshader locales icudtl.dat MEIPreload vk_swiftshader_icd.json; do
	[ ! -e "$f" ] ||
		cp -at %buildroot%_libdir/%name -- "$f"
done
popd

# Remove garbage
find %buildroot%_libdir/%name -name '*.TOC' -delete
find %buildroot%_libdir/%name/locales -name '*.pak.info' -delete

# Icons
for size in 24 48 64 128 256; do
	install -Dm644 "chrome/app/theme/chromium/product_logo_$size.png" \
		"%buildroot/%_iconsdir/hicolor/${size}x${size}/apps/%name.png"
done
for size in 16 32; do
	install -Dm644 "chrome/app/theme/default_100_percent/chromium/product_logo_$size.png" \
		"%buildroot/%_iconsdir/hicolor/${size}x${size}/apps/%name.png"
done

# Desktop file
install -Dm0644 %SOURCE101 %buildroot/%_desktopdir/%name.desktop

mkdir -p -- %buildroot%_datadir/gnome-control-center/default-apps/
cp -a %SOURCE102 %buildroot%_datadir/gnome-control-center/default-apps/%name.xml

# link to browser plugin path.  Plugin patch doesn't work. Why?
mkdir -p -- %buildroot%_libdir/browser-plugins
ln -s -- %_libdir/browser-plugins %buildroot%_libdir/%name/plugins

# Install the master_preferences file
mkdir -p -- %buildroot%_sysconfdir/%name
install -m 0644 %SOURCE30 %buildroot%_sysconfdir/%name
install -m 0644 %SOURCE31 %buildroot%_sysconfdir/%name

# Set alternative to xbrowser
mkdir -p -- %buildroot%_altdir
cat >%buildroot%_altdir/%name <<EOF
%_bindir/xbrowser	%_bindir/%name	50
%_bindir/x-www-browser	%_bindir/%name	50
EOF

(set +x;
	find %buildroot/%_libdir/%name -type f |
	while read f; do
		t="$(readlink -ev "$f")"

		file "$t" | grep -Fqs ELF || continue

		# Strip Chromium executables to disable debuginfo generation (became too huge)
		#strip -d "$t" ||:

		# Add real RPATH
		chrpath -r '%_libdir/custom-gcc' "$t" ||:
	done
)


%files
%doc AUTHORS LICENSE
%dir %_datadir/gnome-control-center/default-apps
%dir %_sysconfdir/%name
%dir %_sysconfdir/%name/policies
%dir %_sysconfdir/%name/policies/managed
%dir %_sysconfdir/%name/policies/recommended
%config %_sysconfdir/%name/*
%attr(4711,root,root) %_libdir/%name/chrome-sandbox
%_libdir/%name
%_bindir/*
%_man1dir/*
%_desktopdir/%name.desktop
%_datadir/gnome-control-center/default-apps/*.xml
%_iconsdir/hicolor/*/apps/*.png
%_altdir/%name

%changelog
