Name: chrooted
Version: 0.3.12
Release: alt1

Summary: The chrooted environment helper
License: GPLv2+
Group: File tools
BuildArch: noarch

%define _chrootdir %_sysconfdir/chroot.d

Source: %name-%version.tar

Provides: %_chrootdir
Requires: coreutils, getopt, glibc-utils, grep, sed

BuildPreReq: help2man

%description
This package is required for chroot-aware packages.

%prep
%setup

%build
sed -i 's/@VERSION@/%version/g' -- update_chrooted
help2man -N -s8 -i update_chrooted.8.inc ./update_chrooted >update_chrooted.8

%install
mkdir -p %buildroot{/sbin,%_sbindir,%_man8dir,%_chrootdir}
install -pm755 update_chrooted %buildroot/sbin/
ln -s ../../sbin/update_chrooted %buildroot%_sbindir/
install -pm755 functions %buildroot%_chrootdir/
install -pm644 update_chrooted.8 %buildroot%_man8dir/

install -Dpm755 resolvconf %buildroot%_sysconfdir/hooks/resolv.conf.d/update_chrooted

# install config file
mkdir -p %buildroot%_sysconfdir/sysconfig/
cat <<EOF >%buildroot%_sysconfdir/sysconfig/chrooted
#DISABLE_HARDLINKS=no
EOF

# Generate shell functions provides list.
(
	echo '# shell functions provides list'
	for f in %buildroot%_chrootdir/*; do
		[ -x "$f" ] || continue
		sed -ne 's/^\([A-Za-z][A-Za-z_0-9]*[[:space:]]*\)()$/\1/pg' "$f"
	done |LC_COLLATE=C sort -u
) >%buildroot%_chrootdir/.provides.sh

%post
/sbin/update_chrooted -f all

%files
%config(noreplace) %_sysconfdir/sysconfig/chrooted
%_sysconfdir/hooks/resolv.conf.d/*
/sbin/*
%_sbindir/*
%_man8dir/*
%config %_chrootdir

%changelog
