%global __find_debuginfo_files %nil
%define _unpackaged_files_terminate_build 1
%global llvm_version 17.0
%global clang_version 17
%global __nprocs 8

%def_with clang

%ifnarch x86_64
%define relax ||:
%else
%define relax %nil
%endif

%ifnarch ppc64le
%def_with jemalloc
%else
%def_without jemalloc
%endif

# LTO causes random crashes, disable it
%global optflags_lto %nil

%if_with clang
ExclusiveArch: aarch64 x86_64
%else
ExclusiveArch: aarch64 x86_64 ppc64le
%endif

Name: clickhouse
Version: 24.8.5.115
Release: alt1
Summary: Open-source distributed column-oriented DBMS
License: Apache-2.0
Group: Databases
Url: https://clickhouse.com
VCS: https://github.com/ClickHouse/ClickHouse.git
Source: %name-%version.tar.xz

Source100: %name-contrib-%version-%release.tar

Source1000: clickhouse.watch

Patch0: %name-%version-%release.patch
Patch2: clickhouse-avro-gcc10-compat.patch
Patch3: clickhouse-fastops-gcc-compat.patch
Patch5: clickhouse-24.3-use-system-toolchain.patch

BuildRequires(pre): rpm-build-python3
%if_with clang
BuildRequires: clang%llvm_version llvm%llvm_version lld%llvm_version
%else
BuildRequires: gcc-c++
%endif
BuildRequires: cmake libreadline-devel python3 gperf tzdata
BuildRequires: rpm-macros-cmake rpm-macros-ninja-build ninja-build /proc
BuildRequires: perl-JSON-XS libasan-devel-static
BuildRequires: libstdc++-devel-static
BuildRequires: yasm nasm

%add_python3_path %_datadir/clickhouse-test

Conflicts: clickhouse-lts

%filter_from_requires /^python3(queries) = .*/d
%filter_from_requires /^python3(queries\.conftest) = .*/d
%filter_from_requires /^python3(queries\.query_test) = .*/d
%filter_from_requires /^python3(queries\.server) = .*/d

%filter_from_provides /^python3(queries) = .*/d
%filter_from_provides /^python3(queries\.conftest) = .*/d
%filter_from_provides /^python3(queries\.query_test) = .*/d
%filter_from_provides /^python3(queries\.server) = .*/d

%description
ClickHouse is an open-source column-oriented database management system that
allows generating analytical data reports in real time.

%package common-static
Group: Databases
Summary: Common files for %name
Provides: libclickhouse = %EVR
Conflicts: libclickhouse < %EVR
Obsoletes: libclickhouse < %EVR
Conflicts: clickhouse-lts-common-static

%description common-static
This package provides common files for both clickhouse server and client.

%package server
Summary: Server binary for ClickHouse
Group: Databases
Requires: %name-common-static = %EVR
Conflicts: clickhouse-lts-server

%description server
This package contains server binaries for ClickHouse DBMS.

%package client
Summary: Client binary for ClickHouse
Group: Databases
Requires: %name-common-static = %EVR
Conflicts: clickhouse-lts-client

%description client
This package contains clickhouse-client, clickhouse-local and clickhouse-benchmark

%prep
%setup

rm -rf contrib/*
tar --strip-components=1 -xf %SOURCE100 -C contrib/

%patch0 -p1

pushd contrib/avro
%patch2 -p1
popd

pushd contrib/fastops
%patch3 -p1
popd

%patch5 -p1

%build
if [ %__nprocs -gt 6 ] ; then
	export NPROCS=6
else
	export NPROCS=%__nprocs
fi

# remove binary toolchain from clickhouse contrib
rm -rf contrib/sysroot/linux*

# strip debuginfo: with bundled llvm debuginfo takes too much space
%define optflags_debug -g0

# -DENABLE_HIVE:BOOL=OFF is needed to circumvent build failure due to not finding orc headers
export ALTWRAP_LLVM_VERSION="%llvm_version"
%cmake \
%if_with clang
	-DCMAKE_C_COMPILER=clang-%clang_version \
	-DENABLE_CCACHE=0 \
	-DCMAKE_CXX_COMPILER=clang++-%clang_version \
	-DCOMPILER_CACHE=disabled \
	-DUSE_LIBCXX:BOOL=ON \
	-DPARALLEL_COMPILE_JOBS=$NPROCS \
	-DPARALLEL_LINK_JOBS=1 \
%else
	-DUSE_LIBCXX:BOOL=OFF \
	-DPARALLEL_COMPILE_JOBS=$NPROCS \
	-DPARALLEL_LINK_JOBS=$NPROCS \
%endif
	-DOMIT_HEAVY_DEBUG_SYMBOLS=ON \
	-DSPLIT_DEBUG_SYMBOLS=OFF \
	-DENABLE_RUST=OFF \
	-DBUILD_STANDALONE_KEEPER=1 \
	-DENABLE_CLICKHOUSE_KEEPER=1 \
	-DCMAKE_VERBOSE_MAKEFILE=1 \
	-DCLICKHOUSE_SPLIT_BINARY:BOOL=OFF \
	-DCMAKE_BUILD_TYPE:STRING=Release \
	-DCMAKE_VERBOSE_MAKEFILE:BOOL=OFF \
%ifarch x86_64
	-DENABLE_CPUID:BOOL=ON \
%else
	-DENABLE_CPUID:BOOL=OFF \
	-DENABLE_FASTOPS:BOOL=OFF \
	-DENABLE_HDFS:BOOL=OFF \
%endif
%ifarch aarch64
	-DNO_ARMV81_OR_HIGHER=1 \
%endif
%if_with jemalloc
	-DENABLE_JEMALLOC:BOOL=ON \
%else
	-DENABLE_JEMALLOC:BOOL=OFF \
%endif
	-DENABLE_PARQUET:BOOL=OFF \
	-DENABLE_CLICKHOUSE_TEST:BOOL=ON \
	-DENABLE_S3:BOOL=OFF \
	-DENABLE_UTILS:BOOL=OFF \
	-DENABLE_HIVE:BOOL=OFF \
	-DUSE_UNWIND:BOOL=ON \
	%nil

%ninja_build -C %_cmake__builddir clickhouse-bundle

%install
%ninja_install -C %_cmake__builddir
install -Dm0644 packages/clickhouse-server.service %buildroot%_unitdir/clickhouse-server.service
mkdir -p %buildroot%_localstatedir/clickhouse
mkdir -p %buildroot%_logdir/clickhouse-server

# remove unpackaged files
rm -rfv %buildroot%_prefix/cmake
rm -fv %buildroot%_prefix/lib/*.a

# remove empty debuginfo
rm -rf %buildroot%_libdir/debug


%check
./%_cmake__builddir/src/unit_tests_dbms --gtest_filter='-CoordinationTest.TestRotateIntervalChanges:ReadBufferAIOTest.TestReadAfterAIO:WeakHash32.*:Common.ReverseDNS:ParserPRQL/*' %relax

%pre server
%_sbindir/groupadd -r -f _clickhouse 2> /dev/null ||:
%_sbindir/useradd -r -g _clickhouse -d %_localstatedir/lib/clickhouse -s /dev/null -c "ClickHouse User" _clickhouse 2> /dev/null ||:

%post server
%post_service clickhouse-server

%preun server
%preun_service clickhouse-server

%post common-static
# CAP_IPC_LOCK capability is needed for binary mlock
# CAP_SYS_NICE capability is needef for os_thread_priority feature
setcap -q cap_ipc_lock,cap_sys_nice=+ep %_bindir/clickhouse 2>/dev/null ||:

if [ -f /proc/cpuinfo ] ; then
	grep -sq sse4_2 /proc/cpuinfo || echo "Warning: No SSE4.2 detected on this CPU, clickhouse may fail." >&2
fi

%files common-static
%_bindir/clickhouse
%_bindir/clickhouse-odbc-bridge
%_bindir/clickhouse-library-bridge
%_bindir/clickhouse-static-files-disk-uploader
%_datadir/clickhouse
%_datadir/bash-completion/completions/clickhouse
%_datadir/bash-completion/completions/clickhouse-bootstrap

%files server
%dir %_sysconfdir/clickhouse-server
%config(noreplace) %_sysconfdir/clickhouse-server/config.xml
%config(noreplace) %_sysconfdir/clickhouse-server/users.xml
%config(noreplace) %_sysconfdir/clickhouse-keeper/keeper_config.xml
%_bindir/ch*
%_bindir/clickhouse-server
%_bindir/clickhouse-keeper
%_bindir/clickhouse-keeper-client
%_bindir/clickhouse-keeper-converter
%_unitdir/clickhouse-server.service
%dir %attr(0750,_clickhouse,_clickhouse) %_logdir/clickhouse-server
%dir %attr(0750,_clickhouse,_clickhouse) %_localstatedir/clickhouse

%files client
%dir %_sysconfdir/clickhouse-client
%config(noreplace) %_sysconfdir/clickhouse-client/config.xml
%_bindir/clickhouse-client
%_bindir/clickhouse-local
%_bindir/clickhouse-compressor
%_bindir/clickhouse-disks
%_bindir/clickhouse-benchmark
%_bindir/clickhouse-obfuscator
%_bindir/clickhouse-format
%_bindir/clickhouse-extract-from-config
%_bindir/clickhouse-git-import
%_bindir/clickhouse-su
%_datadir/bash-completion/completions/clickhouse-benchmark
%_datadir/bash-completion/completions/clickhouse-client
%_datadir/bash-completion/completions/clickhouse-local

%changelog
