Name:    coin3d
Version: 4.0.0
Release: alt2.2
Summary: OpenGL-based, 3D graphics library
License: BSD-3-Clause
Group:   System/Libraries
Url:     https://github.com/coin3d/coin
Packager: Andrey Cherepanov <cas@altlinux.org>

Source: %name-%version.tar

Patch1: 0002-Added-c-suffix-to-SO_VERSION.patch
Patch2: 0003-Drop-use-of-cpack.patch
Patch3: 01_convert_old_patches.patch
Patch4: fix-cmake-3.19.patch

Requires: lib%name = %version-%release
Requires: %name-common = %version-%release

BuildRequires(pre): cmake
BuildRequires(pre): rpm-build-ninja
BuildRequires: gcc-c++
BuildRequires: doxygen
BuildRequires: boost-devel
BuildRequires: bzlib-devel
BuildRequires: fontconfig-devel
BuildRequires: libGL-devel
BuildRequires: libGLU-devel
BuildRequires: libX11-devel
BuildRequires: libXt-devel
BuildRequires: libexpat-devel
BuildRequires: libfreetype-devel
BuildRequires: zlib-devel

%description
Coin is an OpenGL-based, 3D graphics library that has its roots in the
Open Inventor 2.1 API, which Coin still is compatible with.

If you are not familiar with Open Inventor, it is a scene-graph based,
retain-mode, rendering and model manipulation, C++ class library,
originally designed by SGI.  It quickly became the de facto standard
graphics library for 3D visualization and visual simulation software
in the scientific and engineering community after its release.  It
also became the basis for the VRML1 file format standard.

%package -n lib%name
Summary: Shared libraries of Coin3D
Group: System/Libraries
Conflicts: %name < %version-%release

%description -n lib%name
Coin is an OpenGL-based, 3D graphics library that has its roots in the
Open Inventor 2.1 API, which Coin still is compatible with.

If you are not familiar with Open Inventor, it is a scene-graph based,
retain-mode, rendering and model manipulation, C++ class library,
originally designed by SGI.  It quickly became the de facto standard
graphics library for 3D visualization and visual simulation software
in the scientific and engineering community after its release.  It
also became the basis for the VRML1 file format standard.

This package contains shared libraries of Coin3D.

%package -n lib%name-devel
Summary: Development files for Coin3D
Group: Development/C++
Requires: lib%name = %version-%release
Requires: %name-common = %version-%release
Conflicts: %name < %version-%release
Conflicts: libInventor-devel

%description -n lib%name-devel
Coin is an OpenGL-based, 3D graphics library that has its roots in the
Open Inventor 2.1 API, which Coin still is compatible with.

If you are not familiar with Open Inventor, it is a scene-graph based,
retain-mode, rendering and model manipulation, C++ class library,
originally designed by SGI.  It quickly became the de facto standard
graphics library for 3D visualization and visual simulation software
in the scientific and engineering community after its release.  It
also became the basis for the VRML1 file format standard.

This package contains development files for Coin3D.

%package -n lib%name-devel-doc
Summary: Documentation for Coin3D
Group: Development/Documentation
BuildArch: noarch
Conflicts: lib%name-devel < %version-%release

%description -n lib%name-devel-doc
Coin is an OpenGL-based, 3D graphics library that has its roots in the
Open Inventor 2.1 API, which Coin still is compatible with.

If you are not familiar with Open Inventor, it is a scene-graph based,
retain-mode, rendering and model manipulation, C++ class library,
originally designed by SGI.  It quickly became the de facto standard
graphics library for 3D visualization and visual simulation software
in the scientific and engineering community after its release.  It
also became the basis for the VRML1 file format standard.

This package contains development documentation for Coin3D.

%package common
Summary: Architecture independent files of Coin3D
Group: Development/Documentation
BuildArch: noarch

%description common
Coin is an OpenGL-based, 3D graphics library that has its roots in the
Open Inventor 2.1 API, which Coin still is compatible with.

If you are not familiar with Open Inventor, it is a scene-graph based,
retain-mode, rendering and model manipulation, C++ class library,
originally designed by SGI.  It quickly became the de facto standard
graphics library for 3D visualization and visual simulation software
in the scientific and engineering community after its release.  It
also became the basis for the VRML1 file format standard.

This package contains architecture independent files of Coin3D.

%prep
%setup
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1

%build
%define _cmake__builddir BUILD
%cmake -GNinja \
       -DCOIN_BUILD_DOCUMENTATION=TRUE \
       -DCOIN_BUILD_DOCUMENTATION_MAN=TRUE \
       -DHAVE_MULTIPLE_VERSION=TRUE \
       -DUSE_EXTERNAL_EXPAT=TRUE
%ninja_build -C BUILD

%install
%ninja_install -C BUILD

%files -n lib%name
%doc AUTHORS ChangeLog README{,.UNIX} THANKS FAQ*
%_libdir/*.so.*

%files -n lib%name-devel
%_bindir/*
%_libdir/*.so
%_pkgconfigdir/*
%_libdir/cmake/*
%_includedir/*

%files -n lib%name-devel-doc
%doc docs/*
%doc %_defaultdocdir/Coin4
%_man3dir/*
%exclude %_man3dir/details.3*

%files common
%_datadir/Coin4

%changelog
