# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

Name: cppcheck
Version: 2.10.2
Release: alt1

Summary: A tool for static C/C++ code analysis
License: GPLv3
Group: Development/Tools

Url: https://github.com/danmar/cppcheck
# Source-url: https://github.com/danmar/cppcheck/archive/%version.tar.gz
Source: %name-%version.tar

Patch2: cppcheck-1.78-norebuild.patch
Patch4: cppcheck-1.72-test_32.patch
Patch8: cppcheck-2.2-translations.patch
Patch10: cppcheck-2.8-kate.patch

BuildRequires: gcc-c++
BuildRequires: qt5-base-devel qt5-tools-devel qt5-charts-devel
BuildRequires: cmake
BuildRequires: ctest
BuildRequires: docbook-style-xsl libpcre-devel xsltproc
BuildRequires: libtinyxml2-devel
BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-macros-cmake

%add_python3_req_skip cppcheckdata misra_9 cppcheck

%description
Static analysis of C/C++ code. Checks for: memory leaks, mismatching
allocation-deallocation, buffer overrun, and many more. The goal is
0%% false positives.

%package gui
Summary: Qt version of %name, %summary
Group: Development/Tools
Requires: %name = %EVR
Requires: icon-theme-hicolor

%description gui
%summary

%prep
%setup

%__subst 's|/usr/share/sgml/docbook/stylesheet/xsl/nwalsh/manpages/docbook.xsl|/usr/share/xml/docbook/xsl-stylesheets/manpages/docbook.xsl|' \
 Makefile man/cppcheck.1.xml tools/dmake.cpp

%patch2 -p1

%ifnarch x86_64
%patch4 -p1
%endif

%patch8 -p1
%patch10 -p1

%__subst 's|/usr/bin/env python.*$|%__python3|' htmlreport/{cppcheck-htmlreport,*.py} addons/*.py tools/*.py

%ifarch %e2k
# strip UTF-8 BOM for lcc < 1.24
find -type f -name '*.cpp' -o -name '*.hpp' -o -name '*.c' -o -name '*.h' |
	xargs -r sed -ri 's,^\xEF\xBB\xBF,,'
%endif

# Make sure bundled tinyxml2 is not used
#rm -r externals/tinyxml2



%build
%cmake \
	-G'Unix Makefiles' \
	-DCMAKE_BUILD_TYPE=Release \
	-DUSE_MATCHCOMPILER:BOOL=ON \
	-DHAVE_RULES:BOOL=ON \
	-DBUILD_GUI:BOOL=ON \
	-DBUILD_SHARED_LIBS:BOOL=OFF \
	-DBUILD_TESTS:BOOL=ON \
	-DFILESDIR=%{_datadir}/Cppcheck \
	-DPCRE_INCLUDE="%_includedir/pcre" \
	%nil

%cmake_build

%make man

# Generate html documentation
for N in man/*.docbook; do
  xsltproc -o ${N%%.docbook}.html \
	/usr/share/xml/docbook/xsl-stylesheets/xhtml/docbook.xsl $N
done

%install
%cmakeinstall_std

install -pD -m 644 %name.1 %buildroot%_man1dir/%name.1

# Install htmlreport
install -pD -m 755 htmlreport/cppcheck-htmlreport %buildroot%_bindir/cppcheck-htmlreport
# Restore execute permission of python files
grep -l "#\!%__python3" %buildroot%_datadir/Cppcheck/addons/*.py | xargs chmod +x

%check
#cmake_build --target check

%files
%doc readme.txt man/*.html
%_bindir/%name
%_bindir/%name-htmlreport
%_man1dir/%name.1*
%dir %_datadir/Cppcheck/
%_datadir/Cppcheck/addons/
%_datadir/Cppcheck/cfg/
%_datadir/Cppcheck/platforms/

%files gui
%doc gui/help/manual.html
%_bindir/%name-gui
%_datadir/Cppcheck/lang
%_desktopdir/*
%_iconsdir/hicolor/*/apps/*

%changelog
