Summary:  Creates a common metadata repository
Name:     createrepo_c
Version:  0.20.1
Release:  alt1
Group:    System/Configuration/Packaging
License:  GPL-2.0+
URL:      https://github.com/rpm-software-management/createrepo_c
Packager: Andrey Cherepanov <cas@altlinux.org>

Source0:  %name-%version.tar
Patch0:   %name-set-versions.patch

BuildRequires(pre): rpm-macros-cmake

BuildRequires: cmake
BuildRequires: gcc
BuildRequires: doxygen
BuildRequires: expat-devel
BuildRequires: libmagic-devel
BuildRequires: glib2-devel
BuildRequires: libcurl-devel
BuildRequires: libxml2-devel
BuildRequires: libssl-devel
BuildRequires: librpm-devel
BuildRequires: libsqlite3-devel
BuildRequires: bzip2-devel
BuildRequires: liblzma-devel
BuildRequires: zlib-devel
BuildRequires: libzstd-devel
BuildRequires: libmodulemd-devel

BuildRequires: python3-devel

Requires: lib%name = %version-%release

%description
C implementation of Createrepo.
A set of utilities (createrepo_c, mergerepo_c, modifyrepo_c)
for generating a common metadata repository from a directory of
rpm packages and maintaining it.

%package -n lib%name
Summary:  Library for repodata manipulation
Group:    System/Libraries
Provides: %name-libs

%description -n lib%name
Libraries for applications using the createrepo_c library
for easy manipulation with a repodata.

%package devel
Summary:  Library for repodata manipulation
Group:    Development/C
Requires: lib%name = %version-%release

%description devel
This package contains the createrepo_c C library and header files.
These development files are for easy manipulation with a repodata.

%package -n python3-module-%name
Summary:  Python 3 bindings for the createrepo_c library
Group:    Development/Python3

%description -n python3-module-%name
Python 3 bindings for the createrepo_c library.

%prep
%setup
%patch0 -p1

%build
export CMAKE_CXX_FLAGS="%optflags"
%cmake -DPYTHON_DESIRED=3 \
       -DWITH_ZCHUNK=OFF
%cmake_build

%install
%cmakeinstall_std
ln -s createrepo_c %buildroot%_bindir/createrepo
ln -s mergerepo_c %buildroot%_bindir/mergerepo
ln -s modifyrepo_c %buildroot%_bindir/modifyrepo

%files
%_bindir/*
%_man8dir/*

%files -n lib%name
%_libdir/lib%name.so.*

%files devel
%_libdir/*.so
%_libdir/pkgconfig/*.pc
%_includedir/%name

%files -n python3-module-%name
%python3_sitelibdir/*

%changelog
