Name: crtools
Version: 3.15
Release: alt2

Summary: Utility to checkpoint/restore tasks
License: GPL-2.0-only
Group: System/Configuration/Other
Url: http://criu.org

VCS: git://github.com/checkpoint-restore/criu.git
Source: criu-%version.tar
Source1: criu.watch
Patch1: 0001-FEDORA-aio-fix.patch
Patch2: 0002-ALT-build-against-python3.patch

Provides: criu = %EVR
ExclusiveArch: x86_64 aarch64 ppc64le

BuildRequires: libnet2-devel
BuildRequires: libprotobuf-c-devel %_bindir/protoc-c
BuildRequires: libprotobuf-devel protobuf-compiler
BuildRequires: asciidoc xmlto %_bindir/a2x
BuildRequires: libnftables-devel
BuildRequires: libgnutls-devel

%description
An utility to checkpoint/restore tasks.

%package -n libcriu2
Summary: Shared library of checkpoint/restore
Group: System/Libraries
License: LGPL-2.1-only
Provides: libcriu

%description -n libcriu2
Shared library of checkpoint/restore.

%package -n libcompel1
Summary: Compel library for CRIU
Group: System/Libraries
License: LGPL-2.1-only
Provides: libcompel

%description -n libcompel1
Compel library for CRIU.

%package -n libcriu-devel
Summary: Files for development with libcriu
Group: Development/C
Requires: libcriu
Requires: libcompel

%description -n libcriu-devel
Files for development with libcriu.

%package -n python3-module-criu
Summary: Python library of checkpoint/restore
Group: System/Libraries
BuildArch: noarch
BuildRequires: python3-devel
BuildRequires: glibc-devel
BuildRequires: libprotobuf-c-devel
BuildRequires: libnl-devel
BuildRequires: libcap-devel
BuildRequires: libselinux-devel
BuildRequires(pre): rpm-build-python3
Provides: crit = %EVR
Provides: python-module-criu
Obsoletes: crtools-pycriu
Obsoletes: python-module-criu

%description -n python3-module-criu
Python library library of checkpoint/restore.

%prep
%setup -n criu-%version
%autopatch -p1

%build
export CFLAGS="%optflags"
%make_build \
	%ifarch armh
		UNAME-M=armv7l \
	%endif
	PREFIX=%prefix V=1 all docs

%install
%makeinstall_std \
	%ifarch armh
		UNAME-M=armv7l \
	%endif
	PREFIX=%prefix LIBDIR=%_libdir LIBEXECDIR=%_libexecdir SYSTEMDUNITDIR=%_unitdir

ln -s criu %buildroot%_sbindir/crtools
ln -s criu.8 %buildroot%_man8dir/crtools.8

find %buildroot -name 'lib*.a' -delete

%files
%doc README.md COPYING CREDITS
%_sbindir/criu
%_sbindir/crtools
%_bindir/compel
%_libexecdir/criu
%_libexecdir/compel
%_man1dir/compel.1*
%_man8dir/criu.8*
%_man8dir/crtools.8*

%files -n python3-module-criu
%_bindir/crit
%python3_sitelibdir_noarch/pycriu
%python3_sitelibdir_noarch/crit-*.egg-info
%_man1dir/crit.1*

%files -n libcriu2
%_libdir/libcriu.so.2*

%files -n libcompel1
%_libdir/libcompel.so.1*

%files -n libcriu-devel
%_includedir/criu
%_includedir/compel
%_libdir/*.so
%_pkgconfigdir/criu.pc

%changelog
