%def_without check

Name: crtools-ovz
Version: 3.15.2.5
Release: alt1

Summary: Utility to checkpoint/restore tasks for OpenVZ containers
License: GPL-2.0-only
Group: System/Configuration/Other
Url: http://criu.org

Packager: Andrew A. Vasilyev <andy@altlinux.org>

# VCS: https://src.openvz.org/scm/ovz/criu.git
Source: criu-%version.tar

Provides: criu-ovz = %EVR
Conflicts: crtools
ExclusiveArch: x86_64

BuildRequires: libnet2-devel
BuildRequires: libprotobuf-c-devel %_bindir/protoc-c
BuildRequires: libprotobuf-devel protobuf-compiler
BuildRequires: asciidoc xmlto %_bindir/a2x
BuildRequires: libnftables-devel
BuildRequires: libgnutls-devel
BuildRequires: glibc-devel
BuildRequires: libnl-devel
BuildRequires: libcap-devel
BuildRequires: python3-base
# BuildRequires: libselinux-devel
BuildRequires(pre): rpm-build-python3

%if_with check
BuildRequires: rpm-build-vm-run
BuildRequires: vzkernel
BuildRequires: libaio-devel
BuildRequires: python-module-future python3-module-yaml python3-module-protobuf
BuildRequires: libbsd-devel
BuildRequires: iproute2 iptables iputils openvswitch
%endif

Requires: nftables util-linux ipset

%description
An utility to checkpoint/restore tasks for OpenVZ containers.

%prep
%setup -n criu-%version

%build
export CFLAGS="%optflags -fcommon"
export PYTHON=python3
%make_build \
	PREFIX=%prefix V=1 all docs

%install
export PYTHON=python3
%makeinstall_std \
	PREFIX=%prefix LIBDIR=%_libdir LIBEXECDIR=%_libexecdir SYSTEMDUNITDIR=%_unitdir

mv %buildroot%_sbindir/criu{,-ovz}
ln -s criu-ovz %buildroot%_sbindir/criu
ln -s criu-ovz %buildroot%_sbindir/crtools
ln -s criu.8 %buildroot%_man8dir/crtools.8

find %buildroot -name 'lib*.a' -delete

rm -f %buildroot%_bindir/crit
rm -rf %buildroot%python3_sitelibdir_noarch
rm -f %buildroot%_man1dir/crit.1*
rm -f %buildroot%_libdir/libcriu.so.2*
rm -f %buildroot%_libdir/libcompel.so.1*
rm -rf %buildroot%_includedir/criu
rm -rf %buildroot%_includedir/compel
rm -f %buildroot%_libdir/*.so
rm -f %buildroot%_pkgconfigdir/criu.pc

%check
vm-run --kvm=cond make test || :

%files
%doc README.md COPYING CREDITS
%_sbindir/criu
%_sbindir/criu-ovz
%_sbindir/crtools
%_bindir/compel
%_libexecdir/criu
%_libexecdir/compel
%_man1dir/compel.1*
%_man8dir/criu.8*
%_man8dir/crtools.8*

%changelog
