Name: cryptmount
Version: 5.3.1
Release: alt2
Group: File tools
Packager: Pavel Isopenko <pauli@altlinux.org>
License: GPL
Summary: Let ordinary users mount an encrypted file system
Summary(ru_RU.UTF-8): Монтирование зашифрованной файловой системы с правами обычного пользователя
Url: http://cryptmount.sourceforge.net
Source: %name-%version.tar

BuildRequires: libdevmapper-devel libgcrypt-devel libuuid-devel
BuildRequires: doxygen libudev-devel libcryptsetup-devel

Requires(post): %post_service
Requires(preun): %preun_service

%description
cryptmount is a utility for the GNU/Linux operating system which allows
an ordinary user to mount an encrypted filing system without requiring
superuser privileges. Filesystems can reside on raw disk partitions or
ordinary files, with cryptmount automatically configuring
device-mapper and loopback devices before mounting.

%description -l ru_RU.UTF-8
cryptmount - утилита для операционной системы GNU/Linux, позволяющая
обычному пользователю монтировать зашифрованные файловые системы без
требования привилегий суперпользователя. Файловые системы могут находиться
на дисковых разделах или в обычных файлах, cruptmount автоматически
настраивает device-mapper и loopback устройства перед монтированием.

%prep
%setup
perl -pi.orig -e 's|^(\s*)chown(\s*root)|\1#chown\2|g;
s|%_sysconfdir/init.d|%_initdir|g;
' Makefile.am Makefile.in

%build
%configure --enable-delegation --enable-fsck
%make_build

%install
mkdir -p %buildroot{%_initdir,%_unitdir,%_modulesloaddir}

%makeinstall_std
install -m0644 sysinit/cryptmount.service %buildroot%_unitdir/
mv %buildroot%_sysconfdir/modules-load.d/cryptmount.conf %buildroot%_modulesloaddir/

%find_lang --with-man %name
%find_lang --with-man --append --output=%name.lang cmtab

%files -f %name.lang
%doc AUTHORS ChangeLog COPYING NEWS README* RELNOTES ToDo
%_mandir/man5/cmtab.5*
%_mandir/man8/cryptmount*.8*

%config(noreplace) %_sysconfdir/cryptmount/
%_modulesloaddir/cryptmount.conf
%_initdir/cryptmount
%_unitdir/cryptmount.service
%_sbindir/cryptmount-setup

%attr(4711, root, root) %_bindir/cryptmount

%changelog
