Name: cvs
Version: 1.11.23
Release: alt7

Summary: A version control system
License: GPLv2+
Group: Development/Other
Url: http://www.nongnu.org/cvs/

# ftp://ftp.gnu.org/non-gnu/cvs/source/stable/%version/cvs-%version.tar.bz2
Source: cvs-%version.tar

Source1: cvsrc
Source2: cvs.sh
Source4: cvs.xinetd
Source5: cvs-pserver
Source6: cvs-pserver.conf
Source7: cvs-pserver.8
Source8: cvsinitroot
Source9: cvs-README.ALT

Patch1: cvs-1.11.23-up-CVE-2010-3846.patch
Patch11: cvs-1.11.23-alt-remove-unused.patch
Patch12: cvs-1.11.23-owl-fixes.patch
Patch13: cvs-1.11.23-alt-texinfo.patch
Patch14: cvs-1.11.23-alt-version.patch
Patch15: cvs-1.11.23-alt-errno.patch
Patch16: cvs-1.11.23-alt-vitmp.patch
Patch17: cvs-1.11.23-owl-no-world-writables.patch
Patch18: cvs-1.11.23-alt-mdk-owl-canonicalize.patch
Patch19: cvs-1.11.23-alt-cvsbug-ypcat.patch
Patch20: cvs-1.11.23-owl-alt-tmp.patch
Patch21: cvs-1.11.23-deb-alt-doc.patch
Patch22: cvs-1.11.23-bsd-deb-local_branch_num.patch
Patch23: cvs-1.11.23-deb-normalize_cvsroot.patch
Patch24: cvs-1.11.23-deb-expand_keywords-alphanumeric.patch
Patch25: cvs-1.11.23-deb-server-wrapper.patch
Patch26: cvs-1.11.23-deb-fast-edit.patch
Patch27: cvs-1.11.23-alt-password_entry_operation.patch
Patch28: cvs-1.11.23-deb-alt-homedir.patch
Patch29: cvs-1.11.23-deb-alt-newlines.patch
Patch30: cvs-1.11.23-alt-cvsrc.patch
Patch31: cvs-1.11.23-alt-tagloginfo.patch
Patch32: cvs-1.11.23-alt-xasprintf.patch
Patch33: cvs-1.11.23-alt-env.patch
Patch34: cvs-1.11.23-alt-server-log.patch
Patch35: cvs-1.11.23-deb-alt-LocalKeyword-KeywordExpand.patch
Patch36: cvs-1.11.23-alt-noreadlock.patch
Patch37: cvs-1.11.23-alt-ssh.patch
Patch38: cvs-1.11.23-alt-config.patch
Patch39: cvs-1.11.23-alt-format.patch
Patch40: cvs-1.11.23-alt-testsuite-fixes.patch
Patch41: cvs-1.11.23-alt-testsuite-sleep.patch
Patch42: cvs-1.11.23-up-texinfo-39166.patch

Requires: mktemp >= 1:1.3.1, vitmp
BuildRequires: makeinfo

# The cvsadmin group check must be disabled to run CVS test suit.
%{?!_without_check:%{?!_disable_check:BuildRequires: groupdel-cvsadmin}}
%{?!_without_check:%{?!_disable_check:BuildConflicts: cvs < 0:1.11.2-alt1}}

# Automatically added by buildreq on Thu Jan 16 2003
BuildRequires: zlib-devel

%description
CVS means Concurrent Version System; it is a version control
system which can record the history of your files (usually,
but not always, source code).  CVS only stores the differences
between versions, instead of every version of every file
you've ever created.  CVS also keeps a log of who, when and
why changes occurred, among other aspects.

CVS is very helpful for managing releases and controlling
the concurrent editing of source files among multiple
authors.  Instead of providing version control for a
collection of files in a single directory, CVS provides
version control for a hierarchical collection of
directories consisting of revision controlled files.

These directories and files can then be combined together
to form a software release.

%package pserver
Summary: CVS pserver script, documentation and default configuration
Group: System/Servers
Requires: %name = %version-%release
BuildArch: noarch

%description pserver
cvs-pserver is a wrapper around CVS which loads some default variables.
It is normally run by xinetd.

%package doc
Summary: Various documentation about the CVS
Group: Development/Other
Conflicts: %name < %version-%release, %name > %version-%release
BuildArch: noarch

%description doc
Various documentation about the Concurrent Version System.

%package contrib
Summary: Contributed soft for the CVS
Group: Development/Other
Requires: %name = %version-%release
BuildArch: noarch

%description contrib
Contributed soft for the Concurrent Version System.

%prep
%setup

# Remove useless/harmful stuff to ensure it will not be suddently used.
rm -rf emx os2 windows-NT vms zlib
find -type f \( -name getopt\* -o -name regex.\* -o -name getdate.c \) \
	-delete -print

# Fix dos-style lines.
r=$(printf '\r')
find contrib -type f -print0 |
	xargs -r0 grep -Zl "$r\$" -- |
	xargs -r0 sed -i "s/$r\$//g" --
unset r

%patch1
%patch11 -p1
%patch12 -p1
%patch13 -p1
%patch14 -p1
%patch15 -p1
%patch16 -p1
%patch17 -p1
%patch18 -p1
%patch19 -p1
%patch20 -p1
%patch21 -p1
%patch22 -p1
%patch23 -p1
%patch24 -p1
%patch25 -p1
%patch26 -p1
%patch27 -p1
%patch28 -p1
%patch29 -p1
%patch30 -p1
%patch31 -p1
%patch32 -p1
%patch33 -p1
%patch34 -p1
%patch35 -p1
%patch36 -p1
%patch37 -p1
%patch38 -p1
%patch39 -p1
%patch40 -p1
%patch41 -p1
%patch42 -p1

find -type f \( -size 0 -o -name \*~ -o -name \*.orig -o -name .cvsignore \) -delete
sed -i 's|${TMPDIR}/cvs-serv|${TMPDIR:-/tmp}/cvs-serv|g' src/sanity.sh

# Fix texinfo warnings.
sed -i 's/@strong{Note:/@strong{Please notice:/' doc/cvs.texinfo

%build
%add_optflags -D_GNU_SOURCE

export ac_cv_func_mkstemp=yes \
	ac_cv_lib_nsl_main=no \
	ac_cv_path_CSH=/bin/csh \
	ac_cv_path_PERL=%__perl \
	ac_cv_path_PS2PDF=/usr/bin/ps2pdf \
	ac_cv_path_ROFF=/usr/bin/groff \
	ac_cv_path_SENDMAIL=/usr/sbin/sendmail \
	ac_cv_path_TEXI2DVI=/usr/bin/texi2dvi \
	ac_cv_prog_with_default_rsh=ssh \
	ac_cv_prog_with_default_ssh=ssh \
	#

%autoreconf
%configure \
	--with-rsh=ssh \
	--with-ssh=ssh \
	--with-tmpdir=/tmp \
	--with-editor=/bin/vitmp \
	--without-gssapi \
	#
%make_build
bzip2 -9 ChangeLog FAQ NEWS TODO

%check
export TMPDIR=/tmp
# remove -O from MAKEFLAGS
export MAKEFLAGS=-w
%make_build check

%install
%makeinstall_std install-info

install -pD -m755 %_sourcedir/cvs-pserver %buildroot%_sbindir/cvs-pserver
install -pD -m600 %_sourcedir/cvs-pserver.conf %buildroot%_sysconfdir/cvs/pserver.conf
install -pD -m644 %_sourcedir/cvs-pserver.8 %buildroot%_man8dir/cvs-pserver.8

install -pD -m644 %_sourcedir/cvsrc %buildroot%_sysconfdir/cvs/cvsrc
install -pD -m755 %_sourcedir/cvs.sh %buildroot%_sysconfdir/profile.d/cvs.sh
install -pD -m640 %_sourcedir/cvs.xinetd %buildroot%_sysconfdir/xinetd.d/cvs
install -pD -m755 %_sourcedir/cvsinitroot %buildroot%_sbindir/cvsinitroot

install -dm3770 %buildroot/var/lock/cvs

%define docdir %_docdir/%name-%version
rm -rf %buildroot%docdir
install -pD -m644 %_sourcedir/cvs-README.ALT \
	%buildroot%docdir/README.ALT
install -pm644 \
	AUTHORS *BUGS DEVEL-CVS HACKING PROJECTS README *.bz2 doc/*.pdf \
	%buildroot%docdir/

%pre
/usr/sbin/groupadd -rf cvs
/usr/sbin/groupadd -rf cvsadmin

%files
%attr(3770,root,cvs) %dir /var/lock/cvs
%attr(755,root,root) %dir %_sysconfdir/cvs
%config(noreplace) %_sysconfdir/cvs/cvsrc
%config(noreplace) %_sysconfdir/profile.d/*sh
%_bindir/cvs*
%_sbindir/cvsinitroot
%_man1dir/*
%_man5dir/*
%_man8dir/cvsbug.*
%_infodir/*.info*
%dir %docdir
%docdir/[A-Z]*

%files pserver
%attr(755,root,root) %dir %_sysconfdir/cvs
%config(noreplace) %_sysconfdir/cvs/pserver.conf
%config(noreplace) %_sysconfdir/xinetd.d/*
%_sbindir/cvs-pserver
%_man8dir/cvs-pserver.*

%files doc
%dir %docdir
%docdir/*.pdf

%files contrib
%_bindir/rcs*
%_datadir/cvs

%changelog
