%define _cyrususer cyrus
%define _cyrusgroup cyrus
%define _vardata %_var/lib/imap
%define _spooldata %_var/spool/imap
%define _cyrexecdir %_libexecdir/cyrus
%define _contribdir %_datadir/%name/contrib

# http://bugzilla.altlinux.org/31381
%def_without unit_tests

# 3.0.8 with python-module-sphinx-1.4 (p8):
# File "./docsrc/exts/sphinxlocal/builders/manpage.py", line 78, in write
#     darkgreen, [docname])
# TypeError: inline_all_toctrees() takes exactly 5 arguments (6 given)
%def_without sphinx

%def_with srs2
%def_without snmp

Name: cyrus-imapd
Version: 3.4.6
Release: alt2

Summary: A high-performance email, contacts and calendar server
License: ALT-Cyrus
Group: System/Servers

# fresh sources available at https://github.com/cyrusimap/cyrus-imapd
Url: http://www.cyrusimap.org/

Source0: %name-%version.tar
Source1: cyrus-procmailrc
Source2: cyrus-user-procmailrc.template
Source3: %name.logrotate
Source4: %name.imapd-conf
Source5: README.ALT.rus
Source6: %name.control
Source7: %name.pam-config
Source8: %name-procmail+cyrus.mc
Source10: %name.sysconfig
Source11: %name.cvt_cyrusdb_all
Source12: %name.magic
Source13: %name.sasl-conf
Source14: %name.cron-daily
Source16: folderxfer
Source17: imapcreate.pl
Source18: inboxfer
Source19: %name-README.HOWTO-recover-mailboxes.db
Source20: %name-sendmail-8.12.9-cyrusv2.m4
Source21: %name.init
Source22: %name.cyrus-conf

Patch1: cyrus-imapd-3.0.11-setproctitle.c.patch
Patch2: cyrus-imapd-3.4.6-README-build-config.patch

Requires(pre): e2fsprogs /sbin/chkconfig /sbin/service cert-sh-functions
Requires: su, tzdata
Provides: MDA imap IMAPD POP3D

%if_with unit_tests
BuildRequires: CUnit-devel
BuildRequires: valgrind-devel
%endif

BuildRequires: control flex gcc-c++ transfig libdb4-devel zlib-devel libldap-devel libuuid-devel
BuildRequires: libsasl2-devel libssl-devel libnl-devel libsensors3-devel libpcre-devel libkrb5-devel

%if_with srs2
BuildRequires: libsrs2-devel
%endif

%if_with snmp
BuildRequires: libnet-snmp-devel
%endif

# http (CalDAV, CardDAV e.t.c.)
BuildRequires: libjansson-devel libical-devel libxml2-devel libsqlite3-devel

BuildRequires: perl-devel perl-Pod-Parser perl-Term-ReadLine-Gnu perl-Net-Server perl-Unix-Syslog

# 2.5.11
# BuildRequires: python-module-sphinx
# BuildRequires: perl-Pod-POM-View-Restructured

# 3.0.8
BuildRequires: perl-JSON xxd
%if_with sphinx
BuildRequires: perl-Pod-POM-View-Restructured
BuildRequires: python-module-GitPython
BuildRequires: python-module-sphinx >= 1.6
%endif

# 3.4.6
BuildRequires: libshape-devel libbrotli-devel libnghttp2-devel libchardet-devel

%description
The Cyrus IMAP (Internet Message Access Protocol) server provides
access to personal mail, system-wide bulletin boards, news-feeds,
calendar and contacts through the IMAP, NNTP, CalDAV and CardDAV
protocols. The Cyrus IMAP server is a scalable enterprise groupware
system designed for use from small to large enterprise environments
using technologies based on well-established Open Standards.

A full Cyrus IMAP implementation allows a seamless mail and bulletin
board environment to be set up across one or more nodes. It differs
from other IMAP server implementations in that it is run on "sealed
nodes", where users are not normally permitted to log in. The mailbox
database is stored in parts of the filesystem that are private to the
Cyrus IMAP system. All user access to mail is through software using
the IMAP, IMAPS, POP3, POP3S, KPOP, CalDAV and/or CardDAV protocols.

%package murder
Group: System/Servers
Summary: Cyrus IMAP server murder aggregator system files
Requires: %name = %version-%release

%description murder
The %name-murder package contains the Cyrus murder aggregator system,
i.e. IMAP, POP3 and LMTP proxies, and the mupdate mailbox master daemon.
It allows for cluster setups where there are many backend Cyrus spools
and frontend proxy servers.

%package ldap
Group: System/Servers
Summary: Cyrus IMAP server ldap auth system
Requires: %name = %version-%release

%description ldap
The %name-ldap package contains the Cyrus ldap auth system.

%package devel
Group: Development/C
Summary: Cyrus IMAP server development files

%description devel
The %name-devel package contains header files and libraries
necessary for developing applications which use the imclient library.

%package -n perl-Cyrus
Group: Development/Perl
Summary: Cyrus IMAP server utility Perl modules
Provides: perl(Cyrus/IMAP.pm) perl(Cyrus/IMAP/Admin.pm)

%description -n perl-Cyrus
The perl-Cyrus package contains Perl modules necessary to use the
Cyrus IMAP server administration utilities.

%package utils
Group: System/Servers
Summary: Cyrus IMAP server administration utilities
Requires: perl-Cyrus = %version-%release perl(Term/ReadLine.pm)

%description utils
The %name-utils package contains administrative tools for the
Cyrus IMAP server. It can be installed on systems other than the
one running the server.

%package doc
Group: System/Servers
Summary: Cyrus IMAP server documentation
BuildArch: noarch

%description doc
The %name-doc package contains Here the documentation about
Cyrus IMAP server.

%if_with sphinx
%package doc-full
Group: System/Servers
Summary: Cyrus documentation
BuildArch: noarch

%description doc-full
The %name-doc-full package contains complete Cyrus documentation
for IMAP server and SASL library
%endif

%prep
%setup
echo %version > VERSION

%patch1 -p1
%patch2 -p1

##
## hack to really enable pcre
##
%add_optflags -I%_includedir/pcre
# --
#sed "s|pcre\.h|pcre/pcre.h|"           -i  lib/util.h	#  include <pcre.h>
#sed "s|pcreposix\.h|pcre/pcreposix.h|" -i  lib/util.h	#  include <pcreposix.h>
# or
sed "s|@SSL_CPPFLAGS@|@SSL_CPPFLAGS@ -I%_includedir/pcre|" -i perl/imap/Makefile.PL.in
# --
sed "s|@ZLIB@|@ZLIB@ -lpcreposix|" -i perl/imap/Makefile.PL.in
sed "s|@ZLIB@|@ZLIB@ -lpcreposix|" -i perl/sieve/managesieve/Makefile.PL.in
# end hack

sed "s|AC_CANONICAL_SYSTEM|AC_CANONICAL_SYSTEM\nAC_SYS_LARGEFILE|" -i configure.ac

%if_with unit_tests
# Suite: command
#   Test: run ...FAILED
#     1. cunit/unit.c:115  - CU_FAIL_FATAL("Code under test exited")
sed "s|/usr/bin/touch|/bin/touch|" -i cunit/command.testc
%endif

%ifarch %e2k
# lcc before 1.24.03 can't do that (mcst#4061)
find -type f -print0 -name '*.c' |
	xargs -r0 sed -i 's,optimize("-O3"),optimize(3),g'
%endif

%build
autoreconf -v -i

%add_optflags -lcrypto -lsasl2 -lssl -DUSE_SETPROCTITLE
%add_optflags "-Wl,-z,noexecstack"

%configure \
  --with-extraident="%release" \
  \
  --sbindir=%_cyrexecdir \
  --libexecdir=%_cyrexecdir \
  \
  --enable-autocreate \
  --enable-idled \
  --enable-nntp \
  --enable-murder \
  --enable-http \
  --enable-calalarmd \
  --enable-replication \
  --enable-backup \
  %{?_with_srs2: --enable-srs} \
  \
  %{?_with_unit_tests: --enable-unit-tests} \
  \
  --enable-pcre \
  \
  %{?_with_snmp: --with-snmp} \
  %{?_without_snmp: --with-snmp=no} \
  --with-perl=perl \
  --with-ldap \
  --with-cyrus-user=%_cyrususer \
  --with-bdb-incdir=%_includedir/db4 \
  %{?_without_sphinx: --with-sphinx-build=no} \
  #

%make

# Modify docs master --> cyrus-master
pushd man
  sed -i 's/master(8)/cyrus-master(8)/' *5 *8
popd
pushd doc/legacy
  sed -i 's/master/cyrus-master/g' man.html

  fig2dev -L png murder.fig murder.png
  fig2dev -L png netnews.fig netnews.png
popd

# Modify path in perl scripts
find . -type f -name \*.pl -print0 |
    xargs -r0 perl -pi -e 's@\/usr\/local\/bin\/perl@perl@' --

%if_with unit_tests
%check
make check
%endif

%install

# libcyrus*.so.* contains big count undefined symbols. Is it plugins possible ?
# So, libcyrus*.so.* in main package while question in resolving statuis:
# http://lists.andrew.cmu.edu/pipermail/info-cyrus/2015-October/038550.html
%set_verify_elf_method unresolved=relaxed

# Do what the regular make install does
make install DESTDIR=%buildroot PREFIX=%prefix mandir=%_mandir \
	INSTALLDIRS=vendor

install -m 755 perl/imap/cyradm		%buildroot%_cyrexecdir/

# Install tools
#rm -f tools/git-version.sh tools/jenkins-build.sh tools/build-with-cyruslibs.sh
pushd tools
for tool in * ; do
  case "$tool" in
    git-version.sh|jenkins-build.sh|build-with-cyruslibs.sh)
	continue
	;;
    *)
	test -f ${tool} && install -m 755 ${tool} %buildroot%_cyrexecdir/
	;;
  esac
done
popd

install -d \
  %buildroot%_sysconfdir/{rc.d/init.d,logrotate.d,pam.d,sysconfig,cron.daily} \
  %buildroot%_libdir/sasl2 \
  %buildroot%_bindir \
  %buildroot%_spooldata/stage. \
  %buildroot%_vardata/{user,quota,proc,log,msg,socket,db,sieve,rpm,backup} \
  %buildroot%_contribdir \
  %buildroot%_datadir/%name/rpm

install -m 755 %SOURCE11   %buildroot%_cyrexecdir/cvt_cyrusdb_all
install -m 755 %SOURCE12   %buildroot%_datadir/%name/rpm/magic

install -m 644 %SOURCE22   %buildroot%_sysconfdir/cyrus.conf
install -m 644 %SOURCE4    %buildroot%_sysconfdir/imapd.conf
install -m 644 %SOURCE7    %buildroot%_sysconfdir/pam.d/pop
install -m 644 %SOURCE7    %buildroot%_sysconfdir/pam.d/imap
install -m 644 %SOURCE7    %buildroot%_sysconfdir/pam.d/sieve
install -m 644 %SOURCE7    %buildroot%_sysconfdir/pam.d/mupdate
install -m 644 %SOURCE7    %buildroot%_sysconfdir/pam.d/lmtp
install -m 644 %SOURCE7    %buildroot%_sysconfdir/pam.d/http
install -m 644 %SOURCE10   %buildroot%_sysconfdir/sysconfig/%name

install -m 755 %SOURCE21    %buildroot%_initdir/%name
install -m 644 %SOURCE3    %buildroot%_sysconfdir/logrotate.d/%name
install -m 755 %SOURCE14   %buildroot%_sysconfdir/cron.daily/%name
install -pDm600 %SOURCE13 %buildroot%_sysconfdir/sasl2/Cyrus.conf

install -m 755 -d doc/conf
install -pD -m 755 %SOURCE6 %buildroot%_controldir/%name

install -m 755 %SOURCE16 %SOURCE17 %SOURCE18  %buildroot%_contribdir
install -m 644 %SOURCE19 %SOURCE20 %SOURCE5 doc/

# Rename 'master' binary and manpage to avoid crash with postfix
mv -f %buildroot%_cyrexecdir/master	%buildroot%_cyrexecdir/cyrus-master
mv -f %buildroot%_mandir/man8/master.8 %buildroot%_mandir/man8/cyrus-master.8

# http://bugzilla.altlinux.org/33788
mv -f %buildroot%_man8dir/httpd.8 %buildroot%_man8dir/cyrus-httpd.8

# Move utilites from /usr/libexec/cyrus to /usr/bin
# mupdate-loadgen.pl convert-sieve.pl
for i in arbitronsort.pl cyradm \
	 mknewsgroups config2header masssievec
do
    mv %buildroot%_cyrexecdir/$i %buildroot/%_bindir/
done

# Create filelist for perl package, compress manpages before
[ -x /usr/lib/rpm/brp-compress ] && /usr/lib/rpm/brp-compress
find %buildroot%perl_vendor_autolib/Cyrus %buildroot%perl_vendor_archlib/Cyrus -type f -print |
  sed "s@^%buildroot@@g" |
  grep -v perllocal.pod |
  grep -v "\.bs" |
  grep -v "\.packlist" > perl-Cyrus-%version-filelist
if [ "$(cat perl-Cyrus-%version-filelist)X" = "X" ] ; then
  echo "ERROR: EMPTY FILE LIST"
  exit -1
fi

# Remove installed but not packaged files
rm -f %buildroot%_cyrexecdir/not-mkdep
find %buildroot -name "perllocal.pod" -exec rm -f {} \;
find %buildroot -name ".packlist" -exec rm -f {} \;
# scripts for building installed but not needed
rm -f %buildroot%_cyrexecdir/git-version.sh
rm -f %buildroot%_cyrexecdir/jenkins-build.sh

# Create file wich contains information about compiled db backends
for conf in DUPLICATE MBOX SEEN SUBS TLS
do
  echo CONFIG_DB_${conf}=$(grep "CONFIG_DB_${conf}" config.h | sed -e 's/)//' -e 's/_/-/g' | cut -d" " -f3 | cut -d"-" -f2) >> %buildroot%_datadir/%name/rpm/db.cfg
done

# directory for ssl-certs
install -dm750 %buildroot%_vardata/ssl

# imap sessions logs
mkdir -p %buildroot%_vardata/log/cyrus

# needed for %%ghost
touch %buildroot%_vardata/ssl/cyrus.cert
touch %buildroot%_vardata/ssl/cyrus.key

%add_findreq_skiplist /usr/bin/cyradm

# big doc section
%add_findreq_skiplist %_cyrexecdir/perl2rst
%if_with sphinx
pushd docsrc
    DOCSRC=./docsrc make html
    mkdir -p %buildroot%_defaultdocdir/%name-doc-full-%version
    cp -r build/html/* %buildroot%_defaultdocdir/%name-doc-full-%version
popd
%endif

%pre
/usr/sbin/groupadd -r -f %_cyrusgroup ||:
/usr/sbin/useradd -g %_cyrusgroup -G sasl -c "Cyrus IMAP Server" -d %_vardata \
  -s /dev/null -r %_cyrususer 2> /dev/null ||:

%post
%post_service %name
# Force synchronous updates, usually only on ext2 filesystems
for i in %_vardata/{user,quota} %_spooldata
do
	fstype=`find $i -maxdepth 0 -printf %%F`
	[ x"$fstype" = x"ext2" ] && chattr -R +S $i 2>/dev/null ||:
done

%preun
%preun_service %name

%files
# initscript
%_initdir/%name
%config(noreplace) %_sysconfdir/sysconfig/%name

# other stuff
%config %_controldir/*
%config(noreplace) %_sysconfdir/logrotate.d/%name
%config(noreplace) %_sysconfdir/cron.daily/%name

# cyrus configs
%config(noreplace) %_sysconfdir/cyrus.conf
%config(noreplace) %_sysconfdir/imapd.conf
%config(noreplace) %_sysconfdir/pam.d/imap
%config(noreplace) %_sysconfdir/pam.d/lmtp
%config(noreplace) %_sysconfdir/pam.d/http
%config(noreplace) %_sysconfdir/pam.d/pop
%config(noreplace) %_sysconfdir/pam.d/sieve
%config(noreplace) %attr(640,root,%_cyrusgroup) %_sysconfdir/sasl2/Cyrus.conf

# suid deliver
%attr(4710,%_cyrususer,%_cyrusgroup) %_cyrexecdir/deliver

# data dirs
%dir %attr(1770,root,%_cyrusgroup) %_vardata
%dir %attr(1770,root,%_cyrusgroup) %_vardata/*
%dir %attr(1770,root,%_cyrusgroup) %_vardata/log/*
%dir %attr(1770,root,%_cyrusgroup) %_spooldata
%dir %attr(1770,root,%_cyrusgroup) %_spooldata/*

%_datadir/%name
%if_with sphinx
%_man5dir/*
%_man8dir/*
%endif

# ssl-related
%dir %attr(0750,root,%_cyrusgroup) %_vardata/ssl
%ghost %attr(0640,root,%_cyrusgroup) %verify(not md5 mtime size) %_vardata/ssl/cyrus.cert
%ghost %attr(0640,root,%_cyrusgroup) %verify(not md5 mtime size) %_vardata/ssl/cyrus.key

%_cyrexecdir
%exclude %_cyrexecdir/lmtpproxyd
%exclude %_cyrexecdir/mupdate
%exclude %_cyrexecdir/pop3proxyd
%exclude %_cyrexecdir/proxyd
%exclude %_cyrexecdir/ptdump
%exclude %_cyrexecdir/ptexpire
%exclude %_cyrexecdir/ptloader
%exclude %_contribdir

%_libdir/libcyrus*.so.*

%files doc
%doc COPYING README.md README-build-config
%doc $RPM_SOURCE_DIR/cyrus-procmailrc
%doc $RPM_SOURCE_DIR/cyrus-user-procmailrc.template
%doc $RPM_SOURCE_DIR/%name-procmail+cyrus.mc
%doc doc/*

%if_with sphinx
%files doc-full
%_defaultdocdir/%name-doc-full-%version
%endif

%files murder
%config(noreplace) %_sysconfdir/pam.d/mupdate
%_cyrexecdir/lmtpproxyd
%_cyrexecdir/mupdate
%_cyrexecdir/pop3proxyd
%_cyrexecdir/proxyd

%files ldap
%_cyrexecdir/ptdump
%_cyrexecdir/ptexpire
%_cyrexecdir/ptloader

%files devel
%_includedir/cyrus
%_libdir/*.so
#_libdir/lib*.a
%if_with sphinx
%_man3dir/*
%endif
%_libdir/pkgconfig/*

%files -n perl-Cyrus
%perl_vendor_autolib/Cyrus*
%perl_vendor_archlib/Cyrus*
%perl_vendor_privlib/Cyrus*
%doc perl/imap/README
%doc perl/imap/Changes
%doc perl/imap/examples

%files utils
%_contribdir
%_bindir/*
%_man1dir/*
%dir %_datadir/%name

%changelog
