# libddccontrol_dbus_client use symbols from libddccontrol
%set_verify_elf_method unresolved=relaxed
%def_without beesu
# applet is not supported on Gnome 3
%def_disable applet
%def_disable static
%def_disable ddcpci
%ifarch x86_64 %ix86
%def_enable ddcpci
%endif

%def_enable doc
%define ddcreleasedate 20200630gitf3d003f

Name: ddccontrol
Version: 0.4.4
Release: alt1.%ddcreleasedate

Summary: Control your monitor by software using the DDC/CI protocol
License: GPLv2+
Group: System/Configuration/Hardware

URL: http://ddccontrol.sourceforge.net/
Vcs: git://github.com/ddccontrol/ddccontrol
Source0: ddccontrol-%version.tar
Source1: %{name}-modules-autoload.conf
Patch2: ddccontrol-0.4.2-desktop-alt11.patch
Patch3: ddccontrol-0.4.4-alt-fix-linkage.patch
Patch5: ddccontrol-0.4.2-russian.patch
Patch6: ddccontrol-0.4.4-autopoint.patch

BuildRequires: intltool libICE-devel libpci-devel libxml2-devel libgtk+2-devel libsystemd-devel
%if_enabled applet
BuildRequires: libgnome-panel-devel libgtk+3-devel
%endif
%if_enabled doc
BuildRequires: xsltproc docbook-style-xsl tidy
%endif

Requires: ddccontrol-db
Requires: lib%{name} = %version-%release
# gddccontrol .destkop
%if_with beesu
Requires: beesu
%else
Requires: xdg-utils
%endif

%description
DDCcontrol is a program used to control monitor parameters, like brightness and
contrast, by software, i.e. without using the OSD (On Screen Display) and the
buttons in front of the monitor.

%package -n lib%{name}
Summary: Libddccontrol library 
Group: Development/Other

%description -n lib%{name}
DDCcontrol is a program used to control monitor parameters, like brightness and
contrast, by software, i.e. without using the OSD and the buttons in front of
the monitor.

%package -n lib%{name}-devel
Summary: Libddccontrol library headers and development libraries
Group: Development/Other
Requires: lib%{name} = %version-%release

%description -n lib%{name}-devel
libddccontrol devel files

%package -n gddccontrol
Summary: GUI for controlling your monitor using the DDC/CI protocol
Group: System/Configuration/Hardware
Requires: %name = %version-%release

%description -n gddccontrol
DDCcontrol is a program used to control monitor parameters, like brightness and
contrast, by software, i.e. without using the OSD and the buttons in front of
the monitor.

gddccontrol is a GUI for ddccontrol.

%package applet
Summary: GNOME applet for ddccontrol
Group: Graphical desktop/GNOME
Requires: %name = %version-%release

%description applet
GNOME applet for ddccontrol.

%prep
%setup
%patch2 -p1
%patch3 -p1
%patch5 -p1
%patch6 -p1 -b .autopoint

%build
touch config.rpath
./autogen.sh
%configure \
    %configure \
    %{subst_enable static} \
    %{subst_enable doc} \
    %{subst_enable ddcpci} \
    --disable-rpath \
%if_disabled applet
    --disable-gnome-applet
%endif

# safety belts :)
echo "#define HAVE_BUGGY_I2C_DEV 1" >>src/config.h
%make_build

%install
%makeinstall_std

rm -rf %buildroot%_datadir/doc/%name

%if_with beesu
sed -i -e s,xdg-su,beesu, %buildroot/%_desktopdir/*.desktop
%endif

# autoload i2c-dev module
install -m 644 -D %SOURCE1 %buildroot%_sysconfdir/modules-load.d/%name.conf

%find_lang %name

%post
# autoload i2c-dev module
/sbin/modprobe i2c-dev &>/dev/null || :

%files -f %name.lang
%doc AUTHORS NEWS doc/html
%_bindir/ddccontrol
#%_bindir/ddcpci
%_man1dir/%{name}*
%_sysconfdir/modules-load.d/%name.conf
%if_enabled ddcpci
%_libexecdir/%name/ddcpci
%endif
%_unitdir/ddccontrol.service
%_libexecdir/%name/ddccontrol_service
%_datadir/dbus-1/interfaces/ddccontrol.DDCControl.xml
%_datadir/dbus-1/system-services/ddccontrol.DDCControl.service
%_sysconfdir/dbus-1/system.d/ddccontrol.DDCControl.conf

%files -n gddccontrol
%_bindir/gddccontrol
%_man1dir/g%{name}*
%_desktopdir/*
%_liconsdir/*
%_iconsdir/Bluecurve/48x48/apps/gddccontrol.png

%files -n lib%{name}
%_libdir/*.so.*

%files -n lib%{name}-devel
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*.pc



%if_enabled applet
%files applet
%dir %_libdir/ddccontrol
%_libdir/ddccontrol/ddcc-applet
%_datadir/ddccontrol
%_libdir/bonobo/servers/*
%endif

%changelog
