Name: dfu-util
Version: 0.10
Release: alt1

Summary: USB Device Firmware Upgrade tool

License: GPLv2+
Group: Development/Tools
Url: http://dfu-util.sourceforge.net/

Source: http://dfu-util.sourceforge.net/releases/%name-%version.tar

BuildRequires: gcc
BuildRequires: libusb-devel

%description
USB Device Firmware Upgrade (DFU) is an official USB device class specification
of the USB Implementers Forum. It specifies a vendor and device independent way
of updating the firmware of a USB device. The idea is to have only one
vendor-independent firmware update tool as part of the operating system, which
can then (given a particular firmware image) be downloaded into the device.

In addition to firmware download, it also specifies firmware upload, i.e.
loading the currently installed device firmware to the USB Host.

The DFU specification can be found at:
 http://www.usb.org/developers/devclass_docs/usbdfu10.pdf

%prep
%setup

%build
%configure
%make_build

%install
%makeinstall_std

%files
%doc --no-dereference COPYING
%doc ChangeLog README DEVICES.txt TODO
%_bindir/dfu-prefix
%_bindir/dfu-suffix
%_bindir/dfu-util
%_man1dir/*

%changelog
