# -*- rpm-spec -*-
# $Id: dialog,v 1.5 2003/09/05 10:17:48 grigory Exp $
%define major 1.3
%define snapshot 20171209

Name: dialog
Version: %major.%snapshot
Release: alt1

Summary: A utility for creating TTY dialog boxes

License: LGPLv2
Group: Development/Other
Url: http://invisible-island.net/dialog/

#Source: ftp://invisible-island.net/dialog/%name-%version.tar
# Source-url: ftp://ftp.invisible-island.net/dialog/dialog-%major-%snapshot.tgz
Source: %name-%version.tar

BuildRequires: ncurses-devel gcc gettext findutils libtool

Patch1: dialog-incdir.patch
Patch2: dialog-multilib.patch

Provides: cdialog
Obsoletes: cdialog

Requires: terminfo

Requires: lib%name = %version-%release

BuildPreReq: libncursesw-devel libtinfo-devel

%description
Dialog is a utility that allows you to show dialog boxes (containing
questions or messages) in TTY (text mode) interfaces.  Dialog is called
from within a shell script.  The following dialog boxes are implemented:
yes/no, menu, input, message, text, info, checklist, radiolist, and
gauge.

Install dialog if you would like to create TTY dialog boxes.

%package -n lib%name
Summary: Libraries for dialog
Group: System/Libraries

%description -n lib%name
Libraries for dialog.

%package -n lib%name-devel
Summary: Libraries and headers files for dialog
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
Libraries and header files for dialog.

%package -n lib%name-devel-static
Summary: Static dialog library
Group: Development/C
Requires: lib%name-devel = %version-%release

%description -n lib%name-devel-static
Static dialog library.

%prep
%setup
%patch1 -p1 -b .incdir
%patch2 -p1 -b .multilib

%build
%configure \
	--with-libtool \
	--enable-nls \
	--with-ncursesw \
	--disable-rpath-hack
%make_build

%install
%makeinstall_std install-lib

# hack due obsoleted configure
rm -rf %buildroot%_libdir/.libs/

%find_lang %name

%files -f %name.lang
%doc CHANGES COPYING README samples
%_bindir/dialog
%_man1dir/dialog.*

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_bindir/dialog-config
%_libdir/*.so
%_includedir/*.h
%_man3dir/dialog.*

%files -n lib%name-devel-static
%_libdir/*.a

%changelog
