%def_without jack
Name: din
Version: 43
Release: alt1
License: GPLv2
Summary: Edit waveforms in a GUI, and watch the sound change before your ears
Group: Sound
Source: %name-%version.tar.gz
Url: http://dinisnoise.org/

# Automatically added by buildreq on Wed May 23 2018
# optimized out: fontconfig glibc-kernheaders-generic glibc-kernheaders-x86 libGL-devel libGLU-devel libgpg-error libstdc++-devel perl python-base python-modules
BuildRequires: ImageMagick-tools boost-devel-headers gcc-c++ libSDL-devel libalsa-devel tcl-devel
%if_with jack
BuildRequires: libjack-devel
%endif

%description
If Puredata and Supercollider are two synths, din is a synth of a 3rd kind.
It forgets history, To not repeat it.
It doesnt hide analog music hardware, In digital music software.
You had pulse, sine, triangle and sawtooth,
And went forth and made electronic music.
Now there is just the Bezier curve. Go make your pulse, sine, triangle and sawtooths.
This is nothing new. Some old men did it in the 60s!
Punched numbers into cards. Now you edit waveforms in a GUI,
And watch the sound change before your ears.
Has it got ADSR? It's got DADSARSADS.
Filters? Infinite length delay lines.
With Bezier envelope for feedback and volume.
Modulation? Bezier on Carrier and Modulator. Eat that Chowning.
Notes? Notes! Notes! Notes! Infinite microtones between two tones.
Livecoding? In Tcl. Like LISP, but no ((((:-))))

Collaboration? MIDI. OSC. IRC.

%prep
%setup

%define bmsizes 128 96 64 48 32 24 16
%build
%if_with jack
%autoreconf
%configure --prefix=%prefix CXXFLAGS="-D__UNIX_JACK__"
%make_build
%else
sed -i 's/-ljack//g' src/Makefile.am
%autoreconf
%configure --prefix=%prefix CXXFLAGS="-D__LINUX_ALSA__"
%make_build
%endif
for N in %bmsizes; do convert pixmaps/din.png $N.png; done

%install
%makeinstall
for N in %bmsizes; do
	install -D $N.png %buildroot%_iconsdir/hicolor/${N}x${N}/apps/%name.png
done

%files
%doc README
%_bindir/*
%dir %_datadir/%name
%_datadir/%name/*
%_desktopdir/*
%_iconsdir/hicolor/*/apps/*
%_pixmapsdir/*

%changelog
