Name: dirac
Version: 1.0.2
Release: alt2.1

Summary: Video Codec based on Wavelets
License: MPL/GPL/LGPL
Group: Video

Url: http://diracvideo.org
Source: http://prdownloads.sourceforge.net/%name/%name-%version.tar.gz
Patch0: http://pkgs.fedoraproject.org/cgit/rpms/dirac.git/plain/dirac-1.0.2-backports.patch
Patch1: http://pkgs.fedoraproject.org/cgit/rpms/dirac.git/plain/0001-Fix-uninitialised-memory-read-that-causes-the-encode.patch
Packager: Ilya Mashkin <oddity@altlinux.ru>

BuildRequires: doxygen gcc-c++ graphviz libstdc++-devel texlive-collection-basic texlive-collection-latexrecommended
BuildRequires: chrpath

%description
Dirac is an open source video codec. It uses a traditional hybrid
video codec architecture, but with the wavelet transform instead of
the usual block transforms.  Motion compensation uses overlapped
blocks to reduce block artefacts that would upset the transform coding
stage.

Dirac can code just about any size of video, from streaming up to HD
and beyond, although certain presets are defined for different
applications and standards.  These cover the parameters that need to
be set for the encoder to work, such as block sizes and temporal
prediction structures, which must otherwise be set by hand.

%package -n lib%name
Group: System/Libraries
Summary: Shared library of the Dirac Video codec

%description -n lib%name
Dirac is an open source video codec. It uses a traditional hybrid
video codec architecture, but with the wavelet transform instead of
the usual block transforms.  Motion compensation uses overlapped
blocks to reduce block artefacts that would upset the transform coding
stage.

Dirac can code just about any size of video, from streaming up to HD
and beyond, although certain presets are defined for different
applications and standards.  These cover the parameters that need to
be set for the encoder to work, such as block sizes and temporal
prediction structures, which must otherwise be set by hand.

%package -n lib%name-devel
Group: Development/C++
Summary: Development files of the Dirac Video codec
Requires: lib%name = %version-%release

%description -n lib%name-devel
Dirac is an open source video codec. It uses a traditional hybrid
video codec architecture, but with the wavelet transform instead of
the usual block transforms.  Motion compensation uses overlapped
blocks to reduce block artefacts that would upset the transform coding
stage.

Dirac can code just about any size of video, from streaming up to HD
and beyond, although certain presets are defined for different
applications and standards.  These cover the parameters that need to
be set for the encoder to work, such as block sizes and temporal
prediction structures, which must otherwise be set by hand.

%package utils
Group: Video
Summary: Example encoder and decoder for the Dirac video codec

%description utils
Dirac is an open source video codec. It uses a traditional hybrid
video codec architecture, but with the wavelet transform instead of
the usual block transforms.  Motion compensation uses overlapped
blocks to reduce block artefacts that would upset the transform coding
stage.

Dirac can code just about any size of video, from streaming up to HD
and beyond, although certain presets are defined for different
applications and standards.  These cover the parameters that need to
be set for the encoder to work, such as block sizes and temporal
prediction structures, which must otherwise be set by hand.

%prep
%setup
%patch0 -p0
%patch1 -p1
find doc unit_tests util libdirac_encoder libdirac_byteio \
	-type f -name \* -exec chmod 644 {} \;
sed -i 's/-Werror//g' configure*

%build
#autoreconf
%configure \
	--disable-static \
%ifarch x86_64
	--enable-mmx=yes \
%endif
	#

sed -ri 's/^(hardcode_libdir_flag_spec|runpath_var)=.*/\1=/' libtool

%make_build

%install
%makeinstall_std

# FIXME: should not be there in the first place
chrpath -d %buildroot%_bindir/dirac*

%files utils
%doc README TODO AUTHORS
%_bindir/dirac*
%_bindir/BMPtoRGB
%_bindir/RGB*
%_bindir/UYVYtoRGB
%_bindir/YUV*
%_bindir/create_dirac_testfile.pl

%files -n lib%name
%_libdir/libdirac*.so.*

%files -n lib%name-devel
%_includedir/%name/
%_libdir/libdirac*.so
%_datadir/doc/%name/
%_libdir/pkgconfig/dirac.pc

%changelog
