## %%define snapshot 20080311

Name: docbook-style-xsl
Version: 1.79.1
Release: alt4
Group: Publishing

Summary: Norman Walsh's XSL stylesheets for DocBook XML

License: DMIT
Url: http://docbook.sourceforge.net/projects/xsl/

%ifdef snapshot
%define actual_version snapshot
%define actual_archive zip
%else
%define actual_version %version
%define actual_archive tar.bz2
%endif

%define xmlbase		%_datadir/xml
%define xmlconfdir	%_sysconfdir/xml
%define hack_output_encodings koi8-r koi8-u windows-1251

Provides: docbook-xsl = %{version}
Requires: docbook-dtd-xml
PreReq: xml-common xml-utils

AutoReq: yes

Source0: http://prdownloads.sourceforge.net/docbook/docbook-xsl-%{actual_version}.%{actual_archive}
Source1: http://prdownloads.sourceforge.net/docbook/docbook-xsl-doc-%{actual_version}.%{actual_archive}
Source2: docbook-output-stub.xsl
Source3: docbook-add-output-encoding.xsl
Source4: %{name}.Makefile

# Fedora Core patches
#Avoid proportional-column-width for passivetex (bug #176766).
Patch1: docbook-xsl-pagesetup.patch
#Hard-code the margin-left work around to expect passivetex (bug #113456).
Patch2: docbook-xsl-marginleft.patch
#fix of #161619 - adjustColumnWidths now available
Patch3: docbook-xsl-newmethods.patch
#change a few non-constant expressions to constant - needed for passivetex(#366441)
Patch4: docbook-xsl-non-constant-expressions.patch
#added fixes for passivetex extension and list-item-body(#161371)
Patch5: docbook-xsl-list-item-body.patch
#workaround missing mandir section problem (#727251)
Patch6: docbook-xsl-mandir.patch
# (ALT #34215)
Patch7: docbook-style-xsl-non-recursive-string-subst.patch


BuildArch: noarch
BuildRequires: xsltproc perl-base xml-utils unzip

%package doc
Summary: Documentation for DocBook XSL stylesheets
Group: Publishing
AutoReqProv: none

%description
These XSL stylesheets allow to convert any DocBook document to other
formats, including those suited for print formatting (FO), online use
(HTML, XHTML), and manual files (man, htmlhelp, javahelp).
The stylesheets are highly customizable.

%description doc
This package contains extensive documentation to DocBook XSL stylesheets
in the HTML format.

%prep
%setup -n docbook-xsl-%{actual_version} -b 1
%patch1 -p1 -b .pagesetup
%patch2 -p1 -b .marginleft
%patch3 -p1 -b .newmethods
%patch4 -p1 -b .nonconstant
%patch5 -p1 -b .listitembody
%patch6 -p1 -b .mandir
%patch7 -p2 -b .stringsubst

find . -type f -name '*.xsl.orig' -delete
find . -type f -name '.gitignore' -delete
find . -type f -perm /a+x -print0 | xargs -r0 chmod a-x --

cp -p %{SOURCE4} Makefile

# fix of non UTF-8 files rpmlint warnings
for fhtml in $(find ./doc -name '*.html' -type f)
do
  iconv -f ISO-8859-1 -t UTF-8 "$fhtml" -o "$fhtml".tmp
  mv -f "$fhtml".tmp "$fhtml"
  sed -i 's/charset=ISO-8859-1/charset=UTF-8/' "$fhtml"
done

for f in $(find -name "*'*")
do
  mv -v "$f" $(echo "$f" | tr -d "'")
done

%build
for enc in %hack_output_encodings; do
    xsltproc -o html/docbook-$enc.xsl --stringparam output.encoding $enc \
	%SOURCE3 %SOURCE2
done

%install

DESTDIR=$RPM_BUILD_ROOT
rm -rf $RPM_BUILD_ROOT
make install BINDIR=$DESTDIR%{_bindir} DESTDIR=$DESTDIR%xmlbase/docbook/xsl-stylesheets-%{version}
cp -a VERSION.xsl $DESTDIR%xmlbase/docbook/xsl-stylesheets-%{version}/VERSION.xsl
ln -s xsl-stylesheets-%{version} \
	$DESTDIR%xmlbase/docbook/xsl-stylesheets
# compat symlink
mkdir -p %buildroot/%_datadir/sgml/docbook
ln -s ../../xml/docbook/xsl-stylesheets-%{version} \
        %buildroot/%_datadir/sgml/docbook/xsl-stylesheets

# Don't ship the extensions (bug #177256).
rm -rf $DESTDIR%xmlbase/docbook/xsl-stylesheets/extensions/*

# relic of the past? do we need it?
install -p -m644 catalog.xml \
    %buildroot%xmlbase/docbook/xsl-stylesheets-%version/

%files
%doc AUTHORS BUGS COPYING NEWS* README RELEASE-NOTES.* TODO
%xmlbase/docbook/xsl-stylesheets-%version
%xmlbase/docbook/xsl-stylesheets
# compat symlink
%_datadir/sgml/docbook/xsl-stylesheets

%files doc
%doc doc/*

%post
CATALOG=%xmlconfdir/catalog
/usr/bin/xmlcatalog --noout --add "rewriteSystem" \
	"http://docbook.sourceforge.net/release/xsl/%version" \
	"%xmlbase/docbook/xsl-stylesheets-%version" $CATALOG ||:
/usr/bin/xmlcatalog --noout --add "rewriteURI" \
	"http://docbook.sourceforge.net/release/xsl/%version" \
	"%xmlbase/docbook/xsl-stylesheets-%version" $CATALOG ||:
/usr/bin/xmlcatalog --noout --add "rewriteSystem" \
	"http://docbook.sourceforge.net/release/xsl/current" \
	"%xmlbase/docbook/xsl-stylesheets-%version" $CATALOG ||:
/usr/bin/xmlcatalog --noout --add "rewriteURI" \
	"http://docbook.sourceforge.net/release/xsl/current" \
	"%xmlbase/docbook/xsl-stylesheets-%version" $CATALOG ||:

%postun
if [ ! -d "%xmlbase/docbook/xsl-stylesheets-%version" ]; then
    CATALOG=%xmlconfdir/catalog
    /usr/bin/xmlcatalog --noout --del \
	"%xmlbase/docbook/xsl-stylesheets-%version" $CATALOG ||:
fi

%changelog
