Name: docbook5-style-xsl
Version: 1.79.2
Release: alt2
Group: Text tools

Summary: Norman Walsh's XSL stylesheets for DocBook 5.X

# Package is licensed as MIT/X (http://wiki.docbook.org/topic/DocBookLicense),
# some .js files under ./slides/browser/ are licensed MPLv1.1
License: MIT and MPL-1.1
Url: https://github.com/docbook/xslt10-stylesheets

Provides: docbook-xsl-ns = %version
# something that works
Requires: xml-common >= 0.6.3-alt15

BuildArch: noarch
Source0: https://github.com/docbook/xslt10-stylesheets/releases/download/release/%version/docbook-xsl-%version.tar

%description
These XSL namespace aware stylesheets allow you to transform any
DocBook 5 document to other formats, such as HTML, manpages, FO,
XHMTL and other formats. They are highly customizable. For more
information see W3C page about XSL.

%prep
%setup -n docbook-xsl-%version

%install
%global targetdir %_datadir/sgml/docbook/xsl-ns-stylesheets
mkdir -p %buildroot%targetdir-%version
cp -a [[:lower:]]* VERSION.xsl %buildroot%targetdir-%version/
ln -s VERSION.xsl %buildroot%targetdir-%version/VERSION
ln -s xsl-ns-stylesheets-%version %buildroot%targetdir

# Don't ship install shell script.
rm %buildroot%targetdir/install.sh
# Don't ship Java extensions in Fedora as they are not compiled from the source.
rm -r %buildroot%targetdir-%version/extensions

%add_findreq_skiplist %targetdir-%version/slides/slidy/help/help.html.* %targetdir-%version/epub/bin/dbtoepub

%post
for orig in 'http://cdn.docbook.org/release/xsl/%version' \
	   'http://cdn.docbook.org/release/xsl/current' \
	   'http://docbook.sourceforge.net/release/xsl-ns/current'; do
	for type in rewriteSystem rewriteURI; do
		xmlcatalog --noout --add "$type" \
		"$orig" 'file://%targetdir-%version' \
		%_sysconfdir/xml/catalog
	done
done

%postun
if [ "$1" = 0 ]; then
	xmlcatalog --noout --del \
		'file://%targetdir-%version' \
		%_sysconfdir/xml/catalog
fi

%files
%targetdir/
%targetdir-%version/
%doc README COPYING RELEASE-NOTES.txt NEWS BUGS

%changelog
