# git describe upstream/dolphin-emu | sed 's/-g[0-9a-f]*\(+*\)$/\1/'
%define git_version 5.0-19870
# git show-ref --heads --hash upstream/dolphin-emu
%define git_commit 032c77b462a220016f23c5079e71bb23e0ad2adf

%define implot_commit cc5e1daa5c7f2335a9460ae79c829011dc5cef2d
%define rcheevos_commit d9e990e6d13527532b7e2bb23164a1f3b7f33bb5

Name: dolphin-emu
Version: 5.0.19870
Release: alt0.p10.1

Summary: The Gamecube / Wii Emulator
License: GPLv2
Group: Emulators

Url: https://%name.org/
Packager: Nazarov Denis <nenderus@altlinux.org>

ExclusiveArch: x86_64 aarch64

# https://github.com/%name/dolphin/archive/%git_commit/dolphin-%git_commit.tar.gz
Source0: dolphin-%git_commit.tar
# https://github.com/epezent/implot/archive/%implot_commit/implot-%implot_commit.tar.gz
Source1: implot-%implot_commit.tar
# https://github.com/RetroAchievements/rcheevos/archive/%rcheevos_commit/rcheevos-%rcheevos_commit.tar.gz
Source2: rcheevos-%rcheevos_commit.tar

Patch0: dolphin-gbacore-alt.patch

BuildRequires: bzlib-devel
BuildRequires: cmake
BuildRequires: libSFML-devel
BuildRequires: libXcomposite-devel
BuildRequires: libXcursor-devel
BuildRequires: libXdamage-devel
BuildRequires: libXdmcp-devel
BuildRequires: libXft-devel
BuildRequires: libXi-devel
BuildRequires: libXinerama-devel
BuildRequires: libXmu-devel
BuildRequires: libXrandr-devel
BuildRequires: libXxf86vm-devel
BuildRequires: libalsa-devel
BuildRequires: libavformat-devel
BuildRequires: libbluez-devel
BuildRequires: libcubeb-devel
BuildRequires: libcurl-devel
BuildRequires: libenet-devel
BuildRequires: libevdev-devel
BuildRequires: libffi-devel
BuildRequires: libfmt-devel
BuildRequires: libgtest-devel
BuildRequires: libhidapi-devel
BuildRequires: liblzma-devel
BuildRequires: liblzo2-devel
BuildRequires: libmbedtls-compat-devel
BuildRequires: libmgba-devel
BuildRequires: libminiupnpc-devel
BuildRequires: libminizip-ng-compat-devel
BuildRequires: libpugixml-devel
BuildRequires: libpulseaudio-devel
BuildRequires: libspng-devel
BuildRequires: libswresample-devel
BuildRequires: libswscale-devel
BuildRequires: libsystemd-devel
BuildRequires: libtinfo-devel
BuildRequires: libudev-devel
BuildRequires: libusb-devel
BuildRequires: libvulkan-memory-allocator-devel
BuildRequires: libxml2-devel
BuildRequires: libzstd-devel
BuildRequires: llvm-devel-static
BuildRequires: qt6-svg
BuildRequires: qt6-svg-devel
BuildRequires: zlib-ng-devel

%description
Dolphin-emu is a emulator for Gamecube, Wii, Triforce that lets
you run Wii/GCN/Tri games on your Windows/Linux/Mac PC system.

%prep
%setup -n dolphin-%git_commit -b 1 -b 2

%__mv -Tf ../implot-%implot_commit Externals/implot/implot
%__mv -Tf ../rcheevos-%rcheevos_commit Externals/rcheevos/rcheevos

%patch0 -p1

%build
export LDFLAGS="-Wl,--copy-dt-needed-entries"

#Generate Version Strings
echo "#define SCM_REV_STR \"%git_commit\"
#define SCM_DESC_STR \"%git_version\"
#define SCM_BRANCH_STR \"master\"
#define SCM_IS_MASTER 1
#define SCM_DISTRIBUTOR_STR \"ALT Linux Team\"
#define SCM_UPDATE_TRACK_STR \"\"" > Source/Core/Common/scmrev.h.in

%cmake .. \
	-DENABLE_LTO:BOOL=TRUE \
	-Wno-dev

%cmake_build

%install
%cmake_install
%__install -Dp -m0644 Data/51-usb-device.rules %buildroot%_udevrulesdir/51-%name-usb-device.rules
%find_lang %name

%files -f %name.lang
%_bindir/*
%_desktopdir/%name.desktop
%_datadir/%name
%_iconsdir/hicolor/256x256/apps/%name.png
%_iconsdir/hicolor/scalable/apps/%name.svg
%_man6dir/%{name}*
%config %_udevrulesdir/51-%name-usb-device.rules

%changelog
