# TODO: dropout dotnet-common package with dirs
%define _dotnet_archlist aarch64 x86_64

%ifarch x86_64
%define _dotnet_arch x64
%else
%ifarch aarch64
%define _dotnet_arch arm64
%else
%define _dotnet_arch %arch
%endif
%endif
%define _dotnet_rid linux-%_dotnet_arch

Name: dotnet-common
Version: 6.0.1
Release: alt1

Summary: Common dir and files for the .NET Core runtime and libraries

License: MIT
Group: Development/Other

Source: %name-%version.tar

#ExclusiveArch: %_dotnet_archlist

%description
Common dir and files for the .NET runtime and libraries.

%package -n rpm-macros-dotnet
Summary: RPM macros for build dotnet packages
Group: Development/Other

%description -n rpm-macros-dotnet
RPM macros for build dotnet packages.

%prep
%setup

cat <<EOF >macros
# define in your spec:
#_dotnet_major
#_dotnet_corerelease
#_dotnet_sdkrelease
#_dotnet_coreapprefrelease
#_dotnet_aspnetcorerelease
#_dotnet_aspnetcoreapprefrelease
#_dotnet_templatesrelease
#_dotnet_netstandartrelease
#_dotnet_sdkmanifestsrelease

%%_dotnet_archlist %_dotnet_archlist
%%_dotnet_rid %_dotnet_rid
%%_dotnet_arch %_dotnet_arch
%%_dotnetdir %_libdir/dotnet
%%_dotnet_hostfxr %%_dotnetdir/host/fxr/%%_dotnet_corerelease/
%%_dotnet_coreapp %%_dotnetdir/shared/Microsoft.NETCore.App/%%_dotnet_corerelease
%%_dotnet_coreapphost %%_dotnetdir/packs/Microsoft.NETCore.App.Host.%%_dotnet_rid/%%_dotnet_corerelease
%%_dotnet_coreappref %%_dotnetdir/packs/Microsoft.NETCore.App.Ref/%%_dotnet_coreapprefrelease
%%_dotnet_aspnetcoreapp %%_dotnetdir/shared/Microsoft.AspNetCore.App/%%_dotnet_aspnetcorerelease
%%_dotnet_aspnetcoreappref %%_dotnetdir/packs/Microsoft.AspNetCore.App.Ref/%%_dotnet_aspnetcoreapprefrelease
%%_dotnet_templates %%_dotnetdir/templates/%%_dotnet_templatesrelease
%%_dotnet_netstandart %%_dotnetdir/packs/NETStandard.Library.Ref/%%_dotnet_netstandartrelease
%%_dotnet_sdk %%_dotnetdir/sdk/%%_dotnet_sdkrelease
%%_dotnet_sdkmanifests %%_dotnetdir/sdk-manifests/%%_dotnet_sdkmanifestsrelease

%%_dotnet_corepkgrelease %%(echo "%%_dotnet_corerelease" | sed -e "s|\-|.|g")
%%_dotnet_sdkpkgrelease %%(echo "%%_dotnet_sdkrelease" | sed -e "s|\-|.|g")

# for compatibility
%%_dotnet_apphostdir %%_dotnetdir/packs/Microsoft.NETCore.App.Host.%%_dotnet_rid/%%_dotnet_corerelease
%%_dotnet_shared %%_dotnetdir/shared/Microsoft.NETCore.App/%%_dotnet_corerelease
%%_dotnet_appref %%_dotnetdir/packs/Microsoft.NETCore.App.Ref/%%_dotnet_apprefrelease
EOF

%install
mkdir -p %buildroot%_libdir/dotnet/
mkdir -p %buildroot%_libdir/dotnet/shared/Microsoft.NETCore.App/
mkdir -p %buildroot%_libdir/dotnet/host/fxr/
mkdir -p %buildroot%_libdir/dotnet/packs/
mkdir -p %buildroot%_libdir/dotnet/templates/

install -D -m644 macros %buildroot%_rpmmacrosdir/dotnet

%files
%dir %_libdir/dotnet/

%dir %_libdir/dotnet/host/
%dir %_libdir/dotnet/host/fxr/

%dir %_libdir/dotnet/packs/
%dir %_libdir/dotnet/templates/

%dir %_libdir/dotnet/shared/
%dir %_libdir/dotnet/shared/Microsoft.NETCore.App/

%files -n rpm-macros-dotnet
%_rpmmacrosdir/dotnet

%changelog
