%define _unpackaged_files_terminate_build 1

%define pre %nil
%define _dotnet_major 3.1
#define _dotnet_sdkrelease 5.0.103

%define exedir artifacts/bin/%_dotnet_rid.Debug/corehost


Name: dotnet-hostfxr-%_dotnet_major
Version: 3.1.32
Release: alt1

Summary: Installer packages for the .NET Core runtime and libraries

License: MIT
Url: https://github.com/dotnet/core-setup
Group: Development/Other

# Source-url: %url/archive/v%version%pre.tar.gz
Source: %name-%version.tar

%define _dotnet_corerelease %version


ExclusiveArch: aarch64 x86_64

BuildRequires: clang llvm

BuildRequires: cmake libstdc++-devel

BuildRequires(pre): rpm-macros-dotnet

Conflicts: dotnet <= 3.1.6-alt1

Requires: dotnet-common

%description
This repo contains the code to build the .NET Core runtime,
libraries and shared host (dotnet) installers for all supported platforms.
It does not contain the actual sources to .NET Core runtime;
this source is split across the dotnet/coreclr repo (runtime)
and dotnet/corefx repo (libraries).

# common for current version
%package -n dotnet-%_dotnet_major
Version: %_dotnet_corerelease
Group: Development/Other
Summary: .NET %_dotnet_major full installation

Requires: dotnet-host
Requires: dotnet-coreclr-%_dotnet_major = %_dotnet_corerelease
Requires: dotnet-corefx-%_dotnet_major = %_dotnet_corerelease
Requires: dotnet-hostfxr-%_dotnet_major = %EVR
#Requires: dotnet-apphost-pack-%_dotnet_major = %EVR

%description -n dotnet-%_dotnet_major
The .NET %_dotnet_major.

This is a virtual package to provide full installation of .NET %_dotnet_major.

.NET is a development platform that you can use to build command-line
applications, microservices and modern websites. It is open source,
cross-platform and is supported by Microsoft. We hope you enjoy using it!
If you do, please consider joining the active community of developers that are
contributing to the project on GitHub (https://github.com/dotnet/core).


%prep
%setup
# since glibc 2.26 xlocale.h is removed
%__subst "s|xlocale.h|locale.h|" src/corehost/cli/json/casablanca/include/cpprest/asyncrt_utils.h

# drop -Werror from production build
%__subst "s|.*-Werror.*||" src/settings.cmake

# set global runtime location
%__subst "s|/usr/share/dotnet|%_dotnetdir|" src/corehost/common/pal.unix.cpp

find -type f -name "*.sh" | xargs subst "s|/etc/os-release|%_dotnetdir/fake-os-release|g"

%build
cd src/corehost
sh -x ./build.sh \
    --arch %_dotnet_arch \
    --hostver %_dotnet_corerelease \
    --apphostver %_dotnet_corerelease \
    --fxrver %_dotnet_corerelease \
    --policyver %_dotnet_corerelease \
    -portable \
    --commithash 0

%install
mkdir -p %buildroot%_dotnetdir/
#install -m755 %exedir/dotnet %buildroot%_dotnetdir/

mkdir -p %buildroot%_dotnet_shared/
install -m755 %exedir/libhostpolicy.so %buildroot%_dotnet_shared/

mkdir -p %buildroot%_dotnet_hostfxr/
install -m755 %exedir/libhostfxr.so %buildroot%_dotnet_hostfxr/

mkdir -p %buildroot%_dotnet_apphostdir/runtimes/%_dotnet_rid/native/
install -m755 %exedir/apphost %buildroot%_dotnet_apphostdir/runtimes/%_dotnet_rid/native/
install -m644 %exedir/libnethost.so %buildroot%_dotnet_apphostdir/runtimes/%_dotnet_rid/native/
install -m644 %exedir/nethost.h %buildroot%_dotnet_apphostdir/runtimes/%_dotnet_rid/native/
install -m644 %exedir/nethost.h %buildroot%_dotnet_shared/

#mkdir -p %buildroot%_bindir/
#ln -sr %buildroot%_dotnetdir/dotnet %buildroot%_bindir/dotnet

%files
%doc THIRD-PARTY-NOTICES.TXT README.md CONTRIBUTING.md LICENSE.TXT
%dir %_dotnet_hostfxr/
%_dotnet_hostfxr/libhostfxr.so
%dir %_dotnet_shared/
%_dotnet_shared/libhostpolicy.so

# some duplicate
%_dotnet_shared/nethost.h

%dir %_dotnetdir/packs/Microsoft.NETCore.App.Host.%_dotnet_rid/
%dir %_dotnet_apphostdir/
%dir %_dotnet_apphostdir/runtimes/
%dir %_dotnet_apphostdir/runtimes/%_dotnet_rid/
%dir %_dotnet_apphostdir/runtimes/%_dotnet_rid/native/
%_dotnet_apphostdir/runtimes/%_dotnet_rid/native/apphost
%_dotnet_apphostdir/runtimes/%_dotnet_rid/native/libnethost.so
%_dotnet_apphostdir/runtimes/%_dotnet_rid/native/nethost.h

%files -n dotnet-%_dotnet_major

%changelog
