%define dune_pkg configurator
%if "%dune_pkg" != "bootstrap"
%define subpackagename -%dune_pkg
%def_with subpackage
%def_without check
%else
%define subpackagename %nil
%def_without subpackage
%def_with check
%endif

Name: dune%subpackagename
Version: 2.9.1
Release: alt1
Summary: A composable build system for OCaml
Group: Development/ML
License: MIT
Url: https://github.com/ocaml/dune
Source0: dune-%version.tar
Patch0: dune-%version-%release.patch
Provides: ocaml-dune = %EVR

BuildRequires: ocaml >= 4.08.0
BuildRequires: ocaml-findlib-devel
BuildRequires: opam
%if_with subpackage
BuildRequires: dune
BuildRequires: ocaml-csexp-devel
%endif

%description
Dune is a build system designed for OCaml/Reason projects only. It focuses
on providing the user with a consistent experience and takes care of most of
the low-level details of OCaml compilation. All you have to do is provide a
description of your project and Dune will do the rest.

The scheme it implements is inspired from the one used inside Jane Street and
adapted to the open source world. It has matured over a long time and is used
daily by hundred of developers, which means that it is highly tested and
productive.

%if "%dune_pkg" == "configurator"
%package -n ocaml-%name
Group: Development/ML
Summary: Helper dune library for gathering system configuration
Requires: ocaml-result-devel
Requires: dune = %EVR
%description -n ocaml-%name
dune-configurator is a small library that helps writing OCaml scripts that
test features available on the system, in order to generate config.h
files for instance.
Among other things, dune-configurator allows one to:
- test if a C program compiles
- query pkg-config
- import #define from OCaml header files
- generate config.h file
%endif

%if "%dune_pkg" == "private-libs"
%package -n ocaml-%name
Group: Development/ML
Summary: Runtime files for %name
Requires: dune = %EVR
%description -n ocaml-%name
This package contains code that is shared between various dune-xxx
packages. However, it is not meant for public consumption and provides
no stability guarantee.
%endif

%if_with subpackage
%package -n ocaml-%name-devel
Summary: Development files for %name
Group: Development/ML
Requires: ocaml-result-devel
Requires: ocaml-%name = %EVR
%description -n ocaml-%name-devel
The %name-devel package contains libraries and signature files for
developing applications that use %name.
%endif

%prep
%setup -n dune-%version
%patch0 -p1

%build
sed -i '/^(name/a (version %version)' dune-project
./configure --libdir=%_libdir/ocaml \
	    --mandir=%_mandir  \
	    --etcdir %_sysconfdir \
	    --docdir %_docdir

%if_without subpackage
%make_build release
%else
%dune_build -p %name
%endif

%install
%if_with subpackage
%dune_install %name
%else
./dune.exe install --destdir=%buildroot dune
%endif

%check
./dune.exe runtest test/unit-tests

%if_without subpackage
%files
%doc README.md CHANGES.md
%_ocamldir/dune/META
%_ocamldir/dune/dune-package
%_ocamldir/dune/opam
%_bindir/dune
%_man1dir/dune.1*
%_man1dir/dune-describe.1*
%_man1dir/dune-help.1*
%_man1dir/dune-printenv.1*
%_man1dir/dune-promote.1*
%_man1dir/dune-build.1*
%_man1dir/dune-cache.1*
%_man1dir/dune-clean.1*
%_man1dir/dune-compute.1.*
%_man1dir/dune-format-dune-file.1.*
%_man1dir/dune-upgrade.1.*
%_man1dir/dune-exec.1*
%_man1dir/dune-external-lib-deps.1*
%_man1dir/dune-install.1*
%_man1dir/dune-init.1*
%_man1dir/dune-installed-libraries.1*
%_man1dir/dune-ocaml-merlin.1*
%_man1dir/dune-rules.1*
%_man1dir/dune-runtest.1*
%_man1dir/dune-subst.1*
%_man1dir/dune-test.1*
%_man1dir/dune-top.1*
%_man1dir/dune-uninstall.1*
%_man1dir/dune-utop.1*
%_man5dir/dune-config.5*
%_man1dir/dune-compute.1.*
%_man1dir/dune-format-dune-file.1.*
%_man1dir/dune-upgrade.1.*
%endif

%if "%dune_pkg" == "private-libs"
%files -n ocaml-%name -f ocaml-files.runtime
%_ocamldir/stublibs/dllstdune_stubs.so
%endif

%if "%dune_pkg" == "configurator"
%files -n ocaml-%name -f ocaml-files.runtime
%endif

%if_with subpackage
%files -n ocaml-%name-devel -f ocaml-files.devel
%endif

%changelog
