%define TOOL_CHAIN_TAG GCC5
%define openssl_ver 1.1.1m

# More subpackages to come once licensing issues are fixed
Name: edk2-aarch64
Version: 20220221
Release: alt1
Summary: AARCH64 Virtual Machine Firmware

License: BSD-2-Clause-Patent
Group: Emulators
Url: http://www.tianocore.org

#Vcs-Git: https://github.com/tianocore/edk2.git
Source: %name-%version.tar
#Vcs-Git: https://github.com/openssl/openssl
Source2: openssl.tar
#Vcs-Git: https://github.com/ucb-bar/berkeley-softfloat-3.git
Source3: berkeley-softfloat-3.tar
Source4: Logo.bmp

# ALT-specific JSON "descriptor files"
Source20: 70-edk2-aarch64-verbose.json
Source21: 60-edk2-aarch64.json

Patch1: %name-%version.patch

ExclusiveArch: aarch64
BuildArch: noarch

Provides: edk2-ovmf-aarch64 = %EVR

BuildRequires(pre): rpm-build-python3
BuildRequires: iasl nasm gcc-c++
BuildRequires: python3-devel python3-modules-sqlite3
BuildRequires: libuuid-devel
BuildRequires: bc

Requires: ipxe-roms-qemu

%description
EFI Development Kit II
AARCH64 UEFI Firmware

%prep
%setup -q
%patch1 -p1

cp -f %SOURCE4 MdeModulePkg/Logo/

# cleanup
find . -name '*.efi' -print0 | xargs -0 rm -f
rm -rf BaseTools/Bin \
        UefiCpuPkg/ResetVector/Vtf0/Bin/*.raw \
        EdkCompatibilityPkg/Other \
        AppPkg \
        DuetPkg/BootSector/bin \
        StdLib/LibC/Main/Ia32/ftol2.obj \
        BeagleBoardPkg/Debugger_scripts/rvi_dummy.axf \
        BaseTools/Source/Python/*/*.pyd \
        BaseTools/Source/Python/UPT/Dll/sqlite3.dll \
        Vlv2TbltDevicePkg/GenBiosId \
        Vlv2TbltDevicePkg/*.exe \
        ArmPkg/Library/GccLto/liblto-*.a

# Ensure old shell and binary packages are not used
rm -rf EdkShellBinPkg
rm -rf EdkShellPkg
rm -rf FatBinPkg
rm -rf ShellBinPkg

# add openssl
mkdir -p CryptoPkg/Library/OpensslLib/openssl
tar -xf %SOURCE2 --strip-components 1 --directory CryptoPkg/Library/OpensslLib/openssl

# add berkeley-softfloat-3
mkdir -p ArmPkg/Library/ArmSoftFloatLib/berkeley-softfloat-3
tar -xf %SOURCE3 --strip-components 1 --directory ArmPkg/Library/ArmSoftFloatLib/berkeley-softfloat-3

%build

source ./edksetup.sh

# compiler
CC_FLAGS="-t %TOOL_CHAIN_TAG"

# common features
#CC_FLAGS="${CC_FLAGS} --cmd-len=65536 -b DEBUG --hash"
#CC_FLAGS="${CC_FLAGS} -b RELEASE"
CC_FLAGS="${CC_FLAGS} -b DEBUG --hash"
CC_FLAGS="${CC_FLAGS} --cmd-len=65536"
CC_FLAGS="${CC_FLAGS} -D NETWORK_IP6_ENABLE"
CC_FLAGS="${CC_FLAGS} -D NETWORK_TLS_ENABLE"
CC_FLAGS="${CC_FLAGS} -D NETWORK_HTTP_BOOT_ENABLE"
CC_FLAGS="${CC_FLAGS} -D TPM_ENABLE"

# ovmf features
OVMF_FLAGS="${CC_FLAGS}"
OVMF_FLAGS="${OVMF_FLAGS} -D FD_SIZE_2MB"

# ovmf + secure boot features
OVMF_SB_FLAGS="${OVMF_FLAGS}"
OVMF_SB_FLAGS="${OVMF_SB_FLAGS} -D SECURE_BOOT_ENABLE"
OVMF_SB_FLAGS="${OVMF_SB_FLAGS} -D SMM_REQUIRE"
OVMF_SB_FLAGS="${OVMF_SB_FLAGS} -D EXCLUDE_SHELL_FROM_FD"

# arm firmware features
#ARM_FLAGS="-t %TOOL_CHAIN_TAG -b DEBUG --cmd-len=65536"
ARM_FLAGS="${CC_FLAGS}"


unset MAKEFLAGS

# prepare
#cp /usr/share/seabios/bios-csm.bin OvmfPkg/Csm/Csm16/Csm16.bin
#cp /usr/share/seabios/bios-csm.bin corebootPkg/Csm/Csm16/Csm16.bin
%make_build \
        -C BaseTools

#(cd UefiCpuPkg/ResetVector/Vtf0; python Build.py)

#mkdir -p FatBinPkg/EnhancedFatDxe/{X64,Ia32}
#source ./edksetup.sh


# build aarch64 firmware
mkdir -p AAVMF
gcc -c -fpic ArmPkg/Library/GccLto/liblto-aarch64.s -o ArmPkg/Library/GccLto/liblto-aarch64.a

# Build with a verbose debug mask first, and stash the binary.
build ${ARM_FLAGS} -a AARCH64 -p ArmVirtPkg/ArmVirtQemu.dsc -D DEBUG_PRINT_ERROR_LEVEL=0x8040004F
cp -a Build/ArmVirtQemu-AARCH64/*/FV/QEMU_EFI.fd AAVMF/QEMU_EFI.verbose.fd
cp -a Build/ArmVirtQemu-AARCH64/*/FV/QEMU_VARS.fd AAVMF/QEMU_VARS.fd

# Rebuild with a silent (errors only) debug mask.
build ${ARM_FLAGS} -a AARCH64 -p ArmVirtPkg/ArmVirtQemu.dsc -D DEBUG_PRINT_ERROR_LEVEL=0x80000000
cp -a Build/ArmVirtQemu-AARCH64/*/FV/QEMU_EFI.fd AAVMF/QEMU_EFI.fd


%install
# For distro-provided firmware packages, the specification
# (https://git.qemu.org/?p=qemu.git;a=blob;f=docs/interop/firmware.json)
# says the JSON "descriptor files" to be searched in this directory:
# `/usr/share/firmware/`.  Create it.

mkdir -p %buildroot%_datadir/qemu/firmware
mkdir -p %buildroot%_datadir/{edk2,AAVMF}

cat AAVMF/QEMU_EFI.verbose.fd /dev/zero | head -c 64m \
  > %buildroot%_datadir/AAVMF/AAVMF_CODE.verbose.fd

cat AAVMF/QEMU_EFI.fd /dev/zero | head -c 64m \
  > %buildroot%_datadir/AAVMF/AAVMF_CODE.fd

cat AAVMF/QEMU_VARS.fd /dev/zero | head -c 64m \
  > %buildroot%_datadir/AAVMF/AAVMF_VARS.fd


ln -r -s %buildroot%_datadir/AAVMF %buildroot%_datadir/edk2/aarch64

for f in %_sourcedir/*edk2-aarch64*.json; do
    install -pm 644 $f %buildroot%_datadir/qemu/firmware
done

# add symlinks for compat
ln -r -s %buildroot%_datadir/AAVMF/AAVMF_CODE.verbose.fd %buildroot%_datadir/edk2/aarch64/QEMU_EFI-pflash.raw
ln -r -s %buildroot%_datadir/AAVMF/AAVMF_CODE.fd %buildroot%_datadir/edk2/aarch64/QEMU_EFI-silent-pflash.raw
ln -r -s %buildroot%_datadir/AAVMF/AAVMF_VARS.fd %buildroot%_datadir/edk2/aarch64/vars-template-pflash.raw

%files
%_datadir/AAVMF
%_datadir/edk2/aarch64
%_datadir/qemu/firmware/*edk2-aarch64*.json

%changelog
