%define oname eigen
Name: %{oname}3
Version: 3.3.9
Release: alt2

Summary: C++ template library for linear algebra
License: LGPLv3+ or GPLv2+
Group: Development/C++

Url: http://eigen.tuxfamily.org/
Source: %name-%version.tar
Packager: Andrey Cherepanov <cas@altlinux.org>

# Install FindEigen3.cmake
# Fix pkg-config file
Patch1:         eigen_pkgconfig.patch
# Fix the include paths in the new Eigen3Config.cmake file
Patch2:         eigen3-3.3.1-fixcmake.patch
# Avoid SSE4.2/AVX on e2k
Patch3:		eigen3-3.3.7-alt-e2k.patch

BuildRequires(pre): cmake
BuildRequires(pre): rpm-build-ninja
%ifnarch %e2k
BuildRequires: libsuitesparse-devel libscotch-devel libgoogle-sparsehash
%endif
BuildRequires: gcc-c++ doxygen
BuildRequires: libsuperlu-devel libmpfr-devel libgmp-devel
BuildRequires: libfftw3-devel libGLU-devel libgsl-devel gcc-fortran
BuildRequires: liblapack-devel libglew-devel libGLUT-devel libXi-devel
BuildRequires: libXmu-devel libmetis-devel libXres-devel
BuildRequires: libXcomposite-devel libXdamage-devel libXdmcp-devel
BuildRequires: libXft-devel libxkbfile-devel libXpm-devel
BuildRequires: libXScrnSaver-devel libXxf86misc-devel libXxf86vm-devel
BuildRequires: boost-devel

# TODO: add devel subpackage and move stuff
Provides: %{name}-devel = %EVR
Provides: %{oname}-devel = %EVR

%description
Eigen is a C++ template library for linear algebra: matrices, vectors,
numerical solvers, and related algorithms.

%package docs
Summary: Documentation for Eigen3
Group: Development/Documentation
BuildArch: noarch
#BuildArch: noarch

%description docs
Eigen is a C++ template library for linear algebra: matrices, vectors,
numerical solvers, and related algorithms.

This package contains development documentation for Eigen.

%package examples
Summary: Examples for Eigen3
Group: Development/Documentation

%description examples
Eigen is a C++ template library for linear algebra: matrices, vectors,
numerical solvers, and related algorithms.

This package contains examples for Eigen.

%prep
%setup
%patch1 -p1
%patch2 -p0 -b .fixcmake
%ifarch %e2k
%patch3 -p2 -b .e2k
%endif

%build
export PATH=$PATH:%_libdir/pastix/bin

%cmake -GNinja \
	-Wno-dev \
	-DINCLUDE_INSTALL_DIR=include/%name \
	-DPKGCONFIG_INSTALL_DIR=%_lib/pkgconfig \
	-DCMAKEPACKAGE_INSTALL_DIR=%_lib/cmake/%name \
	-DOpenGL_GL_PREFERENCE=GLVND \
%ifarch %e2k
	-DEIGEN_TEST_AVX512=OFF \
	-DEIGEN_TEST_AVX=OFF \
	-DEIGEN_TEST_SSE4_2=OFF \
%else
	-DCHOLMOD_INCLUDES=%_includedir/suitesparse \
	-DUMFPACK_INCLUDES=%_includedir/suitesparse \
%endif
	-DEIGEN_TEST_NOQT=ON \
	-DSUPERLU_LIBRARIES=-lsuperlu_4.0 \
	-DCMAKE_STRIP="/bin/echo" \
	-DGOOGLEHASH_INCLUDES="%_includedir/google" \
	-DGOOGLEHASH_COMPILE="g++ %optflags" \
	-DMETIS_INCLUDE_DIRS=%_includedir/metis

%cmake_build
%ifnarch %e2k
%cmake_build -t doc
%endif

%install
%cmake_install

install -d %buildroot%_bindir
%ifnarch %e2k
cd %_cmake__builddir
rm -fR doc/examples/CMakeFiles doc/examples/*.out \
	doc/examples/*.cmake
install -m755 doc/examples/* %buildroot%_bindir
cd -
%endif

%files
%_includedir/*
%_pkgconfigdir/*
%_libdir/cmake/%name

%ifnarch %e2k
%files examples
%_bindir/*
%doc doc/examples/*

%files docs
%doc %_cmake__builddir/doc/html/*
%endif

%changelog
