Name: eiskaltdcpp
Version: 2.4.2.0.21.git918a6cd
Release: alt1

Summary: EiskaltDC++ - Direct Connect client

License: GPLv3
Group: Networking/File transfer
Url: https://sourceforge.net/projects/eiskaltdcpp

Source: %name-%version.tar

BuildRequires: bzlib-devel cmake gcc-c++
BuildRequires: libaspell-devel libgtk+2-devel libidn2-devel liblua-devel
BuildRequires: libnotify-devel libpcrecpp-devel qt5-phonon-devel
BuildRequires: qt5-tools-devel qt5-multimedia-devel qt5-script-devel
BuildRequires: libssl-devel perl-JSON-RPC perl-Term-ShellUI libminiupnpc-devel

# ALT39859
%filter_from_requires /^.usr.bin.php$/d

%description
EiskaltDC++ is a cross-platform program that uses the Direct Connect and
Advanced Direct Connect (ADC) protocols. It is compatible with DC++,
AirDC++, FlylinkDC++ and other DC clients. EiskaltDC++ also interoperates
with all common DC hub software.

%package common
Group: Networking/File transfer
Summary: Common files for %name
Requires: lib%name = %EVR
BuildArch: noarch
%description common
Common files for %name

%package gtk
Group: Networking/File transfer
Summary: GTK-based graphical interface
Requires: %name-gtk-data = %EVR
%description gtk
Gtk interface based on code of FreeDC++ and LinuxDC++

%package gtk-data
Group: Networking/File transfer
Summary: noarch files for GTK-based graphical interface
Requires: %name-common = %EVR
BuildArch: noarch
%description gtk-data
noarch files for Gtk interface based on code of FreeDC++ and LinuxDC++

%package qt
Group: Networking/File transfer
Summary: Qt-based graphical interface
Provides: %name = %EVR
Obsoletes: %name <= 2.0.3-alt1
Requires: %name-qt-data = %EVR
%description qt
Qt-based graphical interface

%package qt-data
Group: Networking/File transfer
Summary: Qt-based graphical interface
Requires: %name-common = %EVR
BuildArch: noarch
%description qt-data
noarch files for Qt-based graphical interface

%package -n lib%name
Group: System/Libraries
Summary: eiskaltdcpp libraries
Obsoletes: libdcpp
%description -n lib%name
eiskaltdcpp libraries

%package daemon
Group: Networking/File transfer
Summary: Daemon interface
Requires: %name-common = %EVR
%description daemon
Daemon interface

%package cli
Group: Networking/File transfer
Summary: cli for Daemon
Requires: %name-daemon = %EVR
%description cli
command line interface for XML-RPC Daemon

%prep
%setup
%ifarch %e2k
# workaround for EDG frontend
sed -i "s|g_autofree gchar \*|g_autofree_edg_ex(gchar,std::string) |" eiskaltdcpp-gtk/src/{adlsearch,hub,mainwindow,uploadqueue}.cc
%endif

%build
%add_optflags -fno-strict-aliasing
otherflags="$(pkg-config libpcre --cflags) $(pkg-config harfbuzz --cflags)"
%cmake_insource \
-DCMAKE_BUILD_TYPE=Release \
-DCMAKE_SKIP_RPATH:BOOL=yes \
-DCMAKE_C_FLAGS:STRING="%optflags $otherflags" \
-DCMAKE_CXX_FLAGS:STRING="%optflags $otherflags" \
-DCMAKE_INSTALL_PREFIX=%prefix \
-DLIB_DESTINATION=%_lib \
%if %_lib == lib64
-DLIBDIR=lib64 \
%endif
-DUSE_ASPELL=ON \
-DFREE_SPACE_BAR_C=ON \
-DUSE_MINIUPNP=ON \
-DLOCAL_MINIUPNP=ON \
-DUSE_GTK=ON \
-DDBUS_NOTIFY=ON \
-DUSE_JS=ON \
-DLUA_SCRIPT=ON \
-DWITH_LUASCRIPTS=ON \
-DWITH_SOUNDS=ON \
-DUSE_QT_SQLITE=ON \
-DNO_UI_DAEMON=ON \
-DJSONRPC_DAEMON=ON \
-DUSE_CLI_JSONRPC=ON \
-DPCRE_INCLUDE_DIR=$(pkg-config libpcre --variable=includedir) \
-DPERL_REGEX=ON \
-DUSE_QT=OFF \
-DUSE_QT5=ON \
-DUSE_IDN2=ON
%make_build

%install
%makeinstall_std
%find_lang %name-gtk
%find_lang lib%name

%files qt
%_bindir/%name-qt

%files qt-data
%_desktopdir/%name-qt.desktop
%_datadir/%name/qt
%_man1dir/%name-qt*

%files gtk
%_bindir/%name-gtk

%files gtk-data -f %name-gtk.lang
%_desktopdir/%name-gtk.desktop
%_datadir/%name/gtk
%_man1dir/%name-gtk*

%files -n lib%name -f lib%name.lang
%_libdir/lib%name.so.*

%files common
%_datadir/%name/emoticons
%_datadir/%name/examples
%_datadir/%name/sounds
%_datadir/%name/luascripts
%_miconsdir/%name.png
%_niconsdir/%name.png
%_liconsdir/%name.png
%_iconsdir/hicolor/128x128/apps/%name.png
%_iconsdir/hicolor/64x64/apps/%name.png
%_iconsdir/hicolor/24x24/apps/%name.png
%_iconsdir/hicolor/22x22/apps/%name.png
%_pixmapsdir/*

%files daemon
%_bindir/%name-daemon
%_man1dir/%name-daemon*

%files cli
%_bindir/%name-cli-jsonrpc
%_man1dir/%name-cli*
%_datadir/%name/cli

%changelog
