# -*- coding: utf-8; mode: rpm-spec -*-

%set_compress_method skip

%define emacs_version 26.3
%define erc_version %emacs_version

%define gnus_version 5.13
%define shortname emacs
%define tramp_version 2.3.5.26.3
%define speedbar_version 1.0
%define nxml_version 0.2.20041004
%define cedet_version 2.0

# subpackages to build;
%def_enable nox
%def_enable athena
%def_enable gtk
%def_enable gtk3
%def_enable motif

Name: emacs26
Version: 26.3
Release: alt13

Group: Editors
Summary: GNU Emacs text editor
License: GPLv3+

URL: http://www.gnu.org/software/emacs/

Packager: Emacs Maintainers Team <emacs@packages.altlinux.org>

Source0: %shortname-%emacs_version.tar

Source7: README.KOI8-U

# from Serhij Hlodin
Source16: CHANGES.ukr
Source17: INSTALL.ukr
Source18: README.UK

Source24: %name-nox.alternatives
Source25: %name-athena.alternatives
Source26: %name-motif.alternatives
Source27: %name-gtk.alternatives
Source28: %name-gtk3.alternatives

# Mdk's and ALT's global configs merged: the X resources
Source31: %shortname-22.0.91-alt0.19-xresources-ALT

# List of some large .elc files to be compressed:
#Source40: %shortname-21.2-el-to-compress.ls

Source41: emacs21-rus-win-keyboard-alt2.el

Source50: README.ALT-ru_RU.KOI8-R
Source51: check-shadows

Source60: %name.desktop

Source70: configure-lispintro
Source71: configure-lispref

# We use awk for output parsing and error-msg detection:
BuildRequires(build): awk
# We use zme:
BuildRequires(install): bzip2-utils
# <term.h> is there since then:
BuildRequires(build): libtinfo >= 5.2.20020622-alt2
# Emacs now requires Texinfo version 4.2.
BuildRequires(build): texinfo >= 4.2

# %_configure_target must set --host= for a correct emacs build;
# added since then:
BuildRequires(build): rpm >= 4.0.4-alt12

# We need sendmail to properly dump emacs during bootstrap
BuildRequires(build): sendmail-common

# We need emacs-base
BuildPreReq: %shortname-base >= 0.0.5-alt2

# BuildPreReq: python-base python-modules-compiler python-modules-encodings rpm-build-python

# Now el-pkgutils in emacs-devel
BuildPreReq: %shortname-devel
# All emacs pkgs should be removed from the list.

# BuildPreReq: tetex-core tetex-latex

# Build gtk binary with sound
BuildRequires(build): libalsa-devel

# Requires for UI build
BuildRequires(build): libtinfo-devel
# athena
%if_enabled athena
BuildRequires(build): libXaw3d-devel libXaw-devel
%endif
# motif
%if_enabled motif
BuildRequires(build): openmotif-devel
%endif
# gtk
%if_enabled gtk
BuildRequires(build): libgtk+2-devel
%endif
# gtk3
%if_enabled gtk3
BuildRequires(build): libgtk+3-devel
%endif

# Xft support
BuildRequires(build): libXft-devel

# Mouse support in console
BuildRequires(build): libgpm-devel

# Requires for graphics support
BuildRequires(build): libjpeg-devel
BuildRequires(build): libpng-devel
BuildRequires(build): libtiff-devel
BuildRequires(build): libgif-devel
BuildRequires(build): libXpm-devel
BuildRequires(build): librsvg-devel
BuildRequires(build): libImageMagick-devel

# GnuTLS support
BuildRequires(build): libgnutls-devel

# libxml2 support
BuildRequires(build): libxml2-devel

# SELinux support
BuildRequires(build): libselinux-devel

# Requires for D-bus support in X builds
BuildRequires(build): libdbus-devel

# for update_desktopdb
# Requires(post,postun): desktop-file-utils
# BuildPreReq: desktop-file-utils

# ACL support (24.4):
BuildRequires: libacl-devel

# Notify support (24.4):
BuildRequires: inotify-tools-devel

# Zlib support (24.4):
BuildRequires: zlib-devel

# lcms2 support (26.1):
BuildRequires: liblcms2-devel

# Strange build deps:
#BuildRequires: postfix, w3m

# Automatically added by buildreq on Thu Apr 02 2009
BuildRequires: imake libXext-devel libXmu-devel libXp-devel libXpm-devel tzdata xorg-cf-files

%description
Emacs is an extensible, customizable, self-documenting real-time
display editor.  Emacs contains special code editing features, an
extension language (Emacs Lisp), and the capability to read mail, news
and more without leaving the editor.

This package includes things you need to run the Emacs editor, so you
need to install this package if you intend to use Emacs.  You also
need to install the actual Emacs program package (%name-nox or
%name-X11).  Install %name-nox if you are not going to use the X
Window System; install %name-X11 if you will be using X.

#
%package common
Summary: Things needed to run the GNU Emacs text editor
Summary(ru_RU.UTF-8): Необходимое для запуска текстового редактора GNU Emacs
Group: Editors
Provides: %_libexecdir/%shortname
Obsoletes: %name
Obsoletes: %shortname-common
Provides: %shortname-common = %emacs_version-%release
# emacs26 obsoletes emacs21, emacs22, emacs23, emacs24 and emacs25
Obsoletes: emacs21-common
Obsoletes: emacs22-common
Obsoletes: emacs23-common
Obsoletes: emacs24-common
Obsoletes: emacs25-common
# Common is useless without an Emacs binary:
Requires: %name = %emacs_version-%release
# speedbar now separate package
Requires: %shortname-speedbar
# tramp now separate package
Requires: %shortname-tramp

Requires: %shortname-base >= 0.0.5-alt2

Requires: %name-gnus = %gnus_version-%release

Conflicts: etcskel < 2.0.2-alt1
Conflicts: emacs-prog-modes < 0.1-alt7
# ispell-uk 0.5 is broken, and can cause hang in flyspell mode
Conflicts: ispell-uk < 0.6-alt1
# emacs26 have ses inside
Obsoletes: %shortname-ses <= 1.0-alt2.031130
Provides: %shortname-ses = %emacs_version-%release
# emacs26 conflicts with old emacs-w3 (with url package inside)
Conflicts: %shortname-w3 <= 4.0-alt0.8.pre.47
Provides: %shortname-url = %emacs_version-%release
# gnuserv seems needed to be build with emacs26
Conflicts: %shortname-gnuserv <= 3.12.7-alt1

# otherwise we have heavy useless dependency on python
AutoReq: yes, nopython

%description common
GNU Emacs is an extensible, customizable, self-documenting real-time
display editor.  Emacs contains special code editing features, an
extension language (Emacs Lisp), and the capability to read mail, news
and more without leaving the editor.

This package includes things you need to run the Emacs editor, so you
need to install this package if you intend to use Emacs.  You also
need to install the actual Emacs program package (%name-nox or
%name-X11).  Install %name-nox if you are not going to use the X
Window System; install %name-X11 if you will be using X.

#
%package el
Summary: The sources for Lisp programs included with GNU Emacs
Summary(ru_RU.UTF-8): Исходный код Lisp программ, поставляемых с GNU Emacs
Group: Development/Other
BuildArch: noarch
Requires: %name-common = %emacs_version-%release
Requires: %name-gnus-el = %gnus_version-%release
Obsoletes: %shortname-el
Provides: %shortname-el = %emacs_version-%release
# emacs26 obsoletes emacs21, emacs22, emacs23, emacs24 and emacs25
Obsoletes: emacs21-el
Obsoletes: emacs22-el
Obsoletes: emacs23-el
Obsoletes: emacs24-el
Obsoletes: emacs25-el

%description el
Emacs-el contains the Emacs Lisp sources for many of the programs
included with the main GNU Emacs text editor package.

You need to install %name-el only if you intend to modify any of the
Emacs packages or see some Lisp examples.

If you need the sources for %name-leim, install %name-leim-el.

#
%package leim
Summary: GNU Emacs Lisp code for input methods for internationalization
Summary(ru_RU.UTF-8): Код GNU Emacs Lisp для методов ввода
Group: Editors
BuildArch: noarch
Requires: %name-common = %emacs_version-%release
Obsoletes: %shortname-leim
Provides: %shortname-leim = %emacs_version-%release
# emacs26 obsoletes emacs21, emacs22, emacs23, emacs25 and emacs25
Obsoletes: emacs21-leim
Obsoletes: emacs22-leim
Obsoletes: emacs23-leim
Obsoletes: emacs24-leim
Obsoletes: emacs25-leim

%description leim
The Lisp code for input methods for various international scripts for GNU Emacs.

#
%package leim-el
Summary: The Emacs Lisp source code for input methods included in %name-leim
Summary(ru_RU.UTF-8): Исходный код Lisp для методов ввода, поставляемых с %name-leim
Group: Development/Other
BuildArch: noarch
Requires: %name-leim = %emacs_version-%release
Obsoletes: %shortname-leim-el
Provides: %shortname-leim-el = %emacs_version-%release
# emacs26 obsoletes emacs21, emacs22, emacs23, emacs25 and emacs26
Obsoletes: emacs21-leim-el
Obsoletes: emacs22-leim-el
Obsoletes: emacs23-leim-el
Obsoletes: emacs24-leim-el
Obsoletes: emacs25-leim-el

%description leim-el
Emacs-leim-el contains the Emacs Lisp sources for the Emacs Lisp code
for input methods for various international scripts of GNU Emacs.

You need to install %name-leim-el only if you intend to modify any of theses
GNU Emacs packages, see some Lisp examples or for reference for configuring your
localized input methods.

#
%if_enabled nox
%package nox
Summary: The GNU Emacs text editor without support for the X Window System
Summary(ru_RU.UTF-8): Текстовый редактор GNU Emacs без поддержки X Window System
Group: Editors
PreReq: %name-common = %emacs_version-%release
Provides: %name = %emacs_version-%release
Provides: emacsen
Provides: %shortname = %emacs_version-%release
Obsoletes: %shortname-nox
Provides: %shortname-nox = %emacs_version-%release
# emacs26 obsoletes emacs21, emacs22, emacs23, emacs24 and emacs25
Obsoletes: emacs21-nox
Obsoletes: emacs22-nox
Obsoletes: emacs23-nox
Obsoletes: emacs24-nox
Obsoletes: emacs25-nox

# 0.2.0 for new alternatives format
PreReq: alternatives >= 0.2.0
Provides: /usr/bin/emacs

%description nox
Emacs-nox is the GNU Emacs text editor program without support for
the X Window System.

You need to install this package only if you plan on exclusively using
GNU Emacs without the X Window System (%name-X11-athena, %name-X11-motif, 
%name-X11-gtk will work both in X and out of X, but %name-nox will only work 
outside of X). You will also need to install the %name-common package in
order to run GNU Emacs.
%endif

#
%package X11
Summary: Things needed to run the GNU Emacs text editor in X Window System
Summary(ru_RU.UTF-8): Необходимое для запуска редактора GNU Emacs в X Window System
Group: Editors
BuildArch: noarch
PreReq: %name-common = %emacs_version-%release
Requires: emacs-X11-program
# common version independent resources for X11
Requires: emacs-base-X11
Conflicts: app-defaults < 0.2.1-alt1
# emacs26 obsoletes emacs21, emacs22, emacs23, emacs24 and emacs25
Obsoletes: %shortname-X11
Obsoletes: emacs22-X11
Obsoletes: emacs23-X11
Obsoletes: emacs24-X11
Obsoletes: emacs25-X11

%description X11
This package includes things you need to run the Emacs editor in X Window
System, so you need to install this package if you intend to use Emacs with X
Window.  You also need to install the actual Emacs program package
(%name-X11-athena, %name-X11-motif or %name-X11-gtk). You will also need to
install the %name-common package in order to run GNU Emacs.

#
%if_enabled athena
%package X11-athena
Summary: The GNU Emacs text editor for the X Window System (athena)
Summary(ru_RU.UTF-8): Текстовый редактор GNU Emacs для X Window System (athena)
Group: Editors
PreReq: %name-common = %emacs_version-%release
PreReq: %name-X11 = %emacs_version-%release
Provides: %name = %emacs_version-%release
Provides: emacsen
Provides: emacs-X11-program
Provides: %shortname = %emacs_version-%release
Provides: %shortname-X11 = %emacs_version-%release
# emacs26 obsoletes emacs21, emacs22, emacs23, emacs24 and emacs25
Obsoletes: emacs21-X11
Obsoletes: emacs22-X11-athena
Obsoletes: emacs23-X11-athena
Obsoletes: emacs24-X11-athena
Obsoletes: emacs25-X11-athena

# 0.2.0 for new alternatives format
PreReq: alternatives >= 0.2.0
Provides: /usr/bin/emacs

%description X11-athena
Emacs-X11-athena includes the GNU Emacs text editor program for use with the X
Window System using athena widget set (it provides support for the mouse and
other GUI elements).  Emacs-X11-athena will also run GNU Emacs outside of X,
but it has a larger memory footprint than the 'non-X' GNU Emacs package
(%name-nox).

Install %name-X11-athena if you are going to use Emacs with the X Window
System and you like athena look.  You should also install %name-X11-athena if
you are going to run GNU Emacs both with and without X (it will work fine both
ways).  You will also need to install the %name-common and %name-X11 package
in order to run Emacs.
%endif

#
%if_enabled motif
%package X11-motif
Summary: The GNU Emacs text editor for the X Window System (motif)
Summary(ru_RU.UTF-8): Текстовый редактор GNU Emacs для X Window System (motif)
Group: Editors
PreReq: %name-common = %emacs_version-%release
PreReq: %name-X11 = %emacs_version-%release
Provides: %name = %emacs_version-%release
Provides: emacsen
Provides: emacs-X11-program
Provides: %shortname = %emacs_version-%release
Provides: %shortname-X11 = %emacs_version-%release
# 0.2.0 for new alternatives format
PreReq: alternatives >= 0.2.0
Provides: /usr/bin/emacs
# emacs26 obsoletes emacs21, emacs22, emacs23, emacs24 and emacs25
Obsoletes: emacs22-X11-motif
Obsoletes: emacs23-X11-motif
Obsoletes: emacs24-X11-motif
Obsoletes: emacs25-X11-motif

%description X11-motif
Emacs-X11-motif includes the GNU Emacs text editor program for use with the X
Window System using motif toolkit (it provides support for the mouse and
other GUI elements).  Emacs-X11-motif will also run GNU Emacs outside of X, but
it has a larger memory footprint than the 'non-X' GNU Emacs package
(%name-nox).

Install %name-X11-motif if you are going to use Emacs with the X Window
System and you like motif look.  You should also install %name-X11-motif if you
are going to run GNU Emacs both with and without X (it will work fine both
ways).  You will also need to install the %name-common and %name-X11 package in
order to run Emacs.
%endif

#
%if_enabled gtk
%package X11-gtk
Summary: The GNU Emacs text editor for the X Window System (gtk)
Summary(ru_RU.UTF-8): Текстовый редактор GNU Emacs для X Window System (gtk)
Group: Editors
PreReq: %name-common = %emacs_version-%release
PreReq: %name-X11 = %emacs_version-%release
Provides: %name = %emacs_version-%release
Provides: emacsen
Provides: emacs-X11-program
Provides: %shortname = %emacs_version-%release
Provides: %shortname-X11 = %emacs_version-%release
# 0.2.0 for new alternatives format
PreReq: alternatives >= 0.2.0
Provides: /usr/bin/emacs
# emacs26 obsoletes emacs21, emacs22, emacs23, emacs24 and emacs25
Obsoletes: emacs22-X11-gtk
Obsoletes: emacs23-X11-gtk
Obsoletes: emacs24-X11-gtk
Obsoletes: emacs25-X11-gtk

%description X11-gtk
Emacs-X11-gtk includes the GNU Emacs text editor program for use with the X
Window System using gtk+ toolkit v.2 (it provides support for the mouse and
other GUI elements).  Emacs-X11-gtk will also run GNU Emacs outside of X, but
it has a larger memory footprint than the 'non-X' GNU Emacs package
(%name-nox).

Install %name-X11-gtk if you are going to use Emacs with the X Window
System and you like gtk+ look.  You should also install %name-X11-gtk if you
are going to run GNU Emacs both with and without X (it will work fine both
ways).  You will also need to install the %name-common and %name-X11 package
in order to run Emacs.
%endif

#
%if_enabled gtk3
%package X11-gtk3
Summary: The GNU Emacs text editor for the X Window System (gtk3)
Summary(ru_RU.UTF-8): Текстовый редактор GNU Emacs для X Window System (gtk3)
Group: Editors
PreReq: %name-common = %emacs_version-%release
PreReq: %name-X11 = %emacs_version-%release
Provides: %name = %emacs_version-%release
Provides: emacsen
Provides: emacs-X11-program
Provides: %shortname = %emacs_version-%release
Provides: %shortname-X11 = %emacs_version-%release
# 0.2.0 for new alternatives format
PreReq: alternatives >= 0.2.0
Provides: /usr/bin/emacs
# emacs26 obsoletes emacs21, emacs22, emacs23, emacs24 and emacs25
Obsoletes: emacs25-X11-gtk3

%description X11-gtk3
Emacs-X11-gtk3 includes the GNU Emacs text editor program for use with the X
Window System using gtk+ toolkit v.3 (it provides support for the mouse and
other GUI elements).  Emacs-X11-gtk3 will also run GNU Emacs outside of X, but
it has a larger memory footprint than the 'non-X' GNU Emacs package
(%name-nox).

Install %name-X11-gtk3 if you are going to use Emacs with the X Window
System and you like gtk+ look.  You should also install %name-X11-gtk3 if you
are going to run GNU Emacs both with and without X (it will work fine both
ways).  You will also need to install the %name-common and %name-X11 package
in order to run Emacs.
%endif


#
%package info
Summary: Info docs for GNU Emacs text editor
Summary(ru_RU.UTF-8): Документация по GNU Emacs в формате Info
Group: Editors
BuildArch: noarch
Obsoletes: emacs22-info
Obsoletes: emacs23-info
Obsoletes: emacs24-info
Obsoletes: emacs25-info
Requires: %name-common = %emacs_version-%release

%description info
This package contain full GNU Emacs documentation in Info format except
Emacs Lisp language documentation that contains in %name-elisp-manual
package

#
%package elisp-manual
Summary: Emacs Lisp Manual
Summary(ru_RU.UTF-8): Руководство по языку Emacs Lisp
Group: Editors
BuildArch: noarch
Requires: %name-common = %emacs_version-%release
# obsoletes old elisp-manual
Obsoletes: %shortname-elisp-manual <= 2.8-alt1
Provides: %shortname-elisp-manual = %emacs_version-%release
# emacs26 obsoletes emacs21, emacs22, emacs23, emacs24 and emacs25
Obsoletes: emacs22-elisp-manual
Obsoletes: emacs23-elisp-manual
Obsoletes: emacs24-elisp-manual
Obsoletes: emacs25-elisp-manual

%description elisp-manual
This package contain full description of Emacs Lisp language

#
%package gnus
Version: %gnus_version
Summary: Gnus package for Emacs
Summary(ru_RU.UTF-8): Пакет Gnus для Emacs
Group: Editors
BuildArch: noarch
Requires: %name-common = %emacs_version-%release
Conflicts: %shortname-ngnus
Provides: gnus
# obsoletes old gnus
Obsoletes: %shortname-gnus <= 5.10.6
Provides: %shortname-gnus = %gnus_version-%release
# emacs26 obsoletes emacs21, emacs22, emacs23, emacs24 and emacs25
Obsoletes: emacs22-gnus
Obsoletes: emacs23-gnus
Obsoletes: emacs24-gnus
Obsoletes: emacs25-gnus

%description gnus
Gnus is a program for Emacs which enable read news and mail from Emacs.

All Emacs Lisp code is byte-copmpiled, install %name-gnus-el for sources.

#
%package gnus-el
Version: %gnus_version
Summary: The Emacs Lisp sources for bytecode included in %name-gnus
Summary(ru_RU.UTF-8): Исходный код Lisp для байткода из %name-gnus
Group: Development/Other
BuildArch: noarch
Requires: %name-common = %emacs_version-%release
Requires: %name-gnus = %gnus_version-%release
# obsoletes old gnus
Obsoletes: %shortname-gnus-el <= 5.10.6
Provides: %shortname-gnus-el = %gnus_version-%release
# emacs26 obsoletes emacs21, emacs22, emacs23, emacs24 and emacs25
Obsoletes: emacs22-gnus-el
Obsoletes: emacs23-gnus-el
Obsoletes: emacs24-gnus-el
Obsoletes: emacs25-gnus-el

%description gnus-el
%name-gnus-el contains the Emacs Lisp sources for the bytecode
included in the %name-gnus package, that extends the Emacs editor.

You need to install %name-gnus-el only if you intend to modify any of the
%name-gnus code or see some Lisp examples.

#
%package speedbar
Version: %speedbar_version
Summary: Speedbar package for Emacs
Group: Editors
BuildArch: noarch
Requires: %name-common = %emacs_version-%release
Provides: speedbar
Provides: %shortname-speedbar = %speedbar_version-%release
# obsoletes old speedbar
Conflicts: %shortname-cedet <= 1.0-alt0.7.beta3b
Obsoletes: %shortname-cedet-speedbar <= 0.15beta2-alt0.8.beta3b
Provides: %shortname-cedet-speedbar = %speedbar_version-%release
# emacs26 obsoletes emacs21, emacs22, emacs23, emacs24 and emacs25
Obsoletes: emacs22-speedbar
Obsoletes: emacs23-speedbar
Obsoletes: emacs24-speedbar
Obsoletes: emacs25-speedbar

%description speedbar
Speedbar - Everything browser for Emacs.

#
%package erc
Version: %erc_version
Summary: Emacs client for IRC
Summary(ru_RU.UTF-8): IRC Клиент для Emacs
Group: Networking/IRC
BuildArch: noarch
Requires: %name-common = %emacs_version-%release
Provides: %shortname-erc = %erc_version-%release
# obsoletes old emacs-erc
Obsoletes: %shortname-erc <= 5.0.4-alt1
# emacs26 obsoletes emacs21, emacs22, emacs23, emacs24 and emacs25
Obsoletes: emacs22-erc
Obsoletes: emacs23-erc
Obsoletes: emacs24-erc
Obsoletes: emacs25-erc

%description erc
ERC is an IRC client for Emacs.

#
%package erc-el
Version: %erc_version
Summary: The Emacs Lisp sources for bytecode included in %name-erc
Summary(ru_RU.UTF-8): Исходный код Lisp для байткода из %name-erc
Group: Development/Other
BuildArch: noarch
Requires: %name-common = %emacs_version-%release
Requires: %name-erc = %erc_version-%release
Obsoletes: emacs22-erc-el
Obsoletes: emacs23-erc-el
Obsoletes: emacs24-erc-el
Obsoletes: emacs25-erc-el

%description erc-el
%name-erc-el contains the Emacs Lisp sources for the bytecode
included in the %name-erc package, that extends the Emacs editor.

You need to install %name-erc-el only if you intend to modify any of the
%name-erc code or see some Lisp examples.

#
%package tramp
Version: %tramp_version
Summary: Tramp package for Emacs
Summary(ru_RU.UTF-8): Пакет Tramp для Emacs
Group: Editors
BuildArch: noarch
Requires: %name-common = %emacs_version-%release
Provides: %shortname-tramp = %tramp_version-%release
Obsoletes: %shortname-tramp < %tramp_version
# emacs26 obsoletes emacs21, emacs22, emacs23, emacs24 and emacs25
Obsoletes: emacs22-tramp
Obsoletes: emacs23-tramp
Obsoletes: emacs24-tramp
Obsoletes: emacs25-tramp

%description tramp
TRAMP stands for `Transparent Remote (file) Access, Multiple
Protocol'.  This package provides remote file editing, similar to
Ange-FTP.

The difference is that Ange-FTP uses FTP to transfer files between
the local and the remote host, whereas TRAMP uses a combination of
`rsh' and `rcp' or other work-alike programs, such as 'ssh'/'scp'.

#
%package tramp-el
Version: %tramp_version
Summary: The Emacs Lisp sources for bytecode included in %name-tramp
Summary(ru_RU.UTF-8): Исходный код Lisp для байткода из %name-tramp
Group: Development/Other
BuildArch: noarch
Requires: %name-common = %emacs_version-%release
Requires: %name-tramp = %tramp_version-%release
Obsoletes: emacs22-tramp-el
Obsoletes: emacs23-tramp-el
Obsoletes: emacs24-tramp-el
Obsoletes: emacs25-tramp-el

%description tramp-el
%name-tramp-el contains the Emacs Lisp sources for the bytecode
included in the %name-tramp package, that extends the Emacs editor.

You need to install %name-tramp-el only if you intend to modify any of the
%name-tramp code or see some Lisp examples.

#
%package nxml-mode
Version: %nxml_version
Summary: Emacs mode for editing XML
Summary(ru_RU.UTF-8): Режим Emacs для редактирования XML
Group: Editors
BuildArch: noarch
Requires: %name-common = %emacs_version-%release
Obsoletes: %shortname-nxml-mode < %nxml_version
Provides: %shortname-nxml-mode = %nxml_version-%release
Obsoletes: emacs22-nxml-mode
Obsoletes: emacs23-nxml-mode
Obsoletes: emacs24-nxml-mode
Obsoletes: emacs25-nxml-mode

%description nxml-mode
This is a new major mode for GNU Emacs for editing XML documents. It
supports editing well-formed XML documents and also provides
schema-sensitive editing of XML documents using RELAX NG Compact Syntax.

#
%package nxml-mode-el
Version: %nxml_version
Summary: The Emacs Lisp sources for bytecode included in %name-nxml-mode
Summary(ru_RU.UTF-8): Исходный код Lisp для байткода из %name-nxml-mode
Group: Development/Other
BuildArch: noarch
Requires: %name-common = %emacs_version-%release
Requires: %name-nxml-mode = %nxml_version-%release
Obsoletes: emacs22-nxml-mode-el
Obsoletes: emacs23-nxml-mode-el
Obsoletes: emacs24-nxml-mode-el
Obsoletes: emacs25-nxml-mode-el

%description nxml-mode-el
%name-nxml-mode-el contains the Emacs Lisp sources for the bytecode
included in the %name-nxml-mode package, that extends the Emacs editor.

You need to install %name-nxml-mode-el only if you intend to modify any of the
%name-nxml-mode code or see some Lisp examples.


#
%package cedet
Version: %cedet_version
Summary: CEDET - Collection of Emacs Development Enviromnent Tools
Group: Editors
BuildArch: noarch
Requires: %name-common = %emacs_version
Obsoletes: %shortname-cedet < %cedet_version-%release
Provides: %shortname-cedet = %cedet_version-%release
Obsoletes: emacs22-cedet
Obsoletes: emacs23-cedet
Obsoletes: emacs24-cedet
Obsoletes: emacs25-cedet

%description cedet
CEDET - Collection of Emacs Development Enviromnent Tools

CEDET is a top-level project containing several individual package for Emacs,
including:
   EIEIO - CLOS layer for Emacs Lisp
   Semantic - Parser Infrastructure for Emacs
   Speedbar - Everything browser
   EDE - File manager/ Makefile generator
   COGRE - Connected Graph Editor

#
%package cedet-el
Version: %cedet_version
Summary: The Emacs Lisp sources for bytecode included in %name-cedet
Summary(ru_RU.UTF-8): Исходный код Lisp для байткода из %name-cedet
Group: Development/Other
BuildArch: noarch
Requires: %name-common = %emacs_version
Requires: %name-cedet = %cedet_version-%release
Obsoletes: emacs22-cedet-el
Obsoletes: emacs23-cedet-el
Obsoletes: emacs24-cedet-el
Obsoletes: emacs25-cedet-el

%description cedet-el
%name-cedet-el contains the Emacs Lisp sources for the bytecode
included in the %name-cedet package, that extends the Emacs editor.

You need to install %name-cedet-el only if you intend to modify any of the
%name-cedet code or see some Lisp examples.

%package devel
Summary: Things needed to compile native modules for GNU Emacs
Summary(ru_RU.UTF-8): Необходимое для компилирования модулей к GNU Emacs
Group: Editors

%description devel
GNU Emacs is an extensible, customizable, self-documenting real-time
display editor.  Emacs contains special code editing features, an
extension language (Emacs Lisp), and the capability to read mail, news
and more without leaving the editor.

This package includes things you need to compile native modules for
the Emacs editor

%prep
%setup -n %shortname
# Ukrainian docs:
cp %SOURCE16 .
cp %SOURCE17 .
cp %SOURCE18 .
cp %SOURCE7 .

# README.ALT
cp %SOURCE50 .

perl -pi -e 's|(\.\./info/[[:alpha:]-]+)|$1.info|g' doc/emacs/*
perl -pi -e 's|(\.\./info/[[:alpha:]-]+)|$1.info|g' doc/misc/*
# rm -rf info/*

# Touch changed el files
touch lisp/faces.el lisp/gnus/mm-util.el lisp/gnus/rfc2047.el \
    lisp/international/mule-cmds.el lisp/jka-cmpr-hook.el \
    lisp/language/cyril-util.el lisp/language/cyrillic.el \
    lisp/mouse-sel.el lisp/mouse.el lisp/saveplace.el \
    lisp/term/x-win.el lisp/textmodes/ispell.el

%define Substage printf 'Substage #%%s. %%s:\\n'

# We build five binaries (with X and without X support) 
# in several symmetric substages.

%Substage 0 "Clear and create the build directories"
[ -d build-nox ] && rm -rf build-nox; mkdir -p build-nox
[ -d build-athena ] && rm -rf build-athena; mkdir -p build-athena
[ -d build-motif ] && rm -rf build-motif; mkdir -p build-motif
[ -d build-gtk ] && rm -rf build-gtk; mkdir -p build-gtk
[ -d build-gtk3 ] && rm -rf build-gtk3; mkdir -p build-gtk3

# Create pkgconfig file
emacs_pc_file=`find . -name '*.pc' -or -name '*.pc.in'`
if [ -n "$emacs_pc_file" ]; then
    echo "Hurray! emacs now ships his own pc file!"
    echo "Remove me, but merge first sitepkglispdir and sitestartdir!"
    exit 1
else
    cat > emacs.pc << EOF
sitepkglispdir=%_emacslispdir
sitestartdir=%_emacs_sitestart_dir

Name: emacs
Description: GNU Emacs text editor
Version: %{version}
EOF
fi

%build
autoreconf -i -I m4
# Try to detect errors and break on errors:
%define detect_elisp_errs 2>&1 | awk '/!! /{ r++; } END{ if (r) printf "There were %%d errors while recompiling Emacs Lisp modules.\\n", r; exit r; } /.*/'

# We do not want to use anything from an existing Emacs installation:
export EMACSLOADPATH="$(pwd)"/lisp

# we require at least one binary to use at substage 3 and later
%if_enabled gtk3
  %define stage3bin gtk3
%else
  %if_enabled gtk
    %define stage3bin gtk
  %else
    %if_enabled athena
      %define stage3bin athena
    %else
      %if_enabled motif
        %define stage3bin motif
      %else
        %if_enabled nox
          %define stage3bin nox
        %else
          echo "ERROR: You disabled all %shortname binary subpackages!"
          echo "enable at least one (nox, athena, motif or gtk) binary subpackage."
          exit 11;
        %endif
      %endif
    %endif
  %endif
%endif

%Substage 1 "Configure"

%define _configure_script ../configure
%if_enabled nox
pushd build-nox
%configure --disable-build-details --sharedstatedir=/var --without-all --with-pop --with-x=no --with-gpm --with-gnutls --with-selinux --with-xml2 --with-wide-int --without-lcms2 --with-modules
popd
%endif
%if_enabled athena
pushd build-athena
%configure --disable-build-details --sharedstatedir=/var --with-pop --with-x-toolkit=athena --with-png --with-jpeg --with-xpm --with-gif --with-tiff --enable-font-backend --with-freetype --with-xft --with-dbus --with-rsvg --with-wide-int --with-lcms2 --with-modules
popd
%endif
%if_enabled gtk
pushd build-gtk
%configure --disable-build-details --sharedstatedir=/var --with-pop --with-x-toolkit=gtk2 --with-png --with-jpeg --with-xpm --with-gif --with-tiff --with-gpm --enable-font-backend --with-freetype --with-xft --with-dbus --with-rsvg --with-wide-int --with-lcms2 --with-modules
popd
%endif
%if_enabled motif
pushd build-motif
%configure --disable-build-details --sharedstatedir=/var --with-pop --with-x-toolkit=motif --with-png --with-jpeg --with-xpm --with-gif --with-tiff --enable-font-backend --with-freetype --with-xft --with-dbus --with-rsvg --with-wide-int --with-lcms2 --with-modules
popd
%endif
%if_enabled gtk3
pushd build-gtk3
%configure --disable-build-details --sharedstatedir=/var --with-pop --with-x-toolkit=gtk3 --with-png --with-jpeg --with-xpm --with-gif --with-tiff --with-gpm --enable-font-backend --with-freetype --with-xft --with-dbus --with-rsvg --with-wide-int --with-lcms2 --with-modules
popd
%endif

%Substage 2 "Initial make all" 
#no SMP
%if_enabled nox
pushd build-nox; make; popd
%endif
%if_enabled athena
pushd build-athena; make; popd
%endif
%if_enabled motif
pushd build-motif; make; popd
%endif
%if_enabled gtk
pushd build-gtk; make; popd
%endif
%if_enabled gtk3
pushd build-gtk3; make; popd
%endif

%Substage 3 "Make supplementary (and important) things only once (asymmetricly) 
 (for possibly more capabilities -- in the X build)"

pushd build-%stage3bin
make -C doc/emacs
make -C doc/misc
# Removed recompilation lisp sources on third stage - make bootstrap do it
{
    # Recompile so that the patches we have applied are effective:
    # The goal `updates' should update all the generated code
    # (autoloads, custom-deps etc.). 
    # Also compile php-mode and the small new file for Cyrillic support.
    make -C lisp \
        updates \
        international/cyrillic-codepages-setup.elc \
        recompile
#       progmodes/php-mode.elc \
} %detect_elisp_errs
popd # build-%stage3bin

%Substage 4 "Final make all (now that we have all patched Lisp code compiled, 
 also a bit asymmetric), clean previous binaries"

%define override_from_stage3() if [ ! '%stage3bin'=='%{1}' ]; then rm -rf etc leim; ln -s -f ../build-%stage3bin/{etc,leim} . ; fi

# no SMP
%if_enabled athena
pushd build-athena
  # Override some data with more complete from the X build
  # (exactly the X variant of the data will be included in the package,
  # so emacs-athena has to work correctly in this environment):
  %override_from_stage3 athena
  rm -f src/emacs src/emacs-[0-9]*
  make
popd
%endif
%if_enabled motif
pushd build-motif
  # Override some data with more complete from the X build
  # (exactly the X variant of the data will be included in the package,
  # so emacs-motif has to work correctly in this environment):
  %override_from_stage3 motif
  rm -f src/emacs src/emacs-[0-9]*
  make
popd
%endif
%if_enabled nox
pushd build-nox
  # Override some data with more complete from the X build
  # (exactly the X variant of the data will be included in the package,
  # so emacs-nox has to work correctly in this environment):
  %override_from_stage3 nox
  rm -f src/emacs src/emacs-[0-9]*
  make
popd
%endif
%if_enabled gtk
pushd build-gtk
  # Override some data with more complete from the X build
  # (exactly the X variant of the data will be included in the package,
  # so emacs-nox has to work correctly in this environment):
  %override_from_stage3 gtk
  rm -f src/emacs src/emacs-[0-9]*
  make
popd
%endif
%if_enabled gtk3
pushd build-gtk3
  # Override some data with more complete from the X build
  # (exactly the X variant of the data will be included in the package,
  # so emacs-nox has to work correctly in this environment):
  %override_from_stage3 gtk3
  rm -f src/emacs src/emacs-[0-9]*
  make
popd
%endif

%install
mkdir -p %buildroot%prefix
# GZIP_PROG= for disable compress installed .el files - this function better
# realized in el-pkgutils
%makeinstall -C build-%stage3bin
%if_enabled nox
install -p -m755 build-nox/src/%shortname %buildroot%_bindir/%name-nox
%endif
%if_enabled athena
install -p -m755 build-athena/src/%shortname %buildroot%_bindir/%name-athena
%endif
%if_enabled motif
install -p -m755 build-motif/src/%shortname %buildroot%_bindir/%name-motif
%endif
%if_enabled gtk
install -p -m755 build-gtk/src/%shortname %buildroot%_bindir/%name-gtk
%endif
%if_enabled gtk3
install -p -m755 build-gtk3/src/%shortname %buildroot%_bindir/%name-gtk3
%endif
# remove the installed duplicate emacs binary
# -- it'll be a link managed by `alternatives':
rm -f %buildroot%_bindir/%shortname
rm -f %buildroot%_bindir/%shortname-%emacs_version

install -d %buildroot%_desktopdir
install -p -m644  %SOURCE60 %buildroot%_desktopdir/%name.desktop

# backwards compatibility with Master 2x/Compact 30
%{?!_niconsdir:%define _niconsdir %_iconsdir}
# New emacs icons (from Andrew Zhilin)
# now make install do it
# install -p -m644 -D etc/images/icons/hicolor/16x16/apps/emacs.png %buildroot%_miconsdir/%name.png
# install -p -m644 -D etc/images/icons/hicolor/32x32/apps/emacs.png %buildroot%_niconsdir/%name.png
# install -p -m644 -D etc/images/icons/hicolor/48x48/apps/emacs.png %buildroot%_liconsdir/%name.png
# install -p -m644 -D etc/images/icons/hicolor/24x24/apps/emacs.png %buildroot%_iconsdir/hicolor/24x24/apps/%name.png
# install -p -m644 -D etc/images/icons/hicolor/128x128/apps/emacs.png %buildroot%_iconsdir/hicolor/128x128/apps/%name.png
mv %buildroot%_miconsdir/emacs.png %buildroot%_miconsdir/%name.png
mv %buildroot%_niconsdir/emacs.png %buildroot%_niconsdir/%name.png
mv %buildroot%_liconsdir/emacs.png %buildroot%_liconsdir/%name.png
mv %buildroot%_iconsdir/hicolor/24x24/apps/emacs.png %buildroot%_iconsdir/hicolor/24x24/apps/%name.png
mv %buildroot%_iconsdir/hicolor/128x128/apps/emacs.png %buildroot%_iconsdir/hicolor/128x128/apps/%name.png
mv %buildroot%_iconsdir/hicolor/scalable/apps/emacs.svg %buildroot%_iconsdir/hicolor/scalable/apps/%name.svg

# All the install's below have nothing to do with the Source directory
# So we want to make the command arguments shorter 
# by replacing "$RPM_BUILD_ROOT" with "."

pushd %buildroot # there will be a popd below

# leim's Makefile doesn't ignore .orig; remove them:
find .%_datadir/%shortname/%emacs_version/lisp/leim -type f -name '*.orig' -print0 \
     | xargs -0 rm -f

# Site start configuration:
# Link to a file provided by emacsen-startscripts pkg:
(cd .%_datadir/emacs/%emacs_version/lisp; ln -s ../../../../..%_sysconfdir/emacs/site-start.el)
# making start scripts
mkdir -p %buildroot%_emacs_sitestart_dir
install -p -m0644 %SOURCE41 %buildroot%_emacs_sitestart_dir/rus-win-keyboard.el

#######################
# Various other stuff #
#######################

# mkdir -p .%_libdir/%shortname/site-lisp

mv .%_mandir/man1/{,g}ctags.1.gz
mv .%_bindir/{,g}ctags

# Exclude speedbar:
# rm -f .{%_datadir/%shortname/%emacs_version/lisp,%_infodir}/speedbar*

# Exclude antlr-mode:
# rm -f .%_datadir/%shortname/%emacs_version/lisp/progmodes/antlr-mode.el*

# Remove Gnus:
# rm -f .%_datadir/%shortname/%emacs_version/lisp/gnus/format-spec*
# rm -rf .%_datadir/%shortname/%emacs_version/lisp/gnus 
# rm -f .%_infodir/{gnus,emacs-mime,message}*
# rm -rf .%_datadir/%shortname/%emacs_version/etc/gnus*

rm -f .%_infodir/info*
rm -f .%_infodir/dir

########################
# Alternatives support #
########################
install -d %buildroot%_altdir
%if_enabled nox
install -p -m644 %SOURCE24 %buildroot%_altdir/%name-nox
%endif
%if_enabled athena
install -p -m644 %SOURCE25 %buildroot%_altdir/%name-athena
%endif
%if_enabled motif
install -p -m644 %SOURCE26 %buildroot%_altdir/%name-motif
%endif
%if_enabled gtk
install -p -m644 %SOURCE27 %buildroot%_altdir/%name-gtk
%endif
%if_enabled gtk3
install -p -m644 %SOURCE28 %buildroot%_altdir/%name-gtk3
%endif

###############
# X resources #
###############
xrdir=%_sysconfdir/X11/app-defaults
mkdir -p ."$xrdir"
install -p -m0644 %SOURCE31 ."$xrdir/Emacs"
unset xrdir

popd # "$RPM_BUILD_ROOT"

#####################
# Create file lists #
#####################
# INFO
%define common_infos ada-mode.info.gz,auth.info.gz,autotype.info.gz,bovine.info.gz,calc.info.gz,ccmode.info.gz,cl.info.gz,dbus.info.gz,dired-x.info.gz,ebrowse.info.gz,ediff.info.gz,edt.info.gz,efaq.info.gz,emacs-gnutls.info.gz,emacs.info.gz,epa.info.gz,ert.info.gz,eshell.info.gz,eudc.info.gz,eww.info.gz,flymake.info.gz,forms.info.gz,htmlfontify.info.gz,idlwave.info.gz,ido.info.gz,mairix-el.info.gz,mh-e.info.gz,newsticker.info.gz,octave-mode.info.gz,org.info.gz,pcl-cvs.info.gz,pgg.info.gz,rcirc.info.gz,reftex.info.gz,remember.info.gz,sasl.info.gz,sc.info.gz,ses.info.gz,smtpmail.info.gz,srecode.info.gz,todo-mode.info.gz,url.info.gz,vhdl-mode.info.gz,vip.info.gz,viper.info.gz,widget.info.gz,wisent.info.gz,woman.info.gz
%define gnus_infos emacs-mime,gnus,message,sieve
%define gnus_infos_pattern gnus\\|emacs-mime\\|message\\|sieve
%define speedbar_infos_pattern speedbar
%define cedet_infos ede,eieio,semantic
%define cedet_infos_pattern ede\\|eieio\\|semantic
%define erc_infos_pattern erc
%define tramp_infos_pattern tramp
%define nxml_infos_pattern nxml-mode
%define elisp_infos_pattern elisp\\|eintr

# source emacs pgktools (bash functions that call el-functions)
. %_emacs_etc_dir/el-pkgutils/el-pkgutils.sh
EMACS_BIN="%name-%stage3bin"
EMACS_SEARCH_ROOT="$RPM_BUILD_ROOT"
EL_PKGUTILS_ROOT=""
# Clear the lists:
rm -f {main,leim}{,-el}.ls info.ls

# Generate them:
# INFO
common_infos=( $(ls "$RPM_BUILD_ROOT"%_infodir/*.info.gz \
| sed -e "s:^$RPM_BUILD_ROOT%_infodir/::" \
| sort -u \
| egrep -v %gnus_infos_pattern \
| egrep -v %speedbar_infos_pattern \
| egrep -v %cedet_infos_pattern \
| egrep -v %erc_infos_pattern \
| egrep -v %tramp_infos_pattern \
| egrep -v %nxml_infos_pattern \
| egrep -v %elisp_infos_pattern ) )

( # save IFS
IFS=,
if [[ '%common_infos' != "${common_infos[*]}" ]]; then
      echo "common_infos lists do not match, correct them!"
      exit 1
fi
) || false

# fraction \
#  '(dirs "%_libexecdir/%shortname/%emacs_version" "%%dir") "main.ls"' \
#  '(files "%_libexecdir/%shortname/%emacs_version"
#     (lambda(f) (if (string-match "/movemail$" f) "%%attr(-,root,mail)")) )
#   "main.ls"' \
#  \
#  '(dirs "%_datadir/%shortname/%emacs_version/etc" "%%dir") "main.ls"' \
#  '(files "%_datadir/%shortname/%emacs_version/etc"
#     (lambda(f) (if (string-match "gnus" f) "#")) )
#   "main.ls"'

find "$RPM_BUILD_ROOT%_libexecdir/%shortname/%emacs_version" \
    "$RPM_BUILD_ROOT%_datadir/%shortname/%emacs_version/etc" -type d -print \
    | awk '// {gsub ("%buildroot","",$0); print "%%dir " $0}' > main.ls
find "$RPM_BUILD_ROOT%_libexecdir/%shortname/%emacs_version" -type f -print | awk '/\/movemail$/ { printf "%%%%attr(-,root,mail) "} // {gsub ("%buildroot","",$0); print $0}' >> main.ls
find "$RPM_BUILD_ROOT%_datadir/%shortname/%emacs_version/etc" -type f -print | awk '/gnus/ { printf "#"} // {gsub ("%buildroot","",$0); print $0}' >> main.ls

# FIXME look into el-pkgutils.el to see what broken
# standard_fraction_el_elc main "%_datadir/%shortname/%emacs_version/lisp"
# standard_fraction_el_elc leim "%_datadir/%shortname/%emacs_version/lisp/leim"

# INFO
printf '%%s\n' %_infodir/{%common_infos}'' > info.ls
# mv $RPM_BUILD_ROOT%_infodir/dir $RPM_BUILD_ROOT%_infodir/elisp.dir

# Prepare the trick for linking etc/ into docs:
ln -s $(relative %_emacs_datadir/%emacs_version/etc %_docdir/%name-%emacs_version/etc) etc/

# Substitute emacs26-common with emacs-common for buildreq
mkdir -p %buildroot%_sysconfdir/buildreqs/packages/substitute.d
echo %shortname-common > %buildroot%_sysconfdir/buildreqs/packages/substitute.d/%name-common
# Substitute emacs26-leim with emacs-leim for buildreq
echo %shortname-leim > %buildroot%_sysconfdir/buildreqs/packages/substitute.d/%name-leim
# Substitute emacs26-gnus with emacs-gnus for buildreq
echo %shortname-gnus > %buildroot%_sysconfdir/buildreqs/packages/substitute.d/%name-gnus
# Substitute emacs26-X11.* with emacs-X11 for buildreq
echo %shortname-X11 > %buildroot%_sysconfdir/buildreqs/packages/substitute.d/%name-X11
%if_enabled athena
echo %shortname-X11 > %buildroot%_sysconfdir/buildreqs/packages/substitute.d/%name-X11-athena
%endif
%if_enabled motif
echo %shortname-X11 > %buildroot%_sysconfdir/buildreqs/packages/substitute.d/%name-X11-motif
%endif
%if_enabled gtk
echo %shortname-X11 > %buildroot%_sysconfdir/buildreqs/packages/substitute.d/%name-X11-gtk
%endif
%if_enabled gtk3
echo %shortname-X11 > %buildroot%_sysconfdir/buildreqs/packages/substitute.d/%name-X11-gtk3
%endif
%if_enabled nox
# Substitute emacs26-nox with emacs-nox for buildreq
echo %shortname-nox > %buildroot%_sysconfdir/buildreqs/packages/substitute.d/%name-nox
%endif

# check-shadows script
install -p -m755 %SOURCE51 %buildroot%_bindir/check-shadows

# Install pkgconfig file
mkdir -p %buildroot%_datadir/pkgconfig
install -p -m 0644 emacs.pc %buildroot%_datadir/pkgconfig/

# Install app data
mkdir -p %buildroot%_datadir/appdata
install -p -m 0644 etc/emacs.appdata.xml %buildroot%_datadir/appdata/emacs.appdata.xml

#
%files common -f main.ls
%_datadir/appdata/emacs.appdata.xml
%doc BUGS README README.KOI8-U README.UK CHANGES.ukr INSTALL.ukr README.ALT-ru_RU.KOI8-R
# The trick for symlinking etc/:
%doc --no-dereference etc/etc

# %config(noreplace) %_sysconfdir/emacs/site-start.d/php.el

%_bindir/*
%if_enabled nox
%exclude %_bindir/%name-nox
%endif
%if_enabled athena
%exclude %_bindir/%name-athena
%endif
%if_enabled motif
%exclude %_bindir/%name-motif
%endif
%if_enabled gtk
%exclude %_bindir/%name-gtk
%endif
%if_enabled gtk3
%exclude %_bindir/%name-gtk3
%endif

%_mandir/man?/*

%dir %_libexecdir/%shortname
# %dir %_libdir/%shortname/site-lisp

#%dir %_emacslispdir
%_emacslispdir/*.el*
%dir %_emacs_datadir/%emacs_version
%dir %_emacs_datadir/%emacs_version/site-lisp
%_emacs_datadir/%emacs_version/site-lisp/*

# Elisp files
%_emacs_datadir/%emacs_version/lisp/
# except *.el.gz files
%exclude %_emacs_datadir/%emacs_version/lisp/*.el.gz
%exclude %_emacs_datadir/%emacs_version/lisp/calc/*.el.gz
%exclude %_emacs_datadir/%emacs_version/lisp/calendar/*.el.gz
%exclude %_emacs_datadir/%emacs_version/lisp/emacs-lisp/*.el.gz
%exclude %_emacs_datadir/%emacs_version/lisp/emulation/*.el.gz
%exclude %_emacs_datadir/%emacs_version/lisp/eshell/*.el.gz
%exclude %_emacs_datadir/%emacs_version/lisp/international/*.el.gz
%exclude %_emacs_datadir/%emacs_version/lisp/language/*.el.gz
%exclude %_emacs_datadir/%emacs_version/lisp/mail/*.el.gz
%exclude %_emacs_datadir/%emacs_version/lisp/mh-e/*.el.gz
%exclude %_emacs_datadir/%emacs_version/lisp/net/*.el.gz
%exclude %_emacs_datadir/%emacs_version/lisp/obsolete/*.el.gz
%exclude %_emacs_datadir/%emacs_version/lisp/org/*.el.gz
%exclude %_emacs_datadir/%emacs_version/lisp/play/*.el.gz
%exclude %_emacs_datadir/%emacs_version/lisp/progmodes/*.el.gz
%exclude %_emacs_datadir/%emacs_version/lisp/term/*.el.gz
%exclude %_emacs_datadir/%emacs_version/lisp/textmodes/*.el.gz
%exclude %_emacs_datadir/%emacs_version/lisp/url/*.el.gz

# Some .el-files that have .elc-companions,
# but are still preferrable to have in the main
# package (for reference) may be listed here:
#%_datadir/%name/%emacs_version/lisp/bindings.el -- probably there is no need for this
#%_datadir/%name/%emacs_version/lisp/mail/sc.el
#%_datadir/%name/%emacs_version/lisp/term-nasty.el

# This should be a symlink
%_emacs_datadir/%emacs_version/lisp/site-start.el

# GNUS files
%exclude %_emacs_datadir/%emacs_version/etc/images/gnus/
%exclude %_emacs_datadir/%emacs_version/etc/images/smilies/
%exclude %_emacs_datadir/%emacs_version/lisp/gnus/
%exclude %_emacs_datadir/%emacs_version/etc/gnus
%exclude %_emacs_datadir/%emacs_version/etc/GNUS-NEWS

# CEDET files
%exclude %_emacs_datadir/%emacs_version/lisp/cedet/

# speedbar into separate package
%exclude %_emacs_datadir/%emacs_version/lisp/dframe.elc
%exclude %_emacs_datadir/%emacs_version/lisp/sb-image.elc
%exclude %_emacs_datadir/%emacs_version/lisp/speedbar.elc
# erc into separate package
%exclude %_emacs_datadir/%emacs_version/etc/ERC-NEWS
%exclude %_emacs_datadir/%emacs_version/lisp/erc/
# tramp into separate package
%exclude %_emacs_datadir/%emacs_version/lisp/net/tramp*.elc
# nxml-mode into separate package
%exclude %_emacs_datadir/%emacs_version/lisp/nxml/
%exclude %_emacs_datadir/%emacs_version/etc/NXML-NEWS
%exclude %_emacs_datadir/%emacs_version/etc/nxml/
%exclude %_emacs_datadir/%emacs_version/etc/schema/
# leim into separate package
%exclude %_emacs_datadir/%emacs_version/lisp/leim/

%_emacs_sitestart_dir/*

# Substitute for buidreq
%_sysconfdir/buildreqs/packages/substitute.d/%name-common

%_datadir/pkgconfig/emacs.pc

#
%files el
%_emacs_datadir/%emacs_version/lisp/*.el.gz
%_emacs_datadir/%emacs_version/lisp/calc/*.el.gz
%_emacs_datadir/%emacs_version/lisp/calendar/*.el.gz
%_emacs_datadir/%emacs_version/lisp/emacs-lisp/*.el.gz
%_emacs_datadir/%emacs_version/lisp/emulation/*.el.gz
%_emacs_datadir/%emacs_version/lisp/eshell/*.el.gz
%_emacs_datadir/%emacs_version/lisp/international/*.el.gz
%_emacs_datadir/%emacs_version/lisp/language/*.el.gz
%_emacs_datadir/%emacs_version/lisp/mail/*.el.gz
%_emacs_datadir/%emacs_version/lisp/mh-e/*.el.gz
%_emacs_datadir/%emacs_version/lisp/net/*.el.gz
%_emacs_datadir/%emacs_version/lisp/obsolete/*.el.gz
%_emacs_datadir/%emacs_version/lisp/org/*.el.gz
%_emacs_datadir/%emacs_version/lisp/play/*.el.gz
%_emacs_datadir/%emacs_version/lisp/progmodes/*.el.gz
%_emacs_datadir/%emacs_version/lisp/term/*.el.gz
%_emacs_datadir/%emacs_version/lisp/textmodes/*.el.gz
%_emacs_datadir/%emacs_version/lisp/url/*.el.gz
# erc into separate package
%exclude %_emacs_datadir/%emacs_version/lisp/erc/
# tramp into separate package
%exclude %_emacs_datadir/%emacs_version/lisp/net/tramp*.el.*
# nxml-mode into separate package
%exclude %_emacs_datadir/%emacs_version/lisp/nxml/

#
%files leim
# Substitute for buidreq
%_sysconfdir/buildreqs/packages/substitute.d/%name-leim
%_emacs_datadir/%emacs_version/lisp/leim/
# except *.el.gz files
%exclude %_emacs_datadir/%emacs_version/lisp/leim/ja-dic/*.el.gz
%exclude %_emacs_datadir/%emacs_version/lisp/leim/quail/*.el.gz

#
%files leim-el
%_emacs_datadir/%emacs_version/lisp/leim/ja-dic/*.el.gz
%_emacs_datadir/%emacs_version/lisp/leim/quail/*.el.gz

#
%if_enabled nox
%files nox
%_bindir/%name-nox
%_altdir/%name-nox
# Substitute for buidreq
%_sysconfdir/buildreqs/packages/substitute.d/%name-nox
%endif

#
%files X11
%config(noreplace) %_sysconfdir/X11/app-defaults/*
%_desktopdir/%name.desktop
# backwards compatibility with Master 2x/Compact 30
%{?!_niconsdir:%define _niconsdir %_iconsdir}
%_niconsdir/%name.png
%_miconsdir/%name.png
%_liconsdir/%name.png
%_iconsdir/hicolor/24x24/apps/%name.png
%_iconsdir/hicolor/128x128/apps/%name.png
%_iconsdir/hicolor/scalable/apps/%name.svg
%_iconsdir/hicolor/scalable/mimetypes/emacs-document.svg
%_iconsdir/hicolor/scalable/mimetypes/emacs-document23.svg
%exclude %_desktopdir/emacs.desktop
# Substitute for buidreq
%_sysconfdir/buildreqs/packages/substitute.d/%name-X11

#
%if_enabled athena
%files X11-athena
%_bindir/%name-athena
%_altdir/%name-athena
# Substitute for buidreq
%_sysconfdir/buildreqs/packages/substitute.d/%name-X11-athena
%endif

#
%if_enabled motif
%files X11-motif
%_bindir/%name-motif
%_altdir/%name-motif
# Substitute for buidreq
%_sysconfdir/buildreqs/packages/substitute.d/%name-X11-motif
%endif

#
%if_enabled gtk
%files X11-gtk
%_bindir/%name-gtk
%_altdir/%name-gtk
# Substitute for buidreq
%_sysconfdir/buildreqs/packages/substitute.d/%name-X11-gtk
%endif

#
%if_enabled gtk3
%files X11-gtk3
%_bindir/%name-gtk3
%_altdir/%name-gtk3
# Substitute for buidreq
%_sysconfdir/buildreqs/packages/substitute.d/%name-X11-gtk3
%endif

#
%files info -f info.ls

#
%files elisp-manual
%_infodir/eintr*
%_infodir/elisp*

#
%files gnus
%doc %_emacs_datadir/%emacs_version/etc/GNUS-NEWS
%dir %_emacs_datadir/%emacs_version/lisp/gnus
%_emacs_datadir/%emacs_version/lisp/gnus/*.elc
%_emacs_datadir/%emacs_version/etc/gnus*
%_emacs_datadir/%emacs_version/etc/images/gnus/
%_emacs_datadir/%emacs_version/etc/images/smilies/
%_emacs_datadir/%emacs_version/etc/images/gnus.pbm
%_emacs_datadir/%emacs_version/etc/refcards/gnus*
%_infodir/gnus*
%_infodir/message*
%_infodir/emacs-mime*
%_infodir/sieve*
# Substitute for buidreq
%_sysconfdir/buildreqs/packages/substitute.d/%name-gnus

#
%files gnus-el
%_emacs_datadir/%emacs_version/lisp/gnus/*.el.*

#
%files speedbar
%_emacs_datadir/%emacs_version/lisp/dframe.elc
%_emacs_datadir/%emacs_version/lisp/sb-image.elc
%_emacs_datadir/%emacs_version/lisp/speedbar.elc
%_infodir/speedbar*

#
%files erc
%_emacs_datadir/%emacs_version/etc/ERC-NEWS
%dir %_emacs_datadir/%emacs_version/lisp/erc
%_emacs_datadir/%emacs_version/lisp/erc/*.elc
%_infodir/erc*

%files erc-el
%_emacs_datadir/%emacs_version/lisp/erc/*.el.*

#
%files tramp
%_emacs_datadir/%emacs_version/lisp/net/tramp*.elc
%_infodir/tramp*

%files tramp-el
%_emacs_datadir/%emacs_version/lisp/net/tramp*.el.*

#
%files nxml-mode
%_emacs_datadir/%emacs_version/lisp/nxml/
%exclude %_emacs_datadir/%emacs_version/lisp/nxml/*.el.*
%_emacs_datadir/%emacs_version/etc/NXML-NEWS
%_emacs_datadir/%emacs_version/etc/nxml
%_emacs_datadir/%emacs_version/etc/schema
%_infodir/nxml-mode*

%files nxml-mode-el
%_emacs_datadir/%emacs_version/lisp/nxml/*.el.*

#
%files cedet
%_emacs_datadir/%emacs_version/lisp/cedet/
%exclude %_emacs_datadir/%emacs_version/lisp/cedet/*.el.gz
%exclude %_emacs_datadir/%emacs_version/lisp/cedet/ede/*.el.gz
%exclude %_emacs_datadir/%emacs_version/lisp/cedet/semantic/*.el.gz
%exclude %_emacs_datadir/%emacs_version/lisp/cedet/semantic/analyze/*.el.gz
%exclude %_emacs_datadir/%emacs_version/lisp/cedet/semantic/bovine/*.el.gz
%exclude %_emacs_datadir/%emacs_version/lisp/cedet/semantic/decorate/*.el.gz
%exclude %_emacs_datadir/%emacs_version/lisp/cedet/semantic/symref/*.el.gz
%exclude %_emacs_datadir/%emacs_version/lisp/cedet/semantic/wisent/*.el.gz
%exclude %_emacs_datadir/%emacs_version/lisp/cedet/srecode/*.el.gz
%_infodir/ede*
%_infodir/eieio*
%_infodir/semantic*

#
%files cedet-el
%_emacs_datadir/%emacs_version/lisp/cedet/*.el.gz
%_emacs_datadir/%emacs_version/lisp/cedet/ede/*.el.gz
%_emacs_datadir/%emacs_version/lisp/cedet/semantic/*.el.gz
%_emacs_datadir/%emacs_version/lisp/cedet/semantic/analyze/*.el.gz
%_emacs_datadir/%emacs_version/lisp/cedet/semantic/bovine/*.el.gz
%_emacs_datadir/%emacs_version/lisp/cedet/semantic/decorate/*.el.gz
%_emacs_datadir/%emacs_version/lisp/cedet/semantic/symref/*.el.gz
%_emacs_datadir/%emacs_version/lisp/cedet/semantic/wisent/*.el.gz
%_emacs_datadir/%emacs_version/lisp/cedet/srecode/*.el.gz

%files devel
%_includedir/emacs-module.h

%changelog
