%def_disable snapshot
%set_verify_elf_method unresolved=relaxed

%define _libexecdir %_prefix/libexec

%define ver_major 40
%define beta %nil
%define api_ver 3.10
%define ua_ver 3.24
%define xdg_name org.gnome.Epiphany

Name: epiphany
Version: %ver_major.6
Release: alt1%beta

Summary: Epiphany is a GNOME web browser.
Summary(ru_RU.UTF-8): Epiphany - интернет-браузер для графической оболочки GNOME.
Group: Networking/WWW
License: GPL-3.0-or-later
Url: https://wiki.gnome.org/Apps/Web

%if_enabled snapshot
Source: %name-%version.tar
%else
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz
%endif

Provides: webclient
Obsoletes: %name-extensions

%add_findprov_lib_path %_libdir/%name

%define glib_ver 2.64
%define webkit_ver 2.31.91
%define gtk_ver 3.24.0
%define nettle_ver 3.4
%define libxml2_ver 2.6.12
%define soup_ver 2.48.0
%define secret_ver 0.19
%define gcr_ver 3.5.5
%define dazzle_ver 3.37.1
%define handy_ver 1.1.0
%define iso_codes_ver 0.35
%define sqlite_ver 3.22
%define portal_ver 0.0.2

Requires: %name-data = %version-%release indexhtml iso-codes

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson gcc-c++ yelp-tools libappstream-glib-devel desktop-file-utils
BuildRequires: libgtk+3-devel >= %gtk_ver
BuildRequires: libwebkit2gtk-devel >= %webkit_ver
BuildRequires: libxml2-devel >= %libxml2_ver
BuildRequires: libsoup-devel >= %soup_ver
BuildRequires: libsecret-devel >= %secret_ver
BuildRequires: gcr-libs-devel >= %gcr_ver
BuildRequires: libdazzle-devel >= %dazzle_ver
BuildRequires: libnotify-devel libsqlite3-devel >= %sqlite_ver
BuildRequires: libnettle-devel >= %nettle_ver
BuildRequires: iso-codes-devel >= %iso_codes_ver
BuildRequires: gcc-c++ gsettings-desktop-schemas-devel
BuildRequires: libicu-devel libjson-glib-devel
BuildRequires: pkgconfig(libhandy-1) >= %handy_ver
BuildRequires: libportal-devel >= %portal_ver
BuildRequires: libarchive-devel

%description
Epiphany is a GNOME web browser based on the Webkit rendering engine.

%description -l ru_RU.UTF-8
Epiphany - интернет-браузер для графической оболочки GNOME, основанный на
движке отрисовки страниц Webkit.

%package data
Summary: Epiphany data files
Group: Networking/WWW
BuildArch: noarch

%description data
Epiphany is a GNOME web browser based on the Webkit rendering engine.
This package contains common noarch files needed for Epiphany.

%prep
%setup -n %name-%version%beta

%build
%meson
%meson_build

%install
%meson_install
%find_lang --with-gnome --output=%name.lang %name

%files
%_bindir/%name
%dir %_libexecdir/%name
%_libexecdir/%name/ephy-profile-migrator
%_libexecdir/%name-search-provider
%dir %_libdir/%name
%_libdir/%name/*.so
%dir %_libdir/%name/web-process-extensions
%_libdir/%name/web-process-extensions/libephywebprocessextension.so
%doc NEWS README* TODO

%files data -f %name.lang
%_desktopdir/%xdg_name.desktop
%_datadir/%name
%_datadir/dbus-1/services/*
%config %_datadir/glib-2.0/schemas/org.gnome.epiphany.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.Epiphany.enums.xml
%_man1dir/*
%_datadir/gnome-shell/search-providers/%xdg_name.SearchProvider.ini
%_iconsdir/hicolor/*/apps/%{xdg_name}*.svg
%_datadir/metainfo/%xdg_name.appdata.xml

%changelog
