%define fgodir %_gamesdatadir/%name

%filter_from_requires '/python2.*/d'

Name: fgo
Version: 1.5.5
Release: alt2

Summary: A simple launcher for FlightGear flight simulator
License: distributable
Group: Games/Other
Url: http://sites.google.com/site/erobosprojects/flightgear/add-ons/fgo
Packager: Michael Shigorin <mike@altlinux.org>

BuildArch: noarch

Source0: %url/download/%name-%version.tar.gz
Source1: %name.desktop
Source2: %name.6
Source3: %name.watch

Patch0: port-to-python3.patch

BuildRequires(pre): rpm-build-python3
Requires: FlightGear >= 2.0.0

%description
FGo! is a fast and simple way to start FlightGear session in
GNU/Linux operating system. Like other such applications (e.g.
FGRun) FGo! allows you to easily select an aircraft, airport,
scenario, etc. It's also provides a convenient way to run
TerraSync.

What distinguishes it from other such applications is the text
window allowing you to write any other, more advanced command
line options that will be passed to FlightGear. This is similar
to editing the .fgfsrc configuration file.

You can actually think about FGo! as the configuration file
editor with some useful gadgets :)

%prep
%setup -n %name
%patch0 -p2

cat >> data/config/presets << __EOF__

--airport=KSFO
--fg-root=/usr/share/flightgear/
--fg-scenery=/usr/share/flightgear/Scenery
AI_SCENARIOS=
APT_DATA_SOURCE=0
FG_BIN=/usr/bin/fgfs
FG_WORKING_DIR=
FILTER_APT_LIST=0
TERRASYNC=0
TERRASYNC_BIN=/usr/bin/terrasync
TERRASYNC_PORT=5501
TERRASYNC_SCENERY=
__EOF__

%build

%install
install -pDm755 %name %buildroot%fgodir/%name
cp -a data/ src/ %buildroot%fgodir

install -d %buildroot%_gamesbindir
ln -s `relative %fgodir/%name %_gamesbindir/%name` \
	%buildroot%_gamesbindir/%name

install -pDm644 %SOURCE1 %buildroot%_desktopdir/%name.desktop
install -pDm644 %SOURCE2 %buildroot%_man6dir/%name.6
install -pDm644 share/icons/48x48/fgo.png %buildroot%_liconsdir/%name.png

%files
%_gamesbindir/%name
%fgodir/
%_desktopdir/%name.desktop
%_liconsdir/%name.png
%_man6dir/%name.6*
%doc docs/*

%changelog
