%def_with sdl2
#TODO: fix cmake SDLmain
%def_without cmake
Name: fheroes2
Epoch: 2
Version: 0.9.15
#define rev 20210604
#Release: alt1.%rev
Release: alt2
Summary: Free implementation of Heroes of the Might and Magic II engine
License: GPLv2+
Group: Games/Strategy
Url: https://github.com/ihhub/fheroes2
VCS: https://github.com/ihhub/fheroes2

%add_findreq_skiplist %_docdir/%name

Source: %name-%version.tar
Source2: %name.sh
Source3: %name.png
Source4: fheroes2-data.spec
Source5: README.ALT
Patch0: fheroes2-0.9.15-random-skills.patch
Patch1: fheroes2-0.9.15-use-python3.patch

# Automatically added by buildreq on Wed Oct 03 2012
# optimized out: libSDL-devel libstdc++-devel zlib-devel
BuildRequires: gcc-c++ libfreetype-devel gettext-tools

# with image
BuildRequires: libpng-devel
# for future use:
#BuildRequires: libjpeg-devel libwebp-devel libogg-devel
%if_with sdl2
BuildRequires: libSDL2_image-devel libSDL2_mixer-devel libSDL2_net-devel libSDL2_ttf-devel
%else
BuildRequires: libSDL_image-devel libSDL_mixer-devel libSDL_net-devel libSDL_ttf-devel
%endif
%if_with cmake
BuildRequires: cmake
%endif

%description
Free implementation of Heroes of the Might and Magic II engine.
You need to copy files from data and maps directories from original game
into your /usr/share/games/fheroes2/{maps,data} directories respectively

%prep
%setup -q
%patch0 -p1
%patch1 -p1

%build
export LANG=en_US.UTF-8
%if_with cmake
# see docs/README_cmake.md
%cmake \
    -DFHEROES2_DATA="%_gamesdatadir/%name/" \
%if_with sdl2
    -DUSE_SDL_VERSION=SDL2 \
%else
    -DUSE_SDL_VERSION=SDL \
%endif
    -DENABLE_IMAGE=ON
#    -DENABLE_TOOLS=ON

%cmake_build
%else
CFLAGS="${CFLAGS:-%optflags}"; export CFLAGS;
CCFLAGS="${CCFLAGS:-%optflags}"; export CCFLAGS;
%make_build \
%if_without sdl2
    FHEROES2_WITH_SDL1=1 \
%endif
    FHEROES2_DATA=%_gamesdatadir/%name/ \
    FHEROES2_WITH_IMAGE=1 \
    FHEROES2_WITH_TOOLS=

make -C files/lang
%endif

%install
%if_with cmake
%cmake_install
%else
# let's create directory structure...
mkdir -p %buildroot%_gamesdatadir/%name/{data,maps,files/lang}

# and install what we need where we need it to be...
install -pD -m 755 %name %buildroot%_bindir/%name
cp -a files/{data,images} %buildroot%_gamesdatadir/%name/files/
cp -a files/lang/*.mo %buildroot%_gamesdatadir/%name/files/lang/

install -pD -m 644 script/packaging/common/fheroes2.desktop %buildroot%_desktopdir/%name.desktop
%endif

# bin wrapper
mv %buildroot%_bindir/%name{,.bin}
install -pD -m 755 %SOURCE2 %buildroot%_bindir/%name

# install resources
install -pD -m 644 %SOURCE3 %buildroot%_niconsdir/%name.png
install -pD -m 644 src/resources/fheroes2.png %buildroot%_iconsdir/hicolor/128x128/apps/%name.png

# docs
mkdir -p %buildroot%_docdir/%name
install -pm 644 {CONTRIBUTING.md,changelog.txt,LICENSE,README.md,docs/INSTALL.md,docs/DEVELOPMENT.md} %buildroot%_docdir/%name/
install -pm 644 script/demo/download_demo_version.sh script/homm2/extract_homm2_resources.sh %buildroot%_docdir/%name/
install -pD -m 644 %SOURCE4 %SOURCE5 %buildroot%_docdir/%name/

%files
%_bindir/*
%_niconsdir/%name.png
%_iconsdir/hicolor/128x128/apps/%name.png
%_desktopdir/%name.desktop
%doc %_docdir/%name
%_gamesdatadir/%name

%changelog
