# FIAIF is an Intelligent firewall
#
# RPM specification file.
#
# Author:	Anders Fugmann <afu@fugmann.dhs.org>
#
# FIAIF is an Intelligent firewall
# Copyright (C) 2002-2003 Anders Peter Fugmann
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

%def_with  systemd

Name: fiaif
Version: 1.22.1
Release: alt4

Summary: FIAIF is an Intelligent Firewall for iptables based Linux systems
Summary(ru_RU.UTF-8): FIAIF - интеллектуальный межсетевой экран для Linux-систем с iptables

License: %gpl2plus
Group: Security/Networking
URL: http://freshmeat.sourceforge.net/projects/fiaif

Packager: Nikolay A. Fetisov <naf@altlinux.ru>
BuildArch: noarch

Source0: %{name}_%version.tar
Source1: zone.venet
Source2: reserved_networks
%if_with systemd
Source3: fiaif.service
%endif

Patch1: %name-1.19.2-alt-fiaif_update.patch
Patch2: %name-1.19.2-alt-test_location.patch
Patch3: %name-1.19.2-alt-fiaif_script_actions.patch
Patch4: %name-1.21.1-alt-CBQ-legacy_support.patch
Patch5: %name-1.21.1-alt-LSB_init.patch
Patch6: %name-1.21.1-alt-autonumbering_note.patch
Patch7: %name-1.21.1-alt-fiaif_venet_zone.patch
Patch8: %name-1.22.1-log_level.patch
Patch9: %name-1.22.1-btime.patch
Patch10: %name-1.22.1-cleanup_rules.patch
Patch11: %name-1.22.1-vlan_devices.patch
Patch12: %name-1.22.1-alt-bash4.patch
Patch13: %name-1.22.1-alt-disable_cron_task.patch

Requires: iptables >= 1.2.6a, bash >= 2.04
BuildRequires(pre): rpm-build-licenses
# Automatically added by buildreq on Tue Mar 06 2018
# optimized out: fontconfig python-base python-modules python3 python3-base python3-module-zope ruby ruby-stdlibs tex-common texlive texlive-collection-basic texlive-dist
BuildRequires: texlive-dist


%description
FIAIF is  an  Intellegent  Firewall. The Goal of  FIAIF  is to
provide  a  highly  customizable  script  for  setting  up  an
iptables based firewall.

Unlike  many  other scripts,  FIAIF  can  be truly  customized
allowing multiple  interfaces (or  rather zones). There  is no
limit  on  the number  of  zones.  All configuration  is  done
through configuration files. No  need to understand the script
behind it all.

The script makes heavy use  of state-full firewalling, and all
RELATED and ESTABLISHED packets are accepted on all chains. If
you which  to block  something out,  do not  accept it  in the
first place.

The script is written in BASH.  Though this is not the optimal
program to use, it means that you do not need to install extra
interpreters  on your  firewall.  This allows  you  to have  a
minimalistic installation on your firewall.

Install this package if your machine is ever on the internet.

%description -l ru_RU.UTF-8
FIAIF - скрипт с широкими возможностями настройки для создания
межсетевых экранов на базе iptables.

По сравнению с  многими  другими скриптами,  FIAIF может  быть
сконфигурирован для  поддержки нескольких  сетевых интерфейсов
(или  иначе зон).  В  нём нет  ограничений  на число зон.  Вся
настройка  происходит  через   файлы  конфигурации,  при  этом
изучать приципы работы самого скрипта нет необходимости.

FIAIF  широко использует  возможности iptables по отслеживанию
состояний  установленных  соединений,  RELATED  и  ESTABLISHED
пакеты принимаются  во всех цепочках.  Если Вы хотите что-либо
блокировать какие-либо соединения, просто не принимайте их.

FIAIF написан на BASH.  Хотя bash - не самый  оптимальный язык
для  написания  больших скриптов,  зато  для  работы FIAIF  не
требуется  устанавливать  лишние интерпретаторы  на межсетевом
экране.

%package doc
Summary: FIAIF documentation
Summary(ru_RU.UTF-8): документация к FIAIF
Group: Books/Other

%description doc
FIAIF is  an  Intellegent  Firewall. The Goal of  FIAIF  is to
provide  a  highly  customizable  script  for  setting  up  an
iptables based firewall.

This package contains FIAIF documentation: user guide and FAQ.

%description doc  -l ru_RU.UTF-8
FIAIF - скрипт с широкими возможностями настройки для создания
межсетевых экранов на базе iptables.

Данный пакет содержит документацию к FIAIF - руководство
пользователя и FAQ.

%define fiaif_conf  %_sysconfdir/fiaif

%prep
%setup
%patch1 -p0
%patch2 -p0
%patch3 -p0
%patch4 -p0
%patch5 -p0
%patch6 -p0
%patch7 -p0
%patch8 -p0
%patch9 -p0
%patch10 -p0
%patch11 -p0
%patch12 -p0
%patch13 -p0

# Fix path to fiaif main script
subst 's@/etc/init.d@/etc/rc.d/init.d@' cron/fiaif

# Install sample config for VENET zone
install -m 0644 %SOURCE1 conf/zone.venet
subst 's#CONF_FILES=fiaif.conf#CONF_FILES=fiaif.conf zone.venet#' Makefile

# Install fresh reserved_networks
install -m 0644 %SOURCE2 conf/reserved_networks

%build
DISPLAY=0:0 LANG=RU_ru.UTF-8  [ -f fiaif.ps ] || make fiaif.ps

%install
make install DESTDIR=$RPM_BUILD_ROOT
make install-config DESTDIR=$RPM_BUILD_ROOT

[ -f fiaif.ps ] && gzip -9 fiaif.ps

install -d -- $RPM_BUILD_ROOT{%_sbindir,%_mandir/man8,%_initdir}
install -- prog/fiaif $RPM_BUILD_ROOT%_initdir/fiaif
# Creating link /usr/sbin/fiaif -> %_initdir/fiaif
ln -s %_initdir/%name $RPM_BUILD_ROOT%_sbindir/%name

# Removing unnecessary but installed files
rm -rf -- $RPM_BUILD_ROOT%_sysconfdir/init.d/%name
rm -rf -- $RPM_BUILD_ROOT%_defaultdocdir/%name

%if_with systemd
# Installing systemd unit file
mkdir -p  %buildroot%_unitdir
install -m 0755 %SOURCE3 %buildroot%_unitdir/%name.service
%endif

%post
%post_service %name

# Fix fiaif.conf - replace log level from CRIT to crit, and etc.
# The support of upper-case log levels names had been dropped in iptables >= 1.4.15
# Older iptables versions can handle both upper and lower case names,
# newly ones - only lower case.
sed -e 's/LOG_LEVEL=ALERT/LOG_LEVEL=alert/'     -i %fiaif_conf/fiaif.conf
sed -e 's/LOG_LEVEL=CRIT/LOG_LEVEL=crit/'       -i %fiaif_conf/fiaif.conf
sed -e 's/LOG_LEVEL=DEBUG/LOG_LEVEL=debug/'     -i %fiaif_conf/fiaif.conf
sed -e 's/LOG_LEVEL=EMERG/LOG_LEVEL=emerg/'     -i %fiaif_conf/fiaif.conf
sed -e 's/LOG_LEVEL=ERROR/LOG_LEVEL=error/'     -i %fiaif_conf/fiaif.conf
sed -e 's/LOG_LEVEL=INFO/LOG_LEVEL=info/'       -i %fiaif_conf/fiaif.conf
sed -e 's/LOG_LEVEL=NOTICE/LOG_LEVEL=notice/'   -i %fiaif_conf/fiaif.conf
sed -e 's/LOG_LEVEL=PANIC/LOG_LEVEL=panic/'     -i %fiaif_conf/fiaif.conf
sed -e 's/LOG_LEVEL=WARNING/LOG_LEVEL=warning/' -i %fiaif_conf/fiaif.conf

%preun
%preun_service %name

%files
%doc VERSION changelog
%doc doc/reporting_bugs.txt doc/upgrade.txt doc/DHCP.txt

%dir %attr(0700,root,root) %fiaif_conf/
%dir %attr(0700,root,root) %_var/lib/%name/

%config(noreplace) %fiaif_conf/aliases
%config(noreplace) %fiaif_conf/zone.*
%config(noreplace) %fiaif_conf/fiaif.conf
%config(noreplace) %fiaif_conf/reserved_networks
%config(noreplace) %fiaif_conf/private_networks
%config(noreplace) %fiaif_conf/type_of_services

%if_with systemd
%_unitdir/%name.service
%endif

%attr(0700,root,root) %_sysconfdir/cron.daily/%name
%_initdir/%name
%_sbindir/*

%dir %_datadir/%name/
%_datadir/%name/*

%_mandir/man?/*

%files doc
%doc fiaif.ps.gz doc/faq.txt

%changelog
