%define _unpackaged_files_terminate_build 1
%set_verify_elf_method relaxed

%ifndef build_parallel_jobs
%global build_parallel_jobs %__nprocs
%endif

%define gst_version   1.0
%define nspr_version  4.35
%define nss_version   3.98
%define rust_version  1.65.0
%define cargo_version 1.65.0
%define llvm_version  17.0

Name: firefox-esr
Version: 140.5.0
Release: alt0.p10.1

Summary: The Mozilla Firefox project is a redesign of Mozilla's browser
Summary(ru_RU.UTF-8): Интернет-браузер Mozilla Firefox
License: MPL-2.0
Group: Networking/WWW
URL: https://www.mozilla.org/firefox/
# Hang up on build browser/components/about
ExcludeArch: ppc64le armh

Source0: firefox-source.tar
### Start Patches
Patch001: 0001-FEDORA-build-arm-libopus.patch
Patch002: 0002-Revert-Bug-1712947-Don-t-pass-neon-flags-to-rustc-wh.patch
Patch003: 0003-ALT-fix-double_t-redefinition.patch
Patch004: 0004-build-Disable-Werror.patch
### End Patches

Provides: webclient
Provides: firefox-esr-ru = %EVR
Provides: firefox-esr-uk = %EVR
Provides: firefox-esr-kk = %EVR
Provides: firefox-esr-uz = %EVR
Provides: firefox-esr-wayland = %EVR
Requires: mozilla-common
# ALT#30732
Requires: gst-plugins-ugly%gst_version
Requires: libnspr >= %nspr_version
Requires: libnss >= %nss_version
Conflicts: firefox
Obsoletes: firefox-esr-ru < %EVR
Obsoletes: firefox-esr-uk < %EVR
Obsoletes: firefox-esr-kk < %EVR
Obsoletes: firefox-esr-uz < %EVR
Obsoletes: firefox-esr-wayland < %EVR

BuildRequires(pre): mozilla-common-devel
BuildRequires(pre): rpm-build-firefox
BuildRequires(pre): browser-plugins-npapi-devel
BuildRequires: clang%llvm_version
BuildRequires: clang%llvm_version-devel
BuildRequires: llvm%llvm_version-devel
BuildRequires: lld%llvm_version-devel
%ifarch armh %{ix86}
%filter_from_requires /libc.so.6(GLIBC_PRIVATE)/d
BuildRequires: gcc
BuildRequires: gcc-c++
%endif
BuildRequires: libstdc++-devel
BuildRequires: glibc-kernheaders-generic
BuildRequires: rpm-macros-alternatives
BuildRequires: rust >= %rust_version
BuildRequires: rust-cargo >= %cargo_version
BuildRequires: cbindgen
BuildRequires: node
BuildRequires: nasm yasm
BuildRequires: zip unzip
BuildRequires: libshell
BuildRequires: libwireless-devel
BuildRequires: libnss-devel-static
BuildRequires: xorg-cf-files chrpath alternatives
BuildRequires: gstreamer%gst_version-devel gst-plugins%gst_version-devel
BuildRequires: pkgconfig(alsa)
BuildRequires: pkgconfig(aom)
BuildRequires: pkgconfig(bzip2)
BuildRequires: pkgconfig(cairo)
BuildRequires: pkgconfig(dav1d)
BuildRequires: pkgconfig(dbus-1)
BuildRequires: pkgconfig(dbus-glib-1)
BuildRequires: pkgconfig(dri)
BuildRequires: pkgconfig(fontconfig)
BuildRequires: pkgconfig(freetype2)
BuildRequires: pkgconfig(gio-2.0)
BuildRequires: pkgconfig(graphite2)
BuildRequires: pkgconfig(gtk+-3.0)
BuildRequires: pkgconfig(harfbuzz)
BuildRequires: pkgconfig(hunspell)
BuildRequires: pkgconfig(icu-i18n)
BuildRequires: pkgconfig(libcurl)
BuildRequires: pkgconfig(libdrm)
BuildRequires: pkgconfig(libevent)
BuildRequires: pkgconfig(libffi)
BuildRequires: pkgconfig(libjpeg)
BuildRequires: pkgconfig(libnotify)
BuildRequires: pkgconfig(libproxy-1.0)
BuildRequires: pkgconfig(libpulse)
BuildRequires: pkgconfig(libstartup-notification-1.0)
BuildRequires: pkgconfig(nspr) >= %nspr_version
BuildRequires: pkgconfig(nss) >= %nss_version
BuildRequires: pkgconfig(opus)
BuildRequires: pkgconfig(pixman-1)
BuildRequires: pkgconfig(vpx)
BuildRequires: pkgconfig(x11)
BuildRequires: pkgconfig(xcomposite)
BuildRequires: pkgconfig(xcursor)
BuildRequires: pkgconfig(xdamage)
BuildRequires: pkgconfig(xext)
BuildRequires: pkgconfig(xft)
BuildRequires: pkgconfig(xi)
BuildRequires: pkgconfig(xkbcommon)
BuildRequires: pkgconfig(xrandr)
BuildRequires: pkgconfig(xscrnsaver)
BuildRequires: pkgconfig(xt)
BuildRequires: pkgconfig(xtst)
BuildRequires: pkgconfig(zlib)

# Python requires
BuildRequires: /dev/shm
BuildRequires: python3-base
BuildRequires: python3(click)
BuildRequires: python3(curses)
BuildRequires: python3(hamcrest)
BuildRequires: python3(pip)
BuildRequires: python3(setuptools)
BuildRequires: python3(sqlite3)
BuildRequires: python3(configobj)
# Rust requires
BuildRequires: /proc

%description
Mozilla Firefox is an open-source web browser, designed
for standards compliance, performance and portability.

%description -l ru_RU.UTF-8
Mozilla Firefox - это веб-браузер с открытым исходным кодом, разработанный
с учетом соответствия стандартам, производительности и переносимости.

%package config-privacy
Summary:	Firefox configuration with the paranoid privacy settings
Group:		System/Configuration/Networking

Requires: %name
Conflicts: firefox-config-privacy

Provides: x-www-browser

%description config-privacy
Settings disable:
* obsolete ssl protocols;
* safebrowsing, trackingprotection and other requests to third-party services;
* telemetry;
* webrtc;
* the social features;
* dns and network predictors/prefetch;
* and some more...

Most likely you don't need to use this package.


%prep
%setup -q -n firefox-%version -c
%autopatch -p1

mv -- .rpm/l10n .
cp -f .rpm/firefox-mozconfig .mozconfig

tee -a .mozconfig <<'EOF'
ac_add_options --prefix="%_prefix"
ac_add_options --libdir="%_libdir"
%ifnarch armh %{ix86} ppc64le loongarch64
ac_add_options --enable-linker=lld
%endif
%ifarch %{arm} %{ix86}
# See linker flags in the build section.
ac_add_options --enable-linker=bfd
%endif
%ifnarch armh %{ix86}
ac_add_options --enable-lto=thin
%endif
%ifarch armh
ac_add_options --disable-webrtc
%endif
%ifarch armh %{ix86} x86_64
ac_add_options --disable-elf-hack
%endif
%ifarch armh
ac_add_options --enable-strip
ac_add_options --enable-install-strip
ac_add_options --disable-rust-debug
ac_add_options --disable-debug-symbols
%else
ac_add_options --disable-strip
ac_add_options --disable-install-strip
%endif
mk_add_options MOZ_MAKE_FLAGS="-j%build_parallel_jobs --no-print-directory"
EOF

find third_party \
	-type f \( -name '*.so' -o -name '*.o' -o -name '*.a' \) \
	-delete

# Error: relocation R_386_GOTOFF against undefined hidden symbol
# `tabs_4d51_TabsBridgedEngine_reset' can not be used when making a shared
# object
# https://bugzilla.mozilla.org/show_bug.cgi?id=1805809
%ifarch armh
find toolkit/components/uniffi-js -type f |
	xargs sed -ri.poff 's,_4d51_,_1c79_,g'
%endif

rm -rf -- obj-x86_64-pc-linux-gnu
rm -rf -- third_party/python/setuptools/setuptools*
rm -rf -- third_party/python/click/click*

%build
%add_findprov_lib_path %firefox_prefix

export MOZ_BUILD_APP=browser
export MOZ_CHROME_MULTILOCALE="$(tr '\n' ' ' < .rpm/firefox-l10n.txt)"

MOZ_OPT_FLAGS=()

MOZ_OPT_FLAGS+=( -pipe -O2 )
%ifarch armh
MOZ_OPT_FLAGS+=( -march=armv7-a -mthumb )
%endif

# PIE, full relro
MOZ_OPT_FLAGS+=( -DPIC -fPIC -Wl,-z,relro -Wl,-z,now )

# Add fake RPATH
rpath="/$(printf %%s '%firefox_prefix' |tr '[:print:]' '_')"
MOZ_OPT_FLAGS+=( "-Wl,-rpath,$rpath" )

%ifnarch armh %{ix86}
MOZ_OPT_FLAGS+=( -Wno-unused-command-line-argument )
%endif
MOZ_OPT_FLAGS+=( -Wno-error=return-type )

export CFLAGS="${MOZ_OPT_FLAGS[*]}"
export CXXFLAGS="${MOZ_OPT_FLAGS[*]}"

export MOZ_PARALLEL_BUILD=%build_parallel_jobs
%ifarch armh %{ix86}
export CC="gcc"
export CXX="g++"
%else
export CC="clang"
export CXX="clang++"
%endif
export AR="llvm-ar"
export NM="llvm-nm"
export RANLIB="llvm-ranlib"
export LLVM_PROFDATA="llvm-profdata"
export ALTWRAP_LLVM_VERSION="%llvm_version"
export RUST_BACKTRACE=1
export LIBIDL_CONFIG=/usr/bin/libIDL-config-2
export SHELL=/bin/sh

# It is necessary to disable the generation of debugging
# information in order to avoid the "LLVM ERROR: out of memory".
%ifarch %ix86
export MOZ_DEBUG_FLAGS="-g0"
%endif
%ifarch armh %ix86
export RUSTFLAGS="-Clink-args=-fPIC -Cdebuginfo=0"
export LLVM_PARALLEL_LINK_JOBS=1
# See https://lwn.net/Articles/797303/ for linker flags
# For bfd on i586
export CXXFLAGS="$CXXFLAGS -Wl,--no-keep-memory -Wl,--reduce-memory-overheads -Wl,--hash-size=1021"
# Use node optimization
mkdir -p ~/bin
echo -e '#!/bin/sh\n/usr/bin/node --max-old-space-size=256 --max-semi-space-size=8 --optimize-for-size --no-opt --single-threaded "$@"' > ~/bin/node
chmod +x ~/bin/node
export NODEJS=node
export BUILD_VERBOSE_LOG=1
%else
export RUSTFLAGS="-Clink-args=-fPIC -Cdebuginfo=2"
%endif

export srcdir="$PWD"
export MOZBUILD_STATE_PATH="$srcdir/mozbuild"
export MACH_BUILD_PYTHON_NATIVE_PACKAGE_SOURCE=system

export MOZ_APP_REMOTINGNAME="firefox"

# Do not use desktop notify during build process
export MOZ_NOSPAM=1

# Don't throw "old profile" dialog box
export MOZ_ALLOW_DOWNGRADE=1

export NPROCS=%build_parallel_jobs
# Decrease NPROCS prevents oomkill terror on x86_64
%ifarch x86_64
export NPROCS=16
%endif
# Build for i586 in less threads
%ifarch armh %ix86
export NPROCS=8
%endif

export MACH_BUILD_PYTHON_NATIVE_PACKAGE_SOURCE=system
export VERBOSE=1
export V=1
python3 ./mach configure
python3 ./mach build -j $NPROCS -v

while read -r loc; do
	python3 ./mach build chrome-$loc
done < .rpm/firefox-l10n.txt

make -C objdir/browser/installer multilocale.txt

$CXX $CXXFLAGS \
	-Wall -Wextra \
	-DMOZ_PLUGIN_PATH=\"%browser_plugins_path\" \
	-DMOZ_PROGRAM=\"%firefox_prefix/firefox\" \
	-DMOZ_DIST_BIN=\"%firefox_prefix\"\
	.rpm/firefox.cpp -o firefox

%install
export SHELL=/bin/sh
export MOZ_CHROME_MULTILOCALE="$(tr '\n' ' ' < .rpm/firefox-l10n.txt)"

mkdir -p \
	%buildroot/%mozilla_arch_extdir/%firefox_cid \
	%buildroot/%mozilla_noarch_extdir/%firefox_cid \
	#

make -C objdir \
	DESTDIR=%buildroot \
	INSTALL="/bin/install -p" \
	mozappdir=%firefox_prefix \
	libdir=%_libdir \
	install

# install altlinux-specific configuration
install -D -m 644 .rpm/firefox-prefs.js %buildroot/%firefox_prefix/browser/defaults/preferences/all-altlinux.js
install -D -m 644 .rpm/firefox-privacy-prefs.js %buildroot/%_sysconfdir/firefox/defaults/pref/all-privacy.js

sed -i \
	-e 's#@VERSION@#%{version}#g' \
	%buildroot/%_sysconfdir/firefox/defaults/pref/all-privacy.js

cat > %buildroot/%firefox_prefix/browser/defaults/preferences/firefox-l10n.js <<EOF
pref("intl.locale.matchOS", true);
pref("intl.locale.requested", "");
pref("general.useragent.locale", "chrome://global/locale/intl.properties");
EOF

# icons
for s in 16 22 24 32 48 256; do
	install -D -m 644 \
		browser/branding/official/default$s.png \
		%buildroot/%_iconsdir/hicolor/${s}x${s}/apps/firefox.png
done

# ALT#30572
if [ ! -e "%buildroot/%firefox_prefix/plugins" ]; then
	what="$(relative %browser_plugins_path %firefox_prefix/plugins)"
	ln -s -- "$what" %buildroot/%firefox_prefix/plugins
fi

install -m755 firefox %buildroot/%_bindir/firefox
ln -s firefox %buildroot/%_bindir/firefox-wayland

install -D -m 644 .rpm/distribution.ini \
	%buildroot/%firefox_prefix/distribution/distribution.ini

install -D -m 644 .rpm/firefox.desktop \
	%buildroot/%_datadir/applications/firefox.desktop

install -D -m 644 .rpm/firefox-search-provider.ini \
	%buildroot/%_datadir/gnome-shell/search-providers/firefox-search-provider.ini

# Add alternatives
mkdir -p %buildroot/%_altdir
cat >%buildroot/%_altdir/firefox <<EOF
%_bindir/xbrowser	%_bindir/firefox	80
%_bindir/x-www-browser	%_bindir/firefox	80
EOF

rm -f -- \
	%buildroot/%firefox_prefix/removed-files

# Remove devel files
rm -rf -- \
	%buildroot/%_includedir/%name \
	%buildroot/%_datadir/idl/%name \
	%buildroot/%_libdir/%name-devel \
#

# Add real RPATH
(set +x
	rpath="/$(printf %%s '%firefox_prefix' |tr '[:print:]' '_')"
	find %buildroot -type f |
	while read f; do
		t="$(readlink -ev "$f")"
		file "$t" | fgrep -qs ELF ||
			continue
		chrpath -l "$t" |
			fgrep -qs \
				-e "RPATH=$rpath" \
				-e "RUNPATH=$rpath" ||
			continue
		chrpath -r "%firefox_prefix" "$t"
	done
)

%files
%dir %_sysconfdir/firefox
%dir %_sysconfdir/firefox/defaults
%dir %_sysconfdir/firefox/defaults/pref
%_altdir/firefox
%_bindir/firefox
%_bindir/firefox-wayland
%firefox_prefix
%mozilla_arch_extdir/%firefox_cid
%mozilla_noarch_extdir/%firefox_cid
%_datadir/applications/firefox.desktop
%_datadir/gnome-shell/search-providers/firefox-search-provider.ini
%_iconsdir/hicolor/16x16/apps/firefox.png
%_iconsdir/hicolor/22x22/apps/firefox.png
%_iconsdir/hicolor/24x24/apps/firefox.png
%_iconsdir/hicolor/32x32/apps/firefox.png
%_iconsdir/hicolor/48x48/apps/firefox.png
%_iconsdir/hicolor/256x256/apps/firefox.png

%files config-privacy
%config(noreplace) %_sysconfdir/firefox/defaults/pref/all-privacy.js

%changelog
