%def_disable snapshot
%set_verify_elf_method unresolved=relaxed

%define _libexecdir %_prefix/libexec

%define xdg_name org.gnome.FontManager
%define xdg_name1 org.gnome.FontViewer

%def_with nautilus

Name: font-manager
Version: 0.8.7
Release: alt1

Summary: A font management application for the GNOME desktop
License: GPL-3.0
Group: Graphical desktop/GNOME
Url: http://fontmanager.github.io/

%if_disabled snapshot
Source: https://github.com/FontManager/%name/archive/%version/%name-%version.tar.gz
%else
Vcs: https://github.com/FontManager/font-manager.git
Source: %name-%version.tar
%endif

Requires: file-roller

%define vala_ver 0.42
%define pango_ver 1.4
%define gtk_ver 3.22

BuildRequires(pre): meson rpm-build-gir
BuildRequires: vala-tools >= %vala_ver
BuildRequires: libpango-devel >= %pango_ver
BuildRequires: libgtk+3-devel >= %gtk_ver libjson-glib-devel
BuildRequires: libsqlite3-devel libxml2-devel
BuildRequires: yelp-tools desktop-file-utils libappstream-glib-devel
BuildRequires: gobject-introspection-devel libjson-glib-gir-devel libgtk+3-gir-devel
BuildRequires: pkgconfig(webkit2gtk-4.0)
%if_with nautilus
BuildRequires(pre): rpm-build-gnome
BuildRequires: libnautilus-devel
%endif

%description
Font Manager is an application that allows users to easily manage fonts
on their system.

Font Manager is not intended to be a professional-grade font management
solution, but rather a simple application suitable for the needs of most
desktop users, and even graphics designers who may need to manage just a
few thousand font files.

Although designed with the GNOME desktop environment in mind, it should
work well with most major desktop environments such as XFCE,
Enlightenment, and even KDE.

%prep
%setup

%build
%meson \
	-Dreproducible=true \
	%{?_with_nautilus:-Dnautilus=true}
%meson_build

%install
%meson_install
%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/%name
%dir %_libexecdir/%name
%_libexecdir/%name/font-viewer
%_libdir/%name/
%_desktopdir/%xdg_name.desktop
%_desktopdir/%xdg_name1.desktop
%_datadir/dbus-1/services/%xdg_name.service
%_datadir/dbus-1/services/%xdg_name1.service
%_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_datadir/glib-2.0/schemas/%xdg_name1.gschema.xml
%_iconsdir/hicolor/*/apps/*.png
%_datadir/gnome-shell/search-providers/%xdg_name.SearchProvider.ini
%_man1dir/%name.1.*
%_datadir/metainfo/%xdg_name.appdata.xml
%_datadir/metainfo/%xdg_name1.appdata.xml
%{?_with_nautilus:%nautilus_extdir/*.so}
%doc README* CHANGELOG


%changelog
