%add_python3_path %_libdir/freecad/Mod %_libdir/freecad/Ext/*
%add_python3_req_skip FreeCADGui FreeCAD
%add_findprov_skiplist %_libdir/freecad/Mod/* %_libdir/freecad/Ext/*
%def_with bundled_libs
%def_with glvnd
%define oname freecad
%define ldir %_libdir/%oname
%ifndef build_parallel_jobs
%define build_parallel_jobs 7
%endif

# Last number in version is computed by command:
# git rev-list --count remotes/upstream/releases/FreeCAD-0-17

Name:    freecad
Version: 0.19.2
Release: alt4
Epoch:   1
Summary: OpenSource 3D CAD modeller
License: LGPL-2.0+
Group:   Graphics
Url:     http://free-cad.sourceforge.net/
# VCS:   https://github.com/FreeCAD/FreeCAD
Packager: Andrey Cherepanov <cas@altlinux.org>

Source: %name-%version.tar
Source1: freecad.1

%if_without bundled_libs
Patch1: %name-remove-3rdParty.patch
%endif
Patch2: %name-0.18.4-alt-boost-1.73.0-compat.patch
Patch3: freecad-0.19.2-upstream-vtk9-compat.patch
Patch4: freecad-0.19.2-alt-boost-link.patch
Patch5: freecad-alt-fix-icon-name-in-menu.patch
Patch6: freecad-0.19.2-upstream-opencascade-compat.patch

Provides:  free-cad = %version-%release
Obsoletes: free-cad < %version-%release

BuildRequires(pre): cmake
BuildRequires(pre): rpm-build-xdg
BuildRequires(pre): rpm-build-ninja
BuildRequires(pre): rpm-build-python3
BuildRequires: qt5-base-devel
BuildRequires: qt5-assistant
BuildRequires: qt5-designer
BuildRequires: qt5-sql-sqlite3
BuildRequires: qt5-svg-devel
BuildRequires: qt5-tools-devel
BuildRequires: qt5-tools-devel-static
BuildRequires: qt5-webkit-devel
BuildRequires: qt5-x11extras-devel
BuildRequires: qt5-phonon-devel
BuildRequires: qt5-xmlpatterns-devel
BuildRequires: python3-module-PySide2
BuildRequires: pyside2-tools
BuildRequires: python3-module-PySide2-devel
BuildRequires: python3-module-shiboken2-devel
%define qmake %qmake_qt5
%define qtbindir %_qt5_bindir
BuildRequires: python3-devel swig gcc-fortran libf2c-ng-devel chrpath
BuildRequires: boost-devel
BuildRequires: boost-filesystem-devel
BuildRequires: boost-geometry-devel
BuildRequires: boost-polygon-devel
BuildRequires: boost-program_options-devel
BuildRequires: boost-python3-devel
BuildRequires: boost-signals-devel
BuildRequires: libcoin3d-devel
#BuildRequires: libSoQt-devel
BuildRequires: zlib-devel
BuildRequires: libopencv2-devel libxerces-c-devel gcc-c++
BuildRequires: java-devel-default
BuildRequires: libXxf86misc-devel
BuildRequires: opencascade-devel libgts-devel
BuildRequires: libode-devel libann-devel
BuildRequires: doxygen graphviz
BuildRequires: eigen3
#BuildRequires: python-module-pivy
BuildRequires: libnumpy-py3-devel
BuildRequires: boost-interprocess-devel
BuildRequires: gdb
BuildRequires: libvtk-devel vtk-examples vtk-python3
BuildRequires: libhdf5-devel
BuildRequires: libmed-devel libspnav-devel
BuildRequires: python3-module-matplotlib-qt5
BuildRequires: libkdtree++-devel
%if_without bundled_libs
BuildRequires: libsmesh-devel libnetgen-devel netgen
%endif
%if_with glvnd
BuildRequires: libglvnd-devel
%else
Requires: libEGL-devel libGLU-devel
%endif
#BuildRequires: texlive-extra-utils

%py3_requires pivy matplotlib.backends.backend_qt5
#py3_provides Fem FreeCAD FreeCADGui Mesh Part MeshPart Drawing ImportGui
#py3_provides PartGui Sketcher TestSketcherApp Robot RobotGui SketcherGui
#py3_provides ImageGui PartDesignGui _PartDesign
%add_python3_req_skip pyopencl IfcImport Units
%add_findreq_skiplist %ldir/Mod/*

%ifnarch armh
# TODO: cgal needed for openscad was not built for armh
Requires: openscad
%endif
Requires: python3-module-GitPython
Requires: netgen

%description
FreeCAD will be a general purpose 3D CAD modeler. FreeCAD is aimed directly at
mechanical engineering and product design but also fits in a wider range of uses
around engineering, such as architecture or other engineering specialties.

FreeCAD features tools similar to Catia, SolidWorks or Solid Edge, and therefore
also falls into the category of MCAD, PLM, CAx and CAE. It will be a feature
based parametric modeler with a modular software architecture which makes it
easy to provide additional functionality without modifying the core system.

%package docs
Summary: Documentation for FreeCAD
Group: Documentation
#BuildArch: noarch
Provides:  free-cad-docs = %version-%release
Obsoletes: free-cad-docs < %version-%release
Requires: qt5-assistant

%description docs
FreeCAD will be a general purpose 3D CAD modeler. FreeCAD is aimed directly at
mechanical engineering and product design but also fits in a wider range of uses
around engineering, such as architecture or other engineering specialties.

FreeCAD features tools similar to Catia, SolidWorks or Solid Edge, and therefore
also falls into the category of MCAD, PLM, CAx and CAE. It will be a feature
based parametric modeler with a modular software architecture which makes it
easy to provide additional functionality without modifying the core system.

This package contains documentation for FreeCAD.

%prep
%setup
%if_without bundled_libs
# Removed bundled libraries
%patch1 -p1
rm -rf src/3rdParty
%endif
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1

%build
export PATH=$PATH:%_qt5_bindir
%add_optflags -Wl,-rpath,%ldir/lib
# Unable to use ninja-build because
# ninja: error: dependency cycle: src/Mod/TechDraw/Gui/mtextedit.h -> src/Mod/TechDraw/Gui/mtextedit.h
#cmake_insource -GNinja \
%cmake_insource \
	-DBUILD_ENABLE_CXX_STD:STRING="C++14" \
	-DCMAKE_BUILD_TYPE=Release \
	-DCMAKE_INSTALL_DATADIR=%ldir \
	-DCMAKE_INSTALL_DOCDIR=%ldir/doc \
	-DCMAKE_INSTALL_LIBDIR=%ldir/lib \
	-DOPENMPI_INCLUDE_DIRS=%_libdir/openmpi/include \
	-DPYTHON_EXECUTABLE=%__python3 \
	-DFREECAD_LIBPACK_USEPYSIDE=OFF \
	-DBUILD_QT5=ON \
%if_without bundled_libs
	-DFREECAD_USE_EXTERNAL_SMESH=ON \
	-DSMESH_DIR=%_libdir/cmake \
	-DSMESH_INCLUDE_DIR=%_includedir/smesh \
	-DBUILD_FEM_NETGEN=ON \
%endif
%if_with glvnd
	-DOpenGL_GL_PREFERENCE=GLVND \
%endif
	-DFREECAD_USE_EXTERNAL_PIVY=ON \
	-Wno-dev
export NPROCS=%build_parallel_jobs
%make_build

%install
%makeinstall_std

# binaries
mkdir -p %buildroot%ldir/bin
mv %buildroot%_bindir/* %buildroot%ldir/bin
ln -s ../%_lib/%name/bin/FreeCAD %buildroot%_bindir/freecad
ln -s ../%_lib/%name/bin/FreeCADCmd %buildroot%_bindir/freecadcmd
ln -s ../%_lib/%name/bin/FreeCAD %buildroot%_bindir/FreeCAD
ln -s ../%_lib/%name/bin/FreeCADCmd %buildroot%_bindir/FreeCADCmd

# manpage
install -Dm0644 %SOURCE1 %buildroot%_man1dir/%name.1

# stuff
cp -af %buildroot%_prefix/Mod/* %buildroot%ldir/Mod
rm -rf %buildroot%_prefix/Mod
cp -af %buildroot%_prefix/Ext/ %buildroot%ldir/Ext
rm -rf %buildroot%_prefix/Ext

# l10n
%find_lang --with-kde %name

# fix python shebang
sed -i '1s:^#!/usr/bin/env python$:#!/usr/bin/python3:' %buildroot%_libdir/freecad/Mod/AddonManager/AddonManager.py \
						       %buildroot%_libdir/freecad/Mod/Spreadsheet/importXLSX.py \
						       %buildroot%_libdir/freecad/Mod/TechDraw/TDTest/DHatchTest.py \
						       %buildroot%_libdir/freecad/Mod/TechDraw/TDTest/DProjGroupTest.py \
						       %buildroot%_libdir/freecad/Mod/TechDraw/TDTest/DVAnnoSymImageTest.py \
						       %buildroot%_libdir/freecad/Mod/TechDraw/TDTest/DVBalloonTest.py \
						       %buildroot%_libdir/freecad/Mod/TechDraw/TDTest/DVDimensionTest.py \
						       %buildroot%_libdir/freecad/Mod/TechDraw/TDTest/DVPartTest.py \
						       %buildroot%_libdir/freecad/Mod/TechDraw/TDTest/DVSectionTest.py \
						       %buildroot%_libdir/freecad/Mod/Test/testmakeWireString.py
sed -i '1s:#!/usr/bin/python:#!/usr/bin/python3:' %buildroot%_libdir/freecad/Mod/Robot/MovieTool.py


%files -f %name.lang
%doc ChangeLog.txt README.md
%doc %ldir/License.txt
%dir %ldir
%_bindir/*
%ldir/bin
%ldir/lib
%ldir/Gui
%ldir/Ext
%ldir/Mod
%ldir/3Dconnexion
%ldir/examples
%_desktopdir/*.desktop
%_iconsdir/hicolor/*/apps/%name.*
%_man1dir/*
%_xdgdatadir/mime/packages/*
%_pixmapsdir/%name.xpm
%_datadir/metainfo/*.appdata.xml
%_datadir/thumbnailers/FreeCAD.thumbnailer

%files docs
%ldir/doc

%changelog
