Group: Games/Arcade
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-install libglvnd-devel zlib-devel
# END SourceDeps(oneline)
%define _libexecdir %_prefix/libexec
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global commit a7ef3bfa0c32df4852bf057fab969c1a080edf4d
%global shortcommit %(c=%{commit}; echo ${c:0:7})

Name:           frogatto
Version:        1.3.3
Release:        alt3_19
Summary:        An old-school 2D platform game

# Artwork and music not released under an open license
License:        GPLv3+ and proprietary
URL:            http://www.frogatto.com/
Source0:        https://github.com/frogatto/frogatto/archive/%{commit}/%{name}-%{version}-%{shortcommit}.tar.gz
Source1:        %{name}.sh
Source2:        %{name}.desktop
Source3:        %{name}.pod
Source4:        %{name}.appdata.xml
# Patch Makefile not to link lSDLmain
Patch0:         %{name}-1.2-Makefile.patch
# Boost no longer has separate non mt and -mt variants of its libs
Patch1:         %{name}-1.3-no-boost-mt.patch
# Use FreeFont instead of the Ubuntu Font Family
Patch2:         %{name}-1.3-fonts.patch
# Fix gcc6 build only fixes some of the narrowing conversion warnings, there
# are too many, so we add -Wno-narrowing to the CXXFLAGS as a workaround
Patch3:         %{name}-1.3-narrowing-conversion-fixes.patch
# Fix comparison between pointer and integer errors
# https://github.com/anura-engine/anura/commit/18ad198565f7a3280d991a5878316f6e5c9351d3
Patch4:         %{name}-1.3-comparison.patch
# Fix building with Boost 1.70+
Patch5:         %{name}-1.3-boost.patch

# We have problems with these architectures
# https://lists.rpmfusion.org/archives/list/rpmfusion-developers@lists.rpmfusion.org/thread/LQXC5S37G6S4NRZNB7KKGD2Q25OKXSEV/
ExcludeArch:    ppc64 ppc64le aarch64

BuildRequires:  gcc-c++
BuildRequires:  libSDL-devel >= 1.2.7
BuildRequires:  libSDL_image-devel
BuildRequires:  libSDL_mixer-devel
BuildRequires:  libSDL_ttf-devel >= 2.0.8
BuildRequires:  libGLU-devel
BuildRequires:  libGLEW-devel
BuildRequires:  libpng-devel
BuildRequires:  ccache
BuildRequires:  boost-complete
BuildRequires:  perl-podlators
BuildRequires:  libicns-utils
BuildRequires:  desktop-file-utils 
BuildRequires:  libappstream-glib
Requires:       icon-theme-hicolor
Requires:       fonts-ttf-gnu-freefont-mono
Source44: import.info
Requires: %name-gamedata = %version-%release


%description
An old-school 2D platform game, starring a certain quixotic frog. Frogatto
has gorgeous, high-end pixel art, pumping arcade tunes, and all the gameplay 
nuance of a classic console title. Run and jump over pits and enemies. Grab 
enemies with your tongue, swallow them, and then spit them out at other enemies 
as projectiles! Fight dangerous bosses, and solve vexing puzzles. Collect coins 
and use them to buy upgrades and new abilities in the store. Talk to characters 
in game, and work to unravel Big Bad Milgram's plot against the townsfolk! 

%package gamedata
Summary: Game data for frogatto
License: distributable
Group: Games/Arcade
# We split game data to separate package to make it noarch and thus save
# bandwidth and space on distribution media.
BuildArch: noarch

%description gamedata
Game data for frogatto.



%prep
%setup -qn %{name}-%{commit}
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p0

# Fix locale file path
sed -i 's!"./locale/"!"%{_datadir}/locale/"!' src/i18n.cpp


%build
%make_build \
  BASE_CXXFLAGS="$RPM_OPT_FLAGS -fno-inline-functions -fthreadsafe-statics -Wno-narrowing"


%install
# Install wrapper script
install -d %{buildroot}%{_bindir}
install -m 755 -p %{SOURCE1} %{buildroot}%{_bindir}/%{name}

# Install game and data
install -d %{buildroot}%{_libexecdir}/%{name}
install -m 755 -p game %{buildroot}%{_libexecdir}/%{name}
install -d %{buildroot}%{_datadir}/%{name}/modules/%{name}
cp -pr data images music *.cfg \
  %{buildroot}%{_datadir}/%{name}
pushd modules/%{name}
  cp -pr data images music sounds *.cfg \
    %{buildroot}%{_datadir}/%{name}/modules/%{name}
  # Install translations
  cp -pr locale %{buildroot}%{_datadir}
popd

# Install desktop file
install -d %{buildroot}%{_datadir}/applications
desktop-file-install \
  --dir %{buildroot}%{_datadir}/applications \
  %{SOURCE2}

# Extract Mac OS X icons
icns2png -x modules/%{name}/images/os/mac/icon.icns 

# Install icons
for i in 16 32 128 256; do
  install -d -m 755 %{buildroot}%{_datadir}/icons/hicolor/${i}x${i}/apps
  install -m 644 icon_${i}x${i}x32.png \
    %{buildroot}%{_datadir}/icons/hicolor/${i}x${i}/apps/%{name}.png
done

# Install man page
install -d %{buildroot}%{_mandir}/man6
pod2man --section=6 \
  -center="RPM Fusion contributed man pages" \
  -release="%{name} %{version}" \
  -date="July 13th, 2010" \
  %{SOURCE3} > %{buildroot}%{_mandir}/man6/%{name}.6

# Install AppData file
install -d %{buildroot}%{_datadir}/metainfo
install -p -m 644 %{SOURCE4} %{buildroot}%{_datadir}/metainfo
appstream-util validate-relax --nonet \
  %{buildroot}/%{_datadir}/metainfo/*.appdata.xml


%find_lang %{name}


%files -f %{name}.lang
%doc modules/%{name}/CHANGELOG
%{_bindir}/%{name}
%{_libexecdir}/%{name}

%files gamedata
%doc --no-dereference LICENSE
%{_datadir}/%{name}
%{_datadir}/icons/hicolor/*/apps/%{name}.png
%{_datadir}/applications/%{name}.desktop
%{_datadir}/metainfo/%{name}.appdata.xml
%{_mandir}/man6/%{name}.6*



%changelog
