Name:    gcompris-qt
Version: 4.3
Release: alt1
Summary: Educational suite for kids 2-10 years old
Summary(ru_RU.UTF8): Набор образовательных игр для детей от 2 до 10 лет

License: GPL-3.0
Group:   Games/Educational
URL:     http://www.gcompris.net

Source:  %name-%version.tar
Source1: submodules.tar
Source2: gcompris_qt.po
Source3: gcompris_voices.po

Packager: Andrey Cherepanov <cas@altlinux.org>

BuildRequires(pre): cmake
BuildRequires: gcc-c++
BuildRequires: extra-cmake-modules
BuildRequires: qt5-base-devel
BuildRequires: qt5-declarative-devel
BuildRequires: qt5-multimedia-devel
BuildRequires: qt5-sensors-devel
BuildRequires: qt5-svg-devel
BuildRequires: qt5-tools-devel
BuildRequires: qt5-xmlpatterns-devel
BuildRequires: libssl-devel
BuildRequires: kf5-kdoctools-devel
BuildRequires: kf5-kdoctools-devel-static
BuildRequires: qt5-quickcontrols2-devel
BuildRequires: qt5-charts-devel

Requires: libqt5-multimedia
Requires: libqt5-svg
Requires: qt5-graphicaleffects
Requires: qt5-quickcontrols2
Requires: libqt5-quickcontrols2
Requires: libqt5-quickparticles
Requires: chess sqlite3 gnucap tuxpaint
# needed for sound support
Requires: gst-plugins-base1.0

%description
GCompris / I Got IT is an educationnal game for children starting at 2.
More than 150 different activities are proposed:
* Click on the animals => learn the mouse/click usage
* Type the falling letters => learn the keyboard usage
* Falling Dices
* Falling words
* Basic algebra
* Time learning with an analog clock
* Puzzle game with famous paintings
* Drive Plane to catch clouds in increasing number
* Balance the scales
* And much more...

%description -l ru_RU.UTF8
GCompris - набор образовательных игр и программ для детей от двух лет
Предоставляется более 150 различных обучающих игр:
* Обучение использованию мыши
* Обучение использованию клавиатуры
* Падающие кубики
* Падающие слова
* Основы счёта
* Обучение времени
* Паззл с известными картинами
* На летящем самолёте ловить облака с возрастающими цифрами
* И многое другое...

%prep
%setup
tar xf %SOURCE1
install -Dpm0644 %SOURCE2 poqm/ru/gcompris_qt.po
install -Dpm0644 %SOURCE3 po/ru/gcompris_voices.po
# Remove geography activity due to non actial maps
subst '/geography/d' src/activities/activities.txt

%build
%cmake \
       -DKDE_INSTALL_APPDIR=%_desktopdir \
       -DKDE_INSTALL_METAINFODIR=%_datadir/metainfo
%cmake_build

%install
%cmakeinstall_std
%find_lang --with-qt %name

%files -f %name.lang
%doc README README.md
%_bindir/%name
%_libexecdir/qml/Box2D.2.0
%dir %_datadir/%name
%dir %_datadir/%name/translations
%_datadir/%name/rcc
%_desktopdir/*.desktop
%_datadir/metainfo/*.appdata.xml
%_iconsdir/hicolor/*/apps/%name.*

%changelog
